/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.visionai.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.visionai.v1.Channel;
import com.google.cloud.visionai.v1.Cluster;
import com.google.cloud.visionai.v1.CreateClusterRequest;
import com.google.cloud.visionai.v1.CreateEventRequest;
import com.google.cloud.visionai.v1.CreateSeriesRequest;
import com.google.cloud.visionai.v1.CreateStreamRequest;
import com.google.cloud.visionai.v1.DeleteClusterRequest;
import com.google.cloud.visionai.v1.DeleteEventRequest;
import com.google.cloud.visionai.v1.DeleteSeriesRequest;
import com.google.cloud.visionai.v1.DeleteStreamRequest;
import com.google.cloud.visionai.v1.Event;
import com.google.cloud.visionai.v1.GenerateStreamHlsTokenRequest;
import com.google.cloud.visionai.v1.GenerateStreamHlsTokenResponse;
import com.google.cloud.visionai.v1.GetClusterRequest;
import com.google.cloud.visionai.v1.GetEventRequest;
import com.google.cloud.visionai.v1.GetSeriesRequest;
import com.google.cloud.visionai.v1.GetStreamRequest;
import com.google.cloud.visionai.v1.GetStreamThumbnailRequest;
import com.google.cloud.visionai.v1.GetStreamThumbnailResponse;
import com.google.cloud.visionai.v1.ListClustersRequest;
import com.google.cloud.visionai.v1.ListClustersResponse;
import com.google.cloud.visionai.v1.ListEventsRequest;
import com.google.cloud.visionai.v1.ListEventsResponse;
import com.google.cloud.visionai.v1.ListSeriesRequest;
import com.google.cloud.visionai.v1.ListSeriesResponse;
import com.google.cloud.visionai.v1.ListStreamsRequest;
import com.google.cloud.visionai.v1.ListStreamsResponse;
import com.google.cloud.visionai.v1.MaterializeChannelRequest;
import com.google.cloud.visionai.v1.OperationMetadata;
import com.google.cloud.visionai.v1.Series;
import com.google.cloud.visionai.v1.Stream;
import com.google.cloud.visionai.v1.StreamsServiceClient;
import com.google.cloud.visionai.v1.UpdateClusterRequest;
import com.google.cloud.visionai.v1.UpdateEventRequest;
import com.google.cloud.visionai.v1.UpdateSeriesRequest;
import com.google.cloud.visionai.v1.UpdateStreamRequest;
import com.google.cloud.visionai.v1.stub.GrpcStreamsServiceStub;
import com.google.cloud.visionai.v1.stub.HttpJsonStreamsServiceStub;
import com.google.cloud.visionai.v1.stub.StreamsServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class StreamsServiceStubSettings
extends StubSettings<StreamsServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<ListClustersRequest, ListClustersResponse, StreamsServiceClient.ListClustersPagedResponse> listClustersSettings;
    private final UnaryCallSettings<GetClusterRequest, Cluster> getClusterSettings;
    private final UnaryCallSettings<CreateClusterRequest, Operation> createClusterSettings;
    private final OperationCallSettings<CreateClusterRequest, Cluster, OperationMetadata> createClusterOperationSettings;
    private final UnaryCallSettings<UpdateClusterRequest, Operation> updateClusterSettings;
    private final OperationCallSettings<UpdateClusterRequest, Cluster, OperationMetadata> updateClusterOperationSettings;
    private final UnaryCallSettings<DeleteClusterRequest, Operation> deleteClusterSettings;
    private final OperationCallSettings<DeleteClusterRequest, Empty, OperationMetadata> deleteClusterOperationSettings;
    private final PagedCallSettings<ListStreamsRequest, ListStreamsResponse, StreamsServiceClient.ListStreamsPagedResponse> listStreamsSettings;
    private final UnaryCallSettings<GetStreamRequest, Stream> getStreamSettings;
    private final UnaryCallSettings<CreateStreamRequest, Operation> createStreamSettings;
    private final OperationCallSettings<CreateStreamRequest, Stream, OperationMetadata> createStreamOperationSettings;
    private final UnaryCallSettings<UpdateStreamRequest, Operation> updateStreamSettings;
    private final OperationCallSettings<UpdateStreamRequest, Stream, OperationMetadata> updateStreamOperationSettings;
    private final UnaryCallSettings<DeleteStreamRequest, Operation> deleteStreamSettings;
    private final OperationCallSettings<DeleteStreamRequest, Empty, OperationMetadata> deleteStreamOperationSettings;
    private final UnaryCallSettings<GetStreamThumbnailRequest, Operation> getStreamThumbnailSettings;
    private final OperationCallSettings<GetStreamThumbnailRequest, GetStreamThumbnailResponse, OperationMetadata> getStreamThumbnailOperationSettings;
    private final UnaryCallSettings<GenerateStreamHlsTokenRequest, GenerateStreamHlsTokenResponse> generateStreamHlsTokenSettings;
    private final PagedCallSettings<ListEventsRequest, ListEventsResponse, StreamsServiceClient.ListEventsPagedResponse> listEventsSettings;
    private final UnaryCallSettings<GetEventRequest, Event> getEventSettings;
    private final UnaryCallSettings<CreateEventRequest, Operation> createEventSettings;
    private final OperationCallSettings<CreateEventRequest, Event, OperationMetadata> createEventOperationSettings;
    private final UnaryCallSettings<UpdateEventRequest, Operation> updateEventSettings;
    private final OperationCallSettings<UpdateEventRequest, Event, OperationMetadata> updateEventOperationSettings;
    private final UnaryCallSettings<DeleteEventRequest, Operation> deleteEventSettings;
    private final OperationCallSettings<DeleteEventRequest, Empty, OperationMetadata> deleteEventOperationSettings;
    private final PagedCallSettings<ListSeriesRequest, ListSeriesResponse, StreamsServiceClient.ListSeriesPagedResponse> listSeriesSettings;
    private final UnaryCallSettings<GetSeriesRequest, Series> getSeriesSettings;
    private final UnaryCallSettings<CreateSeriesRequest, Operation> createSeriesSettings;
    private final OperationCallSettings<CreateSeriesRequest, Series, OperationMetadata> createSeriesOperationSettings;
    private final UnaryCallSettings<UpdateSeriesRequest, Operation> updateSeriesSettings;
    private final OperationCallSettings<UpdateSeriesRequest, Series, OperationMetadata> updateSeriesOperationSettings;
    private final UnaryCallSettings<DeleteSeriesRequest, Operation> deleteSeriesSettings;
    private final OperationCallSettings<DeleteSeriesRequest, Empty, OperationMetadata> deleteSeriesOperationSettings;
    private final UnaryCallSettings<MaterializeChannelRequest, Operation> materializeChannelSettings;
    private final OperationCallSettings<MaterializeChannelRequest, Channel, OperationMetadata> materializeChannelOperationSettings;
    private static final PagedListDescriptor<ListClustersRequest, ListClustersResponse, Cluster> LIST_CLUSTERS_PAGE_STR_DESC = new PagedListDescriptor<ListClustersRequest, ListClustersResponse, Cluster>(){

        public String emptyToken() {
            return "";
        }

        public ListClustersRequest injectToken(ListClustersRequest payload, String token) {
            return ListClustersRequest.newBuilder((ListClustersRequest)payload).setPageToken(token).build();
        }

        public ListClustersRequest injectPageSize(ListClustersRequest payload, int pageSize) {
            return ListClustersRequest.newBuilder((ListClustersRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListClustersRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListClustersResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Cluster> extractResources(ListClustersResponse payload) {
            return payload.getClustersList();
        }
    };
    private static final PagedListDescriptor<ListStreamsRequest, ListStreamsResponse, Stream> LIST_STREAMS_PAGE_STR_DESC = new PagedListDescriptor<ListStreamsRequest, ListStreamsResponse, Stream>(){

        public String emptyToken() {
            return "";
        }

        public ListStreamsRequest injectToken(ListStreamsRequest payload, String token) {
            return ListStreamsRequest.newBuilder((ListStreamsRequest)payload).setPageToken(token).build();
        }

        public ListStreamsRequest injectPageSize(ListStreamsRequest payload, int pageSize) {
            return ListStreamsRequest.newBuilder((ListStreamsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListStreamsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListStreamsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Stream> extractResources(ListStreamsResponse payload) {
            return payload.getStreamsList();
        }
    };
    private static final PagedListDescriptor<ListEventsRequest, ListEventsResponse, Event> LIST_EVENTS_PAGE_STR_DESC = new PagedListDescriptor<ListEventsRequest, ListEventsResponse, Event>(){

        public String emptyToken() {
            return "";
        }

        public ListEventsRequest injectToken(ListEventsRequest payload, String token) {
            return ListEventsRequest.newBuilder((ListEventsRequest)payload).setPageToken(token).build();
        }

        public ListEventsRequest injectPageSize(ListEventsRequest payload, int pageSize) {
            return ListEventsRequest.newBuilder((ListEventsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListEventsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListEventsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Event> extractResources(ListEventsResponse payload) {
            return payload.getEventsList();
        }
    };
    private static final PagedListDescriptor<ListSeriesRequest, ListSeriesResponse, Series> LIST_SERIES_PAGE_STR_DESC = new PagedListDescriptor<ListSeriesRequest, ListSeriesResponse, Series>(){

        public String emptyToken() {
            return "";
        }

        public ListSeriesRequest injectToken(ListSeriesRequest payload, String token) {
            return ListSeriesRequest.newBuilder((ListSeriesRequest)payload).setPageToken(token).build();
        }

        public ListSeriesRequest injectPageSize(ListSeriesRequest payload, int pageSize) {
            return ListSeriesRequest.newBuilder((ListSeriesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListSeriesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListSeriesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Series> extractResources(ListSeriesResponse payload) {
            return payload.getSeriesList();
        }
    };
    private static final PagedListResponseFactory<ListClustersRequest, ListClustersResponse, StreamsServiceClient.ListClustersPagedResponse> LIST_CLUSTERS_PAGE_STR_FACT = new PagedListResponseFactory<ListClustersRequest, ListClustersResponse, StreamsServiceClient.ListClustersPagedResponse>(){

        public ApiFuture<StreamsServiceClient.ListClustersPagedResponse> getFuturePagedResponse(UnaryCallable<ListClustersRequest, ListClustersResponse> callable, ListClustersRequest request, ApiCallContext context, ApiFuture<ListClustersResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_CLUSTERS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return StreamsServiceClient.ListClustersPagedResponse.createAsync((PageContext<ListClustersRequest, ListClustersResponse, Cluster>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListStreamsRequest, ListStreamsResponse, StreamsServiceClient.ListStreamsPagedResponse> LIST_STREAMS_PAGE_STR_FACT = new PagedListResponseFactory<ListStreamsRequest, ListStreamsResponse, StreamsServiceClient.ListStreamsPagedResponse>(){

        public ApiFuture<StreamsServiceClient.ListStreamsPagedResponse> getFuturePagedResponse(UnaryCallable<ListStreamsRequest, ListStreamsResponse> callable, ListStreamsRequest request, ApiCallContext context, ApiFuture<ListStreamsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_STREAMS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return StreamsServiceClient.ListStreamsPagedResponse.createAsync((PageContext<ListStreamsRequest, ListStreamsResponse, Stream>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListEventsRequest, ListEventsResponse, StreamsServiceClient.ListEventsPagedResponse> LIST_EVENTS_PAGE_STR_FACT = new PagedListResponseFactory<ListEventsRequest, ListEventsResponse, StreamsServiceClient.ListEventsPagedResponse>(){

        public ApiFuture<StreamsServiceClient.ListEventsPagedResponse> getFuturePagedResponse(UnaryCallable<ListEventsRequest, ListEventsResponse> callable, ListEventsRequest request, ApiCallContext context, ApiFuture<ListEventsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_EVENTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return StreamsServiceClient.ListEventsPagedResponse.createAsync((PageContext<ListEventsRequest, ListEventsResponse, Event>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListSeriesRequest, ListSeriesResponse, StreamsServiceClient.ListSeriesPagedResponse> LIST_SERIES_PAGE_STR_FACT = new PagedListResponseFactory<ListSeriesRequest, ListSeriesResponse, StreamsServiceClient.ListSeriesPagedResponse>(){

        public ApiFuture<StreamsServiceClient.ListSeriesPagedResponse> getFuturePagedResponse(UnaryCallable<ListSeriesRequest, ListSeriesResponse> callable, ListSeriesRequest request, ApiCallContext context, ApiFuture<ListSeriesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_SERIES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return StreamsServiceClient.ListSeriesPagedResponse.createAsync((PageContext<ListSeriesRequest, ListSeriesResponse, Series>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListClustersRequest, ListClustersResponse, StreamsServiceClient.ListClustersPagedResponse> listClustersSettings() {
        return this.listClustersSettings;
    }

    public UnaryCallSettings<GetClusterRequest, Cluster> getClusterSettings() {
        return this.getClusterSettings;
    }

    public UnaryCallSettings<CreateClusterRequest, Operation> createClusterSettings() {
        return this.createClusterSettings;
    }

    public OperationCallSettings<CreateClusterRequest, Cluster, OperationMetadata> createClusterOperationSettings() {
        return this.createClusterOperationSettings;
    }

    public UnaryCallSettings<UpdateClusterRequest, Operation> updateClusterSettings() {
        return this.updateClusterSettings;
    }

    public OperationCallSettings<UpdateClusterRequest, Cluster, OperationMetadata> updateClusterOperationSettings() {
        return this.updateClusterOperationSettings;
    }

    public UnaryCallSettings<DeleteClusterRequest, Operation> deleteClusterSettings() {
        return this.deleteClusterSettings;
    }

    public OperationCallSettings<DeleteClusterRequest, Empty, OperationMetadata> deleteClusterOperationSettings() {
        return this.deleteClusterOperationSettings;
    }

    public PagedCallSettings<ListStreamsRequest, ListStreamsResponse, StreamsServiceClient.ListStreamsPagedResponse> listStreamsSettings() {
        return this.listStreamsSettings;
    }

    public UnaryCallSettings<GetStreamRequest, Stream> getStreamSettings() {
        return this.getStreamSettings;
    }

    public UnaryCallSettings<CreateStreamRequest, Operation> createStreamSettings() {
        return this.createStreamSettings;
    }

    public OperationCallSettings<CreateStreamRequest, Stream, OperationMetadata> createStreamOperationSettings() {
        return this.createStreamOperationSettings;
    }

    public UnaryCallSettings<UpdateStreamRequest, Operation> updateStreamSettings() {
        return this.updateStreamSettings;
    }

    public OperationCallSettings<UpdateStreamRequest, Stream, OperationMetadata> updateStreamOperationSettings() {
        return this.updateStreamOperationSettings;
    }

    public UnaryCallSettings<DeleteStreamRequest, Operation> deleteStreamSettings() {
        return this.deleteStreamSettings;
    }

    public OperationCallSettings<DeleteStreamRequest, Empty, OperationMetadata> deleteStreamOperationSettings() {
        return this.deleteStreamOperationSettings;
    }

    public UnaryCallSettings<GetStreamThumbnailRequest, Operation> getStreamThumbnailSettings() {
        return this.getStreamThumbnailSettings;
    }

    public OperationCallSettings<GetStreamThumbnailRequest, GetStreamThumbnailResponse, OperationMetadata> getStreamThumbnailOperationSettings() {
        return this.getStreamThumbnailOperationSettings;
    }

    public UnaryCallSettings<GenerateStreamHlsTokenRequest, GenerateStreamHlsTokenResponse> generateStreamHlsTokenSettings() {
        return this.generateStreamHlsTokenSettings;
    }

    public PagedCallSettings<ListEventsRequest, ListEventsResponse, StreamsServiceClient.ListEventsPagedResponse> listEventsSettings() {
        return this.listEventsSettings;
    }

    public UnaryCallSettings<GetEventRequest, Event> getEventSettings() {
        return this.getEventSettings;
    }

    public UnaryCallSettings<CreateEventRequest, Operation> createEventSettings() {
        return this.createEventSettings;
    }

    public OperationCallSettings<CreateEventRequest, Event, OperationMetadata> createEventOperationSettings() {
        return this.createEventOperationSettings;
    }

    public UnaryCallSettings<UpdateEventRequest, Operation> updateEventSettings() {
        return this.updateEventSettings;
    }

    public OperationCallSettings<UpdateEventRequest, Event, OperationMetadata> updateEventOperationSettings() {
        return this.updateEventOperationSettings;
    }

    public UnaryCallSettings<DeleteEventRequest, Operation> deleteEventSettings() {
        return this.deleteEventSettings;
    }

    public OperationCallSettings<DeleteEventRequest, Empty, OperationMetadata> deleteEventOperationSettings() {
        return this.deleteEventOperationSettings;
    }

    public PagedCallSettings<ListSeriesRequest, ListSeriesResponse, StreamsServiceClient.ListSeriesPagedResponse> listSeriesSettings() {
        return this.listSeriesSettings;
    }

    public UnaryCallSettings<GetSeriesRequest, Series> getSeriesSettings() {
        return this.getSeriesSettings;
    }

    public UnaryCallSettings<CreateSeriesRequest, Operation> createSeriesSettings() {
        return this.createSeriesSettings;
    }

    public OperationCallSettings<CreateSeriesRequest, Series, OperationMetadata> createSeriesOperationSettings() {
        return this.createSeriesOperationSettings;
    }

    public UnaryCallSettings<UpdateSeriesRequest, Operation> updateSeriesSettings() {
        return this.updateSeriesSettings;
    }

    public OperationCallSettings<UpdateSeriesRequest, Series, OperationMetadata> updateSeriesOperationSettings() {
        return this.updateSeriesOperationSettings;
    }

    public UnaryCallSettings<DeleteSeriesRequest, Operation> deleteSeriesSettings() {
        return this.deleteSeriesSettings;
    }

    public OperationCallSettings<DeleteSeriesRequest, Empty, OperationMetadata> deleteSeriesOperationSettings() {
        return this.deleteSeriesOperationSettings;
    }

    public UnaryCallSettings<MaterializeChannelRequest, Operation> materializeChannelSettings() {
        return this.materializeChannelSettings;
    }

    public OperationCallSettings<MaterializeChannelRequest, Channel, OperationMetadata> materializeChannelOperationSettings() {
        return this.materializeChannelOperationSettings;
    }

    public StreamsServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcStreamsServiceStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonStreamsServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "visionai";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "visionai.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "visionai.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return StreamsServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(StreamsServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(StreamsServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return StreamsServiceStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected StreamsServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listClustersSettings = settingsBuilder.listClustersSettings().build();
        this.getClusterSettings = settingsBuilder.getClusterSettings().build();
        this.createClusterSettings = settingsBuilder.createClusterSettings().build();
        this.createClusterOperationSettings = settingsBuilder.createClusterOperationSettings().build();
        this.updateClusterSettings = settingsBuilder.updateClusterSettings().build();
        this.updateClusterOperationSettings = settingsBuilder.updateClusterOperationSettings().build();
        this.deleteClusterSettings = settingsBuilder.deleteClusterSettings().build();
        this.deleteClusterOperationSettings = settingsBuilder.deleteClusterOperationSettings().build();
        this.listStreamsSettings = settingsBuilder.listStreamsSettings().build();
        this.getStreamSettings = settingsBuilder.getStreamSettings().build();
        this.createStreamSettings = settingsBuilder.createStreamSettings().build();
        this.createStreamOperationSettings = settingsBuilder.createStreamOperationSettings().build();
        this.updateStreamSettings = settingsBuilder.updateStreamSettings().build();
        this.updateStreamOperationSettings = settingsBuilder.updateStreamOperationSettings().build();
        this.deleteStreamSettings = settingsBuilder.deleteStreamSettings().build();
        this.deleteStreamOperationSettings = settingsBuilder.deleteStreamOperationSettings().build();
        this.getStreamThumbnailSettings = settingsBuilder.getStreamThumbnailSettings().build();
        this.getStreamThumbnailOperationSettings = settingsBuilder.getStreamThumbnailOperationSettings().build();
        this.generateStreamHlsTokenSettings = settingsBuilder.generateStreamHlsTokenSettings().build();
        this.listEventsSettings = settingsBuilder.listEventsSettings().build();
        this.getEventSettings = settingsBuilder.getEventSettings().build();
        this.createEventSettings = settingsBuilder.createEventSettings().build();
        this.createEventOperationSettings = settingsBuilder.createEventOperationSettings().build();
        this.updateEventSettings = settingsBuilder.updateEventSettings().build();
        this.updateEventOperationSettings = settingsBuilder.updateEventOperationSettings().build();
        this.deleteEventSettings = settingsBuilder.deleteEventSettings().build();
        this.deleteEventOperationSettings = settingsBuilder.deleteEventOperationSettings().build();
        this.listSeriesSettings = settingsBuilder.listSeriesSettings().build();
        this.getSeriesSettings = settingsBuilder.getSeriesSettings().build();
        this.createSeriesSettings = settingsBuilder.createSeriesSettings().build();
        this.createSeriesOperationSettings = settingsBuilder.createSeriesOperationSettings().build();
        this.updateSeriesSettings = settingsBuilder.updateSeriesSettings().build();
        this.updateSeriesOperationSettings = settingsBuilder.updateSeriesOperationSettings().build();
        this.deleteSeriesSettings = settingsBuilder.deleteSeriesSettings().build();
        this.deleteSeriesOperationSettings = settingsBuilder.deleteSeriesOperationSettings().build();
        this.materializeChannelSettings = settingsBuilder.materializeChannelSettings().build();
        this.materializeChannelOperationSettings = settingsBuilder.materializeChannelOperationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<StreamsServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListClustersRequest, ListClustersResponse, StreamsServiceClient.ListClustersPagedResponse> listClustersSettings;
        private final UnaryCallSettings.Builder<GetClusterRequest, Cluster> getClusterSettings;
        private final UnaryCallSettings.Builder<CreateClusterRequest, Operation> createClusterSettings;
        private final OperationCallSettings.Builder<CreateClusterRequest, Cluster, OperationMetadata> createClusterOperationSettings;
        private final UnaryCallSettings.Builder<UpdateClusterRequest, Operation> updateClusterSettings;
        private final OperationCallSettings.Builder<UpdateClusterRequest, Cluster, OperationMetadata> updateClusterOperationSettings;
        private final UnaryCallSettings.Builder<DeleteClusterRequest, Operation> deleteClusterSettings;
        private final OperationCallSettings.Builder<DeleteClusterRequest, Empty, OperationMetadata> deleteClusterOperationSettings;
        private final PagedCallSettings.Builder<ListStreamsRequest, ListStreamsResponse, StreamsServiceClient.ListStreamsPagedResponse> listStreamsSettings;
        private final UnaryCallSettings.Builder<GetStreamRequest, Stream> getStreamSettings;
        private final UnaryCallSettings.Builder<CreateStreamRequest, Operation> createStreamSettings;
        private final OperationCallSettings.Builder<CreateStreamRequest, Stream, OperationMetadata> createStreamOperationSettings;
        private final UnaryCallSettings.Builder<UpdateStreamRequest, Operation> updateStreamSettings;
        private final OperationCallSettings.Builder<UpdateStreamRequest, Stream, OperationMetadata> updateStreamOperationSettings;
        private final UnaryCallSettings.Builder<DeleteStreamRequest, Operation> deleteStreamSettings;
        private final OperationCallSettings.Builder<DeleteStreamRequest, Empty, OperationMetadata> deleteStreamOperationSettings;
        private final UnaryCallSettings.Builder<GetStreamThumbnailRequest, Operation> getStreamThumbnailSettings;
        private final OperationCallSettings.Builder<GetStreamThumbnailRequest, GetStreamThumbnailResponse, OperationMetadata> getStreamThumbnailOperationSettings;
        private final UnaryCallSettings.Builder<GenerateStreamHlsTokenRequest, GenerateStreamHlsTokenResponse> generateStreamHlsTokenSettings;
        private final PagedCallSettings.Builder<ListEventsRequest, ListEventsResponse, StreamsServiceClient.ListEventsPagedResponse> listEventsSettings;
        private final UnaryCallSettings.Builder<GetEventRequest, Event> getEventSettings;
        private final UnaryCallSettings.Builder<CreateEventRequest, Operation> createEventSettings;
        private final OperationCallSettings.Builder<CreateEventRequest, Event, OperationMetadata> createEventOperationSettings;
        private final UnaryCallSettings.Builder<UpdateEventRequest, Operation> updateEventSettings;
        private final OperationCallSettings.Builder<UpdateEventRequest, Event, OperationMetadata> updateEventOperationSettings;
        private final UnaryCallSettings.Builder<DeleteEventRequest, Operation> deleteEventSettings;
        private final OperationCallSettings.Builder<DeleteEventRequest, Empty, OperationMetadata> deleteEventOperationSettings;
        private final PagedCallSettings.Builder<ListSeriesRequest, ListSeriesResponse, StreamsServiceClient.ListSeriesPagedResponse> listSeriesSettings;
        private final UnaryCallSettings.Builder<GetSeriesRequest, Series> getSeriesSettings;
        private final UnaryCallSettings.Builder<CreateSeriesRequest, Operation> createSeriesSettings;
        private final OperationCallSettings.Builder<CreateSeriesRequest, Series, OperationMetadata> createSeriesOperationSettings;
        private final UnaryCallSettings.Builder<UpdateSeriesRequest, Operation> updateSeriesSettings;
        private final OperationCallSettings.Builder<UpdateSeriesRequest, Series, OperationMetadata> updateSeriesOperationSettings;
        private final UnaryCallSettings.Builder<DeleteSeriesRequest, Operation> deleteSeriesSettings;
        private final OperationCallSettings.Builder<DeleteSeriesRequest, Empty, OperationMetadata> deleteSeriesOperationSettings;
        private final UnaryCallSettings.Builder<MaterializeChannelRequest, Operation> materializeChannelSettings;
        private final OperationCallSettings.Builder<MaterializeChannelRequest, Channel, OperationMetadata> materializeChannelOperationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listClustersSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_CLUSTERS_PAGE_STR_FACT);
            this.getClusterSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createClusterSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createClusterOperationSettings = OperationCallSettings.newBuilder();
            this.updateClusterSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateClusterOperationSettings = OperationCallSettings.newBuilder();
            this.deleteClusterSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteClusterOperationSettings = OperationCallSettings.newBuilder();
            this.listStreamsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_STREAMS_PAGE_STR_FACT);
            this.getStreamSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createStreamSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createStreamOperationSettings = OperationCallSettings.newBuilder();
            this.updateStreamSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateStreamOperationSettings = OperationCallSettings.newBuilder();
            this.deleteStreamSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteStreamOperationSettings = OperationCallSettings.newBuilder();
            this.getStreamThumbnailSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getStreamThumbnailOperationSettings = OperationCallSettings.newBuilder();
            this.generateStreamHlsTokenSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listEventsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_EVENTS_PAGE_STR_FACT);
            this.getEventSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createEventSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createEventOperationSettings = OperationCallSettings.newBuilder();
            this.updateEventSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateEventOperationSettings = OperationCallSettings.newBuilder();
            this.deleteEventSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteEventOperationSettings = OperationCallSettings.newBuilder();
            this.listSeriesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_SERIES_PAGE_STR_FACT);
            this.getSeriesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createSeriesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createSeriesOperationSettings = OperationCallSettings.newBuilder();
            this.updateSeriesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateSeriesOperationSettings = OperationCallSettings.newBuilder();
            this.deleteSeriesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteSeriesOperationSettings = OperationCallSettings.newBuilder();
            this.materializeChannelSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.materializeChannelOperationSettings = OperationCallSettings.newBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listClustersSettings, this.getClusterSettings, this.createClusterSettings, this.updateClusterSettings, this.deleteClusterSettings, this.listStreamsSettings, this.getStreamSettings, this.createStreamSettings, this.updateStreamSettings, this.deleteStreamSettings, this.getStreamThumbnailSettings, this.generateStreamHlsTokenSettings, (Object[])new UnaryCallSettings.Builder[]{this.listEventsSettings, this.getEventSettings, this.createEventSettings, this.updateEventSettings, this.deleteEventSettings, this.listSeriesSettings, this.getSeriesSettings, this.createSeriesSettings, this.updateSeriesSettings, this.deleteSeriesSettings, this.materializeChannelSettings});
            Builder.initDefaults(this);
        }

        protected Builder(StreamsServiceStubSettings settings) {
            super((StubSettings)settings);
            this.listClustersSettings = settings.listClustersSettings.toBuilder();
            this.getClusterSettings = settings.getClusterSettings.toBuilder();
            this.createClusterSettings = settings.createClusterSettings.toBuilder();
            this.createClusterOperationSettings = settings.createClusterOperationSettings.toBuilder();
            this.updateClusterSettings = settings.updateClusterSettings.toBuilder();
            this.updateClusterOperationSettings = settings.updateClusterOperationSettings.toBuilder();
            this.deleteClusterSettings = settings.deleteClusterSettings.toBuilder();
            this.deleteClusterOperationSettings = settings.deleteClusterOperationSettings.toBuilder();
            this.listStreamsSettings = settings.listStreamsSettings.toBuilder();
            this.getStreamSettings = settings.getStreamSettings.toBuilder();
            this.createStreamSettings = settings.createStreamSettings.toBuilder();
            this.createStreamOperationSettings = settings.createStreamOperationSettings.toBuilder();
            this.updateStreamSettings = settings.updateStreamSettings.toBuilder();
            this.updateStreamOperationSettings = settings.updateStreamOperationSettings.toBuilder();
            this.deleteStreamSettings = settings.deleteStreamSettings.toBuilder();
            this.deleteStreamOperationSettings = settings.deleteStreamOperationSettings.toBuilder();
            this.getStreamThumbnailSettings = settings.getStreamThumbnailSettings.toBuilder();
            this.getStreamThumbnailOperationSettings = settings.getStreamThumbnailOperationSettings.toBuilder();
            this.generateStreamHlsTokenSettings = settings.generateStreamHlsTokenSettings.toBuilder();
            this.listEventsSettings = settings.listEventsSettings.toBuilder();
            this.getEventSettings = settings.getEventSettings.toBuilder();
            this.createEventSettings = settings.createEventSettings.toBuilder();
            this.createEventOperationSettings = settings.createEventOperationSettings.toBuilder();
            this.updateEventSettings = settings.updateEventSettings.toBuilder();
            this.updateEventOperationSettings = settings.updateEventOperationSettings.toBuilder();
            this.deleteEventSettings = settings.deleteEventSettings.toBuilder();
            this.deleteEventOperationSettings = settings.deleteEventOperationSettings.toBuilder();
            this.listSeriesSettings = settings.listSeriesSettings.toBuilder();
            this.getSeriesSettings = settings.getSeriesSettings.toBuilder();
            this.createSeriesSettings = settings.createSeriesSettings.toBuilder();
            this.createSeriesOperationSettings = settings.createSeriesOperationSettings.toBuilder();
            this.updateSeriesSettings = settings.updateSeriesSettings.toBuilder();
            this.updateSeriesOperationSettings = settings.updateSeriesOperationSettings.toBuilder();
            this.deleteSeriesSettings = settings.deleteSeriesSettings.toBuilder();
            this.deleteSeriesOperationSettings = settings.deleteSeriesOperationSettings.toBuilder();
            this.materializeChannelSettings = settings.materializeChannelSettings.toBuilder();
            this.materializeChannelOperationSettings = settings.materializeChannelOperationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listClustersSettings, this.getClusterSettings, this.createClusterSettings, this.updateClusterSettings, this.deleteClusterSettings, this.listStreamsSettings, this.getStreamSettings, this.createStreamSettings, this.updateStreamSettings, this.deleteStreamSettings, this.getStreamThumbnailSettings, this.generateStreamHlsTokenSettings, (Object[])new UnaryCallSettings.Builder[]{this.listEventsSettings, this.getEventSettings, this.createEventSettings, this.updateEventSettings, this.deleteEventSettings, this.listSeriesSettings, this.getSeriesSettings, this.createSeriesSettings, this.updateSeriesSettings, this.deleteSeriesSettings, this.materializeChannelSettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(StreamsServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)StreamsServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)StreamsServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(StreamsServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)StreamsServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)StreamsServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)StreamsServiceStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(StreamsServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listClustersSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getClusterSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createClusterSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.updateClusterSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteClusterSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listStreamsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getStreamSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createStreamSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.updateStreamSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteStreamSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getStreamThumbnailSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.generateStreamHlsTokenSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listEventsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getEventSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createEventSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.updateEventSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteEventSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listSeriesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getSeriesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createSeriesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.updateSeriesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteSeriesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.materializeChannelSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createClusterOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Cluster.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateClusterOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Cluster.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteClusterOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.createStreamOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Stream.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateStreamOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Stream.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteStreamOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.getStreamThumbnailOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(GetStreamThumbnailResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.createEventOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Event.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateEventOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Event.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteEventOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.createSeriesOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Series.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateSeriesOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Series.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteSeriesOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.materializeChannelOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Channel.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListClustersRequest, ListClustersResponse, StreamsServiceClient.ListClustersPagedResponse> listClustersSettings() {
            return this.listClustersSettings;
        }

        public UnaryCallSettings.Builder<GetClusterRequest, Cluster> getClusterSettings() {
            return this.getClusterSettings;
        }

        public UnaryCallSettings.Builder<CreateClusterRequest, Operation> createClusterSettings() {
            return this.createClusterSettings;
        }

        public OperationCallSettings.Builder<CreateClusterRequest, Cluster, OperationMetadata> createClusterOperationSettings() {
            return this.createClusterOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateClusterRequest, Operation> updateClusterSettings() {
            return this.updateClusterSettings;
        }

        public OperationCallSettings.Builder<UpdateClusterRequest, Cluster, OperationMetadata> updateClusterOperationSettings() {
            return this.updateClusterOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteClusterRequest, Operation> deleteClusterSettings() {
            return this.deleteClusterSettings;
        }

        public OperationCallSettings.Builder<DeleteClusterRequest, Empty, OperationMetadata> deleteClusterOperationSettings() {
            return this.deleteClusterOperationSettings;
        }

        public PagedCallSettings.Builder<ListStreamsRequest, ListStreamsResponse, StreamsServiceClient.ListStreamsPagedResponse> listStreamsSettings() {
            return this.listStreamsSettings;
        }

        public UnaryCallSettings.Builder<GetStreamRequest, Stream> getStreamSettings() {
            return this.getStreamSettings;
        }

        public UnaryCallSettings.Builder<CreateStreamRequest, Operation> createStreamSettings() {
            return this.createStreamSettings;
        }

        public OperationCallSettings.Builder<CreateStreamRequest, Stream, OperationMetadata> createStreamOperationSettings() {
            return this.createStreamOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateStreamRequest, Operation> updateStreamSettings() {
            return this.updateStreamSettings;
        }

        public OperationCallSettings.Builder<UpdateStreamRequest, Stream, OperationMetadata> updateStreamOperationSettings() {
            return this.updateStreamOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteStreamRequest, Operation> deleteStreamSettings() {
            return this.deleteStreamSettings;
        }

        public OperationCallSettings.Builder<DeleteStreamRequest, Empty, OperationMetadata> deleteStreamOperationSettings() {
            return this.deleteStreamOperationSettings;
        }

        public UnaryCallSettings.Builder<GetStreamThumbnailRequest, Operation> getStreamThumbnailSettings() {
            return this.getStreamThumbnailSettings;
        }

        public OperationCallSettings.Builder<GetStreamThumbnailRequest, GetStreamThumbnailResponse, OperationMetadata> getStreamThumbnailOperationSettings() {
            return this.getStreamThumbnailOperationSettings;
        }

        public UnaryCallSettings.Builder<GenerateStreamHlsTokenRequest, GenerateStreamHlsTokenResponse> generateStreamHlsTokenSettings() {
            return this.generateStreamHlsTokenSettings;
        }

        public PagedCallSettings.Builder<ListEventsRequest, ListEventsResponse, StreamsServiceClient.ListEventsPagedResponse> listEventsSettings() {
            return this.listEventsSettings;
        }

        public UnaryCallSettings.Builder<GetEventRequest, Event> getEventSettings() {
            return this.getEventSettings;
        }

        public UnaryCallSettings.Builder<CreateEventRequest, Operation> createEventSettings() {
            return this.createEventSettings;
        }

        public OperationCallSettings.Builder<CreateEventRequest, Event, OperationMetadata> createEventOperationSettings() {
            return this.createEventOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateEventRequest, Operation> updateEventSettings() {
            return this.updateEventSettings;
        }

        public OperationCallSettings.Builder<UpdateEventRequest, Event, OperationMetadata> updateEventOperationSettings() {
            return this.updateEventOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteEventRequest, Operation> deleteEventSettings() {
            return this.deleteEventSettings;
        }

        public OperationCallSettings.Builder<DeleteEventRequest, Empty, OperationMetadata> deleteEventOperationSettings() {
            return this.deleteEventOperationSettings;
        }

        public PagedCallSettings.Builder<ListSeriesRequest, ListSeriesResponse, StreamsServiceClient.ListSeriesPagedResponse> listSeriesSettings() {
            return this.listSeriesSettings;
        }

        public UnaryCallSettings.Builder<GetSeriesRequest, Series> getSeriesSettings() {
            return this.getSeriesSettings;
        }

        public UnaryCallSettings.Builder<CreateSeriesRequest, Operation> createSeriesSettings() {
            return this.createSeriesSettings;
        }

        public OperationCallSettings.Builder<CreateSeriesRequest, Series, OperationMetadata> createSeriesOperationSettings() {
            return this.createSeriesOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateSeriesRequest, Operation> updateSeriesSettings() {
            return this.updateSeriesSettings;
        }

        public OperationCallSettings.Builder<UpdateSeriesRequest, Series, OperationMetadata> updateSeriesOperationSettings() {
            return this.updateSeriesOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteSeriesRequest, Operation> deleteSeriesSettings() {
            return this.deleteSeriesSettings;
        }

        public OperationCallSettings.Builder<DeleteSeriesRequest, Empty, OperationMetadata> deleteSeriesOperationSettings() {
            return this.deleteSeriesOperationSettings;
        }

        public UnaryCallSettings.Builder<MaterializeChannelRequest, Operation> materializeChannelSettings() {
            return this.materializeChannelSettings;
        }

        public OperationCallSettings.Builder<MaterializeChannelRequest, Channel, OperationMetadata> materializeChannelOperationSettings() {
            return this.materializeChannelOperationSettings;
        }

        public StreamsServiceStubSettings build() throws IOException {
            return new StreamsServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

