/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.workstations.v1beta;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.grpc.testing.MockServiceHelper;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.workstations.v1beta.CreateWorkstationClusterRequest;
import com.google.cloud.workstations.v1beta.CreateWorkstationConfigRequest;
import com.google.cloud.workstations.v1beta.CreateWorkstationRequest;
import com.google.cloud.workstations.v1beta.DeleteWorkstationClusterRequest;
import com.google.cloud.workstations.v1beta.DeleteWorkstationConfigRequest;
import com.google.cloud.workstations.v1beta.DeleteWorkstationRequest;
import com.google.cloud.workstations.v1beta.GenerateAccessTokenRequest;
import com.google.cloud.workstations.v1beta.GenerateAccessTokenResponse;
import com.google.cloud.workstations.v1beta.GetWorkstationClusterRequest;
import com.google.cloud.workstations.v1beta.GetWorkstationConfigRequest;
import com.google.cloud.workstations.v1beta.GetWorkstationRequest;
import com.google.cloud.workstations.v1beta.ListUsableWorkstationConfigsRequest;
import com.google.cloud.workstations.v1beta.ListUsableWorkstationConfigsResponse;
import com.google.cloud.workstations.v1beta.ListUsableWorkstationsRequest;
import com.google.cloud.workstations.v1beta.ListUsableWorkstationsResponse;
import com.google.cloud.workstations.v1beta.ListWorkstationClustersRequest;
import com.google.cloud.workstations.v1beta.ListWorkstationClustersResponse;
import com.google.cloud.workstations.v1beta.ListWorkstationConfigsRequest;
import com.google.cloud.workstations.v1beta.ListWorkstationConfigsResponse;
import com.google.cloud.workstations.v1beta.ListWorkstationsRequest;
import com.google.cloud.workstations.v1beta.ListWorkstationsResponse;
import com.google.cloud.workstations.v1beta.LocationName;
import com.google.cloud.workstations.v1beta.MockIAMPolicy;
import com.google.cloud.workstations.v1beta.MockLocations;
import com.google.cloud.workstations.v1beta.MockWorkstations;
import com.google.cloud.workstations.v1beta.StartWorkstationRequest;
import com.google.cloud.workstations.v1beta.StopWorkstationRequest;
import com.google.cloud.workstations.v1beta.UpdateWorkstationClusterRequest;
import com.google.cloud.workstations.v1beta.UpdateWorkstationConfigRequest;
import com.google.cloud.workstations.v1beta.UpdateWorkstationRequest;
import com.google.cloud.workstations.v1beta.Workstation;
import com.google.cloud.workstations.v1beta.WorkstationCluster;
import com.google.cloud.workstations.v1beta.WorkstationClusterName;
import com.google.cloud.workstations.v1beta.WorkstationConfig;
import com.google.cloud.workstations.v1beta.WorkstationConfigName;
import com.google.cloud.workstations.v1beta.WorkstationName;
import com.google.cloud.workstations.v1beta.WorkstationsClient;
import com.google.cloud.workstations.v1beta.WorkstationsSettings;
import com.google.common.collect.Lists;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.GetPolicyOptions;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.protobuf.Duration;
import com.google.protobuf.FieldMask;
import com.google.protobuf.Message;
import com.google.protobuf.Timestamp;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class WorkstationsClientTest {
    private static MockIAMPolicy mockIAMPolicy;
    private static MockLocations mockLocations;
    private static MockServiceHelper mockServiceHelper;
    private static MockWorkstations mockWorkstations;
    private LocalChannelProvider channelProvider;
    private WorkstationsClient client;

    @BeforeClass
    public static void startStaticServer() {
        mockWorkstations = new MockWorkstations();
        mockLocations = new MockLocations();
        mockIAMPolicy = new MockIAMPolicy();
        mockServiceHelper = new MockServiceHelper(UUID.randomUUID().toString(), Arrays.asList(mockWorkstations, mockLocations, mockIAMPolicy));
        mockServiceHelper.start();
    }

    @AfterClass
    public static void stopServer() {
        mockServiceHelper.stop();
    }

    @Before
    public void setUp() throws IOException {
        mockServiceHelper.reset();
        this.channelProvider = mockServiceHelper.createChannelProvider();
        WorkstationsSettings settings = ((WorkstationsSettings.Builder)((WorkstationsSettings.Builder)WorkstationsSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)this.channelProvider)).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        this.client = WorkstationsClient.create((WorkstationsSettings)settings);
    }

    @After
    public void tearDown() throws Exception {
        this.client.close();
    }

    @Test
    public void getWorkstationClusterTest() throws Exception {
        WorkstationCluster expectedResponse = WorkstationCluster.newBuilder().setName(WorkstationClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[WORKSTATION_CLUSTER]").toString()).setDisplayName("displayName1714148973").setUid("uid115792").setReconciling(true).putAllAnnotations(new HashMap()).putAllLabels(new HashMap()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setDeleteTime(Timestamp.newBuilder().build()).setEtag("etag3123477").setNetwork("network1843485230").setSubnetwork("subnetwork-1302785042").setControlPlaneIp("controlPlaneIp-1263362938").setPrivateClusterConfig(WorkstationCluster.PrivateClusterConfig.newBuilder().build()).setDegraded(true).addAllConditions(new ArrayList()).build();
        mockWorkstations.addResponse((AbstractMessage)expectedResponse);
        WorkstationClusterName name = WorkstationClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[WORKSTATION_CLUSTER]");
        WorkstationCluster actualResponse = this.client.getWorkstationCluster(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockWorkstations.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetWorkstationClusterRequest actualRequest = (GetWorkstationClusterRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getWorkstationClusterExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWorkstations.addException((Exception)exception);
        try {
            WorkstationClusterName name = WorkstationClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[WORKSTATION_CLUSTER]");
            this.client.getWorkstationCluster(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getWorkstationClusterTest2() throws Exception {
        WorkstationCluster expectedResponse = WorkstationCluster.newBuilder().setName(WorkstationClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[WORKSTATION_CLUSTER]").toString()).setDisplayName("displayName1714148973").setUid("uid115792").setReconciling(true).putAllAnnotations(new HashMap()).putAllLabels(new HashMap()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setDeleteTime(Timestamp.newBuilder().build()).setEtag("etag3123477").setNetwork("network1843485230").setSubnetwork("subnetwork-1302785042").setControlPlaneIp("controlPlaneIp-1263362938").setPrivateClusterConfig(WorkstationCluster.PrivateClusterConfig.newBuilder().build()).setDegraded(true).addAllConditions(new ArrayList()).build();
        mockWorkstations.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        WorkstationCluster actualResponse = this.client.getWorkstationCluster(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockWorkstations.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetWorkstationClusterRequest actualRequest = (GetWorkstationClusterRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getWorkstationClusterExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWorkstations.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getWorkstationCluster(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listWorkstationClustersTest() throws Exception {
        WorkstationCluster responsesElement = WorkstationCluster.newBuilder().build();
        ListWorkstationClustersResponse expectedResponse = ListWorkstationClustersResponse.newBuilder().setNextPageToken("").addAllWorkstationClusters(Arrays.asList(responsesElement)).build();
        mockWorkstations.addResponse((AbstractMessage)expectedResponse);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        WorkstationsClient.ListWorkstationClustersPagedResponse pagedListResponse = this.client.listWorkstationClusters(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getWorkstationClustersList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockWorkstations.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListWorkstationClustersRequest actualRequest = (ListWorkstationClustersRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listWorkstationClustersExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWorkstations.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            this.client.listWorkstationClusters(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listWorkstationClustersTest2() throws Exception {
        WorkstationCluster responsesElement = WorkstationCluster.newBuilder().build();
        ListWorkstationClustersResponse expectedResponse = ListWorkstationClustersResponse.newBuilder().setNextPageToken("").addAllWorkstationClusters(Arrays.asList(responsesElement)).build();
        mockWorkstations.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        WorkstationsClient.ListWorkstationClustersPagedResponse pagedListResponse = this.client.listWorkstationClusters(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getWorkstationClustersList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockWorkstations.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListWorkstationClustersRequest actualRequest = (ListWorkstationClustersRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listWorkstationClustersExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWorkstations.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listWorkstationClusters(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createWorkstationClusterTest() throws Exception {
        WorkstationCluster expectedResponse = WorkstationCluster.newBuilder().setName(WorkstationClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[WORKSTATION_CLUSTER]").toString()).setDisplayName("displayName1714148973").setUid("uid115792").setReconciling(true).putAllAnnotations(new HashMap()).putAllLabels(new HashMap()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setDeleteTime(Timestamp.newBuilder().build()).setEtag("etag3123477").setNetwork("network1843485230").setSubnetwork("subnetwork-1302785042").setControlPlaneIp("controlPlaneIp-1263362938").setPrivateClusterConfig(WorkstationCluster.PrivateClusterConfig.newBuilder().build()).setDegraded(true).addAllConditions(new ArrayList()).build();
        Operation resultOperation = Operation.newBuilder().setName("createWorkstationClusterTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockWorkstations.addResponse((AbstractMessage)resultOperation);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        WorkstationCluster workstationCluster = WorkstationCluster.newBuilder().build();
        String workstationClusterId = "workstationClusterId351421170";
        WorkstationCluster actualResponse = (WorkstationCluster)this.client.createWorkstationClusterAsync(parent, workstationCluster, workstationClusterId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockWorkstations.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateWorkstationClusterRequest actualRequest = (CreateWorkstationClusterRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)workstationCluster, (Object)actualRequest.getWorkstationCluster());
        Assert.assertEquals((Object)workstationClusterId, (Object)actualRequest.getWorkstationClusterId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createWorkstationClusterExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWorkstations.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            WorkstationCluster workstationCluster = WorkstationCluster.newBuilder().build();
            String workstationClusterId = "workstationClusterId351421170";
            this.client.createWorkstationClusterAsync(parent, workstationCluster, workstationClusterId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void createWorkstationClusterTest2() throws Exception {
        WorkstationCluster expectedResponse = WorkstationCluster.newBuilder().setName(WorkstationClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[WORKSTATION_CLUSTER]").toString()).setDisplayName("displayName1714148973").setUid("uid115792").setReconciling(true).putAllAnnotations(new HashMap()).putAllLabels(new HashMap()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setDeleteTime(Timestamp.newBuilder().build()).setEtag("etag3123477").setNetwork("network1843485230").setSubnetwork("subnetwork-1302785042").setControlPlaneIp("controlPlaneIp-1263362938").setPrivateClusterConfig(WorkstationCluster.PrivateClusterConfig.newBuilder().build()).setDegraded(true).addAllConditions(new ArrayList()).build();
        Operation resultOperation = Operation.newBuilder().setName("createWorkstationClusterTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockWorkstations.addResponse((AbstractMessage)resultOperation);
        String parent = "parent-995424086";
        WorkstationCluster workstationCluster = WorkstationCluster.newBuilder().build();
        String workstationClusterId = "workstationClusterId351421170";
        WorkstationCluster actualResponse = (WorkstationCluster)this.client.createWorkstationClusterAsync(parent, workstationCluster, workstationClusterId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockWorkstations.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateWorkstationClusterRequest actualRequest = (CreateWorkstationClusterRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)workstationCluster, (Object)actualRequest.getWorkstationCluster());
        Assert.assertEquals((Object)workstationClusterId, (Object)actualRequest.getWorkstationClusterId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createWorkstationClusterExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWorkstations.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            WorkstationCluster workstationCluster = WorkstationCluster.newBuilder().build();
            String workstationClusterId = "workstationClusterId351421170";
            this.client.createWorkstationClusterAsync(parent, workstationCluster, workstationClusterId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void updateWorkstationClusterTest() throws Exception {
        WorkstationCluster expectedResponse = WorkstationCluster.newBuilder().setName(WorkstationClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[WORKSTATION_CLUSTER]").toString()).setDisplayName("displayName1714148973").setUid("uid115792").setReconciling(true).putAllAnnotations(new HashMap()).putAllLabels(new HashMap()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setDeleteTime(Timestamp.newBuilder().build()).setEtag("etag3123477").setNetwork("network1843485230").setSubnetwork("subnetwork-1302785042").setControlPlaneIp("controlPlaneIp-1263362938").setPrivateClusterConfig(WorkstationCluster.PrivateClusterConfig.newBuilder().build()).setDegraded(true).addAllConditions(new ArrayList()).build();
        Operation resultOperation = Operation.newBuilder().setName("updateWorkstationClusterTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockWorkstations.addResponse((AbstractMessage)resultOperation);
        WorkstationCluster workstationCluster = WorkstationCluster.newBuilder().build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        WorkstationCluster actualResponse = (WorkstationCluster)this.client.updateWorkstationClusterAsync(workstationCluster, updateMask).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockWorkstations.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateWorkstationClusterRequest actualRequest = (UpdateWorkstationClusterRequest)actualRequests.get(0);
        Assert.assertEquals((Object)workstationCluster, (Object)actualRequest.getWorkstationCluster());
        Assert.assertEquals((Object)updateMask, (Object)actualRequest.getUpdateMask());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateWorkstationClusterExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWorkstations.addException((Exception)exception);
        try {
            WorkstationCluster workstationCluster = WorkstationCluster.newBuilder().build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            this.client.updateWorkstationClusterAsync(workstationCluster, updateMask).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void deleteWorkstationClusterTest() throws Exception {
        WorkstationCluster expectedResponse = WorkstationCluster.newBuilder().setName(WorkstationClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[WORKSTATION_CLUSTER]").toString()).setDisplayName("displayName1714148973").setUid("uid115792").setReconciling(true).putAllAnnotations(new HashMap()).putAllLabels(new HashMap()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setDeleteTime(Timestamp.newBuilder().build()).setEtag("etag3123477").setNetwork("network1843485230").setSubnetwork("subnetwork-1302785042").setControlPlaneIp("controlPlaneIp-1263362938").setPrivateClusterConfig(WorkstationCluster.PrivateClusterConfig.newBuilder().build()).setDegraded(true).addAllConditions(new ArrayList()).build();
        Operation resultOperation = Operation.newBuilder().setName("deleteWorkstationClusterTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockWorkstations.addResponse((AbstractMessage)resultOperation);
        WorkstationClusterName name = WorkstationClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[WORKSTATION_CLUSTER]");
        WorkstationCluster actualResponse = (WorkstationCluster)this.client.deleteWorkstationClusterAsync(name).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockWorkstations.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteWorkstationClusterRequest actualRequest = (DeleteWorkstationClusterRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteWorkstationClusterExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWorkstations.addException((Exception)exception);
        try {
            WorkstationClusterName name = WorkstationClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[WORKSTATION_CLUSTER]");
            this.client.deleteWorkstationClusterAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void deleteWorkstationClusterTest2() throws Exception {
        WorkstationCluster expectedResponse = WorkstationCluster.newBuilder().setName(WorkstationClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[WORKSTATION_CLUSTER]").toString()).setDisplayName("displayName1714148973").setUid("uid115792").setReconciling(true).putAllAnnotations(new HashMap()).putAllLabels(new HashMap()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setDeleteTime(Timestamp.newBuilder().build()).setEtag("etag3123477").setNetwork("network1843485230").setSubnetwork("subnetwork-1302785042").setControlPlaneIp("controlPlaneIp-1263362938").setPrivateClusterConfig(WorkstationCluster.PrivateClusterConfig.newBuilder().build()).setDegraded(true).addAllConditions(new ArrayList()).build();
        Operation resultOperation = Operation.newBuilder().setName("deleteWorkstationClusterTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockWorkstations.addResponse((AbstractMessage)resultOperation);
        String name = "name3373707";
        WorkstationCluster actualResponse = (WorkstationCluster)this.client.deleteWorkstationClusterAsync(name).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockWorkstations.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteWorkstationClusterRequest actualRequest = (DeleteWorkstationClusterRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteWorkstationClusterExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWorkstations.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.deleteWorkstationClusterAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void getWorkstationConfigTest() throws Exception {
        WorkstationConfig expectedResponse = WorkstationConfig.newBuilder().setName(WorkstationConfigName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[WORKSTATION_CLUSTER]", (String)"[WORKSTATION_CONFIG]").toString()).setDisplayName("displayName1714148973").setUid("uid115792").setReconciling(true).putAllAnnotations(new HashMap()).putAllLabels(new HashMap()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setDeleteTime(Timestamp.newBuilder().build()).setEtag("etag3123477").setIdleTimeout(Duration.newBuilder().build()).setRunningTimeout(Duration.newBuilder().build()).setHost(WorkstationConfig.Host.newBuilder().build()).addAllPersistentDirectories(new ArrayList()).addAllEphemeralDirectories(new ArrayList()).setContainer(WorkstationConfig.Container.newBuilder().build()).setEncryptionKey(WorkstationConfig.CustomerEncryptionKey.newBuilder().build()).addAllReadinessChecks(new ArrayList()).addAllReplicaZones(new ArrayList()).setDegraded(true).addAllConditions(new ArrayList()).setEnableAuditAgent(true).build();
        mockWorkstations.addResponse((AbstractMessage)expectedResponse);
        WorkstationConfigName name = WorkstationConfigName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[WORKSTATION_CLUSTER]", (String)"[WORKSTATION_CONFIG]");
        WorkstationConfig actualResponse = this.client.getWorkstationConfig(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockWorkstations.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetWorkstationConfigRequest actualRequest = (GetWorkstationConfigRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getWorkstationConfigExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWorkstations.addException((Exception)exception);
        try {
            WorkstationConfigName name = WorkstationConfigName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[WORKSTATION_CLUSTER]", (String)"[WORKSTATION_CONFIG]");
            this.client.getWorkstationConfig(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getWorkstationConfigTest2() throws Exception {
        WorkstationConfig expectedResponse = WorkstationConfig.newBuilder().setName(WorkstationConfigName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[WORKSTATION_CLUSTER]", (String)"[WORKSTATION_CONFIG]").toString()).setDisplayName("displayName1714148973").setUid("uid115792").setReconciling(true).putAllAnnotations(new HashMap()).putAllLabels(new HashMap()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setDeleteTime(Timestamp.newBuilder().build()).setEtag("etag3123477").setIdleTimeout(Duration.newBuilder().build()).setRunningTimeout(Duration.newBuilder().build()).setHost(WorkstationConfig.Host.newBuilder().build()).addAllPersistentDirectories(new ArrayList()).addAllEphemeralDirectories(new ArrayList()).setContainer(WorkstationConfig.Container.newBuilder().build()).setEncryptionKey(WorkstationConfig.CustomerEncryptionKey.newBuilder().build()).addAllReadinessChecks(new ArrayList()).addAllReplicaZones(new ArrayList()).setDegraded(true).addAllConditions(new ArrayList()).setEnableAuditAgent(true).build();
        mockWorkstations.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        WorkstationConfig actualResponse = this.client.getWorkstationConfig(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockWorkstations.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetWorkstationConfigRequest actualRequest = (GetWorkstationConfigRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getWorkstationConfigExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWorkstations.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getWorkstationConfig(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listWorkstationConfigsTest() throws Exception {
        WorkstationConfig responsesElement = WorkstationConfig.newBuilder().build();
        ListWorkstationConfigsResponse expectedResponse = ListWorkstationConfigsResponse.newBuilder().setNextPageToken("").addAllWorkstationConfigs(Arrays.asList(responsesElement)).build();
        mockWorkstations.addResponse((AbstractMessage)expectedResponse);
        WorkstationClusterName parent = WorkstationClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[WORKSTATION_CLUSTER]");
        WorkstationsClient.ListWorkstationConfigsPagedResponse pagedListResponse = this.client.listWorkstationConfigs(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getWorkstationConfigsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockWorkstations.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListWorkstationConfigsRequest actualRequest = (ListWorkstationConfigsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listWorkstationConfigsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWorkstations.addException((Exception)exception);
        try {
            WorkstationClusterName parent = WorkstationClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[WORKSTATION_CLUSTER]");
            this.client.listWorkstationConfigs(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listWorkstationConfigsTest2() throws Exception {
        WorkstationConfig responsesElement = WorkstationConfig.newBuilder().build();
        ListWorkstationConfigsResponse expectedResponse = ListWorkstationConfigsResponse.newBuilder().setNextPageToken("").addAllWorkstationConfigs(Arrays.asList(responsesElement)).build();
        mockWorkstations.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        WorkstationsClient.ListWorkstationConfigsPagedResponse pagedListResponse = this.client.listWorkstationConfigs(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getWorkstationConfigsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockWorkstations.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListWorkstationConfigsRequest actualRequest = (ListWorkstationConfigsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listWorkstationConfigsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWorkstations.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listWorkstationConfigs(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listUsableWorkstationConfigsTest() throws Exception {
        WorkstationConfig responsesElement = WorkstationConfig.newBuilder().build();
        ListUsableWorkstationConfigsResponse expectedResponse = ListUsableWorkstationConfigsResponse.newBuilder().setNextPageToken("").addAllWorkstationConfigs(Arrays.asList(responsesElement)).build();
        mockWorkstations.addResponse((AbstractMessage)expectedResponse);
        WorkstationClusterName parent = WorkstationClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[WORKSTATION_CLUSTER]");
        WorkstationsClient.ListUsableWorkstationConfigsPagedResponse pagedListResponse = this.client.listUsableWorkstationConfigs(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getWorkstationConfigsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockWorkstations.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListUsableWorkstationConfigsRequest actualRequest = (ListUsableWorkstationConfigsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listUsableWorkstationConfigsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWorkstations.addException((Exception)exception);
        try {
            WorkstationClusterName parent = WorkstationClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[WORKSTATION_CLUSTER]");
            this.client.listUsableWorkstationConfigs(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listUsableWorkstationConfigsTest2() throws Exception {
        WorkstationConfig responsesElement = WorkstationConfig.newBuilder().build();
        ListUsableWorkstationConfigsResponse expectedResponse = ListUsableWorkstationConfigsResponse.newBuilder().setNextPageToken("").addAllWorkstationConfigs(Arrays.asList(responsesElement)).build();
        mockWorkstations.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        WorkstationsClient.ListUsableWorkstationConfigsPagedResponse pagedListResponse = this.client.listUsableWorkstationConfigs(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getWorkstationConfigsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockWorkstations.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListUsableWorkstationConfigsRequest actualRequest = (ListUsableWorkstationConfigsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listUsableWorkstationConfigsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWorkstations.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listUsableWorkstationConfigs(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createWorkstationConfigTest() throws Exception {
        WorkstationConfig expectedResponse = WorkstationConfig.newBuilder().setName(WorkstationConfigName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[WORKSTATION_CLUSTER]", (String)"[WORKSTATION_CONFIG]").toString()).setDisplayName("displayName1714148973").setUid("uid115792").setReconciling(true).putAllAnnotations(new HashMap()).putAllLabels(new HashMap()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setDeleteTime(Timestamp.newBuilder().build()).setEtag("etag3123477").setIdleTimeout(Duration.newBuilder().build()).setRunningTimeout(Duration.newBuilder().build()).setHost(WorkstationConfig.Host.newBuilder().build()).addAllPersistentDirectories(new ArrayList()).addAllEphemeralDirectories(new ArrayList()).setContainer(WorkstationConfig.Container.newBuilder().build()).setEncryptionKey(WorkstationConfig.CustomerEncryptionKey.newBuilder().build()).addAllReadinessChecks(new ArrayList()).addAllReplicaZones(new ArrayList()).setDegraded(true).addAllConditions(new ArrayList()).setEnableAuditAgent(true).build();
        Operation resultOperation = Operation.newBuilder().setName("createWorkstationConfigTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockWorkstations.addResponse((AbstractMessage)resultOperation);
        WorkstationClusterName parent = WorkstationClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[WORKSTATION_CLUSTER]");
        WorkstationConfig workstationConfig = WorkstationConfig.newBuilder().build();
        String workstationConfigId = "workstationConfigId798542368";
        WorkstationConfig actualResponse = (WorkstationConfig)this.client.createWorkstationConfigAsync(parent, workstationConfig, workstationConfigId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockWorkstations.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateWorkstationConfigRequest actualRequest = (CreateWorkstationConfigRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)workstationConfig, (Object)actualRequest.getWorkstationConfig());
        Assert.assertEquals((Object)workstationConfigId, (Object)actualRequest.getWorkstationConfigId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createWorkstationConfigExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWorkstations.addException((Exception)exception);
        try {
            WorkstationClusterName parent = WorkstationClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[WORKSTATION_CLUSTER]");
            WorkstationConfig workstationConfig = WorkstationConfig.newBuilder().build();
            String workstationConfigId = "workstationConfigId798542368";
            this.client.createWorkstationConfigAsync(parent, workstationConfig, workstationConfigId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void createWorkstationConfigTest2() throws Exception {
        WorkstationConfig expectedResponse = WorkstationConfig.newBuilder().setName(WorkstationConfigName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[WORKSTATION_CLUSTER]", (String)"[WORKSTATION_CONFIG]").toString()).setDisplayName("displayName1714148973").setUid("uid115792").setReconciling(true).putAllAnnotations(new HashMap()).putAllLabels(new HashMap()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setDeleteTime(Timestamp.newBuilder().build()).setEtag("etag3123477").setIdleTimeout(Duration.newBuilder().build()).setRunningTimeout(Duration.newBuilder().build()).setHost(WorkstationConfig.Host.newBuilder().build()).addAllPersistentDirectories(new ArrayList()).addAllEphemeralDirectories(new ArrayList()).setContainer(WorkstationConfig.Container.newBuilder().build()).setEncryptionKey(WorkstationConfig.CustomerEncryptionKey.newBuilder().build()).addAllReadinessChecks(new ArrayList()).addAllReplicaZones(new ArrayList()).setDegraded(true).addAllConditions(new ArrayList()).setEnableAuditAgent(true).build();
        Operation resultOperation = Operation.newBuilder().setName("createWorkstationConfigTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockWorkstations.addResponse((AbstractMessage)resultOperation);
        String parent = "parent-995424086";
        WorkstationConfig workstationConfig = WorkstationConfig.newBuilder().build();
        String workstationConfigId = "workstationConfigId798542368";
        WorkstationConfig actualResponse = (WorkstationConfig)this.client.createWorkstationConfigAsync(parent, workstationConfig, workstationConfigId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockWorkstations.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateWorkstationConfigRequest actualRequest = (CreateWorkstationConfigRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)workstationConfig, (Object)actualRequest.getWorkstationConfig());
        Assert.assertEquals((Object)workstationConfigId, (Object)actualRequest.getWorkstationConfigId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createWorkstationConfigExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWorkstations.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            WorkstationConfig workstationConfig = WorkstationConfig.newBuilder().build();
            String workstationConfigId = "workstationConfigId798542368";
            this.client.createWorkstationConfigAsync(parent, workstationConfig, workstationConfigId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void updateWorkstationConfigTest() throws Exception {
        WorkstationConfig expectedResponse = WorkstationConfig.newBuilder().setName(WorkstationConfigName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[WORKSTATION_CLUSTER]", (String)"[WORKSTATION_CONFIG]").toString()).setDisplayName("displayName1714148973").setUid("uid115792").setReconciling(true).putAllAnnotations(new HashMap()).putAllLabels(new HashMap()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setDeleteTime(Timestamp.newBuilder().build()).setEtag("etag3123477").setIdleTimeout(Duration.newBuilder().build()).setRunningTimeout(Duration.newBuilder().build()).setHost(WorkstationConfig.Host.newBuilder().build()).addAllPersistentDirectories(new ArrayList()).addAllEphemeralDirectories(new ArrayList()).setContainer(WorkstationConfig.Container.newBuilder().build()).setEncryptionKey(WorkstationConfig.CustomerEncryptionKey.newBuilder().build()).addAllReadinessChecks(new ArrayList()).addAllReplicaZones(new ArrayList()).setDegraded(true).addAllConditions(new ArrayList()).setEnableAuditAgent(true).build();
        Operation resultOperation = Operation.newBuilder().setName("updateWorkstationConfigTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockWorkstations.addResponse((AbstractMessage)resultOperation);
        WorkstationConfig workstationConfig = WorkstationConfig.newBuilder().build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        WorkstationConfig actualResponse = (WorkstationConfig)this.client.updateWorkstationConfigAsync(workstationConfig, updateMask).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockWorkstations.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateWorkstationConfigRequest actualRequest = (UpdateWorkstationConfigRequest)actualRequests.get(0);
        Assert.assertEquals((Object)workstationConfig, (Object)actualRequest.getWorkstationConfig());
        Assert.assertEquals((Object)updateMask, (Object)actualRequest.getUpdateMask());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateWorkstationConfigExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWorkstations.addException((Exception)exception);
        try {
            WorkstationConfig workstationConfig = WorkstationConfig.newBuilder().build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            this.client.updateWorkstationConfigAsync(workstationConfig, updateMask).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void deleteWorkstationConfigTest() throws Exception {
        WorkstationConfig expectedResponse = WorkstationConfig.newBuilder().setName(WorkstationConfigName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[WORKSTATION_CLUSTER]", (String)"[WORKSTATION_CONFIG]").toString()).setDisplayName("displayName1714148973").setUid("uid115792").setReconciling(true).putAllAnnotations(new HashMap()).putAllLabels(new HashMap()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setDeleteTime(Timestamp.newBuilder().build()).setEtag("etag3123477").setIdleTimeout(Duration.newBuilder().build()).setRunningTimeout(Duration.newBuilder().build()).setHost(WorkstationConfig.Host.newBuilder().build()).addAllPersistentDirectories(new ArrayList()).addAllEphemeralDirectories(new ArrayList()).setContainer(WorkstationConfig.Container.newBuilder().build()).setEncryptionKey(WorkstationConfig.CustomerEncryptionKey.newBuilder().build()).addAllReadinessChecks(new ArrayList()).addAllReplicaZones(new ArrayList()).setDegraded(true).addAllConditions(new ArrayList()).setEnableAuditAgent(true).build();
        Operation resultOperation = Operation.newBuilder().setName("deleteWorkstationConfigTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockWorkstations.addResponse((AbstractMessage)resultOperation);
        WorkstationConfigName name = WorkstationConfigName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[WORKSTATION_CLUSTER]", (String)"[WORKSTATION_CONFIG]");
        WorkstationConfig actualResponse = (WorkstationConfig)this.client.deleteWorkstationConfigAsync(name).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockWorkstations.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteWorkstationConfigRequest actualRequest = (DeleteWorkstationConfigRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteWorkstationConfigExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWorkstations.addException((Exception)exception);
        try {
            WorkstationConfigName name = WorkstationConfigName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[WORKSTATION_CLUSTER]", (String)"[WORKSTATION_CONFIG]");
            this.client.deleteWorkstationConfigAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void deleteWorkstationConfigTest2() throws Exception {
        WorkstationConfig expectedResponse = WorkstationConfig.newBuilder().setName(WorkstationConfigName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[WORKSTATION_CLUSTER]", (String)"[WORKSTATION_CONFIG]").toString()).setDisplayName("displayName1714148973").setUid("uid115792").setReconciling(true).putAllAnnotations(new HashMap()).putAllLabels(new HashMap()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setDeleteTime(Timestamp.newBuilder().build()).setEtag("etag3123477").setIdleTimeout(Duration.newBuilder().build()).setRunningTimeout(Duration.newBuilder().build()).setHost(WorkstationConfig.Host.newBuilder().build()).addAllPersistentDirectories(new ArrayList()).addAllEphemeralDirectories(new ArrayList()).setContainer(WorkstationConfig.Container.newBuilder().build()).setEncryptionKey(WorkstationConfig.CustomerEncryptionKey.newBuilder().build()).addAllReadinessChecks(new ArrayList()).addAllReplicaZones(new ArrayList()).setDegraded(true).addAllConditions(new ArrayList()).setEnableAuditAgent(true).build();
        Operation resultOperation = Operation.newBuilder().setName("deleteWorkstationConfigTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockWorkstations.addResponse((AbstractMessage)resultOperation);
        String name = "name3373707";
        WorkstationConfig actualResponse = (WorkstationConfig)this.client.deleteWorkstationConfigAsync(name).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockWorkstations.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteWorkstationConfigRequest actualRequest = (DeleteWorkstationConfigRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteWorkstationConfigExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWorkstations.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.deleteWorkstationConfigAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void getWorkstationTest() throws Exception {
        Workstation expectedResponse = Workstation.newBuilder().setName(WorkstationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[WORKSTATION_CLUSTER]", (String)"[WORKSTATION_CONFIG]", (String)"[WORKSTATION]").toString()).setDisplayName("displayName1714148973").setUid("uid115792").setReconciling(true).putAllAnnotations(new HashMap()).putAllLabels(new HashMap()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setStartTime(Timestamp.newBuilder().build()).setDeleteTime(Timestamp.newBuilder().build()).setEtag("etag3123477").setHost("host3208616").putAllEnv(new HashMap()).build();
        mockWorkstations.addResponse((AbstractMessage)expectedResponse);
        WorkstationName name = WorkstationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[WORKSTATION_CLUSTER]", (String)"[WORKSTATION_CONFIG]", (String)"[WORKSTATION]");
        Workstation actualResponse = this.client.getWorkstation(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockWorkstations.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetWorkstationRequest actualRequest = (GetWorkstationRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getWorkstationExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWorkstations.addException((Exception)exception);
        try {
            WorkstationName name = WorkstationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[WORKSTATION_CLUSTER]", (String)"[WORKSTATION_CONFIG]", (String)"[WORKSTATION]");
            this.client.getWorkstation(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getWorkstationTest2() throws Exception {
        Workstation expectedResponse = Workstation.newBuilder().setName(WorkstationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[WORKSTATION_CLUSTER]", (String)"[WORKSTATION_CONFIG]", (String)"[WORKSTATION]").toString()).setDisplayName("displayName1714148973").setUid("uid115792").setReconciling(true).putAllAnnotations(new HashMap()).putAllLabels(new HashMap()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setStartTime(Timestamp.newBuilder().build()).setDeleteTime(Timestamp.newBuilder().build()).setEtag("etag3123477").setHost("host3208616").putAllEnv(new HashMap()).build();
        mockWorkstations.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        Workstation actualResponse = this.client.getWorkstation(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockWorkstations.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetWorkstationRequest actualRequest = (GetWorkstationRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getWorkstationExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWorkstations.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getWorkstation(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listWorkstationsTest() throws Exception {
        Workstation responsesElement = Workstation.newBuilder().build();
        ListWorkstationsResponse expectedResponse = ListWorkstationsResponse.newBuilder().setNextPageToken("").addAllWorkstations(Arrays.asList(responsesElement)).build();
        mockWorkstations.addResponse((AbstractMessage)expectedResponse);
        WorkstationConfigName parent = WorkstationConfigName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[WORKSTATION_CLUSTER]", (String)"[WORKSTATION_CONFIG]");
        WorkstationsClient.ListWorkstationsPagedResponse pagedListResponse = this.client.listWorkstations(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getWorkstationsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockWorkstations.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListWorkstationsRequest actualRequest = (ListWorkstationsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listWorkstationsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWorkstations.addException((Exception)exception);
        try {
            WorkstationConfigName parent = WorkstationConfigName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[WORKSTATION_CLUSTER]", (String)"[WORKSTATION_CONFIG]");
            this.client.listWorkstations(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listWorkstationsTest2() throws Exception {
        Workstation responsesElement = Workstation.newBuilder().build();
        ListWorkstationsResponse expectedResponse = ListWorkstationsResponse.newBuilder().setNextPageToken("").addAllWorkstations(Arrays.asList(responsesElement)).build();
        mockWorkstations.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        WorkstationsClient.ListWorkstationsPagedResponse pagedListResponse = this.client.listWorkstations(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getWorkstationsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockWorkstations.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListWorkstationsRequest actualRequest = (ListWorkstationsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listWorkstationsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWorkstations.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listWorkstations(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listUsableWorkstationsTest() throws Exception {
        Workstation responsesElement = Workstation.newBuilder().build();
        ListUsableWorkstationsResponse expectedResponse = ListUsableWorkstationsResponse.newBuilder().setNextPageToken("").addAllWorkstations(Arrays.asList(responsesElement)).build();
        mockWorkstations.addResponse((AbstractMessage)expectedResponse);
        WorkstationConfigName parent = WorkstationConfigName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[WORKSTATION_CLUSTER]", (String)"[WORKSTATION_CONFIG]");
        WorkstationsClient.ListUsableWorkstationsPagedResponse pagedListResponse = this.client.listUsableWorkstations(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getWorkstationsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockWorkstations.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListUsableWorkstationsRequest actualRequest = (ListUsableWorkstationsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listUsableWorkstationsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWorkstations.addException((Exception)exception);
        try {
            WorkstationConfigName parent = WorkstationConfigName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[WORKSTATION_CLUSTER]", (String)"[WORKSTATION_CONFIG]");
            this.client.listUsableWorkstations(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listUsableWorkstationsTest2() throws Exception {
        Workstation responsesElement = Workstation.newBuilder().build();
        ListUsableWorkstationsResponse expectedResponse = ListUsableWorkstationsResponse.newBuilder().setNextPageToken("").addAllWorkstations(Arrays.asList(responsesElement)).build();
        mockWorkstations.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        WorkstationsClient.ListUsableWorkstationsPagedResponse pagedListResponse = this.client.listUsableWorkstations(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getWorkstationsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockWorkstations.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListUsableWorkstationsRequest actualRequest = (ListUsableWorkstationsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listUsableWorkstationsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWorkstations.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listUsableWorkstations(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createWorkstationTest() throws Exception {
        Workstation expectedResponse = Workstation.newBuilder().setName(WorkstationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[WORKSTATION_CLUSTER]", (String)"[WORKSTATION_CONFIG]", (String)"[WORKSTATION]").toString()).setDisplayName("displayName1714148973").setUid("uid115792").setReconciling(true).putAllAnnotations(new HashMap()).putAllLabels(new HashMap()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setStartTime(Timestamp.newBuilder().build()).setDeleteTime(Timestamp.newBuilder().build()).setEtag("etag3123477").setHost("host3208616").putAllEnv(new HashMap()).build();
        Operation resultOperation = Operation.newBuilder().setName("createWorkstationTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockWorkstations.addResponse((AbstractMessage)resultOperation);
        WorkstationConfigName parent = WorkstationConfigName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[WORKSTATION_CLUSTER]", (String)"[WORKSTATION_CONFIG]");
        Workstation workstation = Workstation.newBuilder().build();
        String workstationId = "workstationId560540030";
        Workstation actualResponse = (Workstation)this.client.createWorkstationAsync(parent, workstation, workstationId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockWorkstations.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateWorkstationRequest actualRequest = (CreateWorkstationRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)workstation, (Object)actualRequest.getWorkstation());
        Assert.assertEquals((Object)workstationId, (Object)actualRequest.getWorkstationId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createWorkstationExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWorkstations.addException((Exception)exception);
        try {
            WorkstationConfigName parent = WorkstationConfigName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[WORKSTATION_CLUSTER]", (String)"[WORKSTATION_CONFIG]");
            Workstation workstation = Workstation.newBuilder().build();
            String workstationId = "workstationId560540030";
            this.client.createWorkstationAsync(parent, workstation, workstationId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void createWorkstationTest2() throws Exception {
        Workstation expectedResponse = Workstation.newBuilder().setName(WorkstationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[WORKSTATION_CLUSTER]", (String)"[WORKSTATION_CONFIG]", (String)"[WORKSTATION]").toString()).setDisplayName("displayName1714148973").setUid("uid115792").setReconciling(true).putAllAnnotations(new HashMap()).putAllLabels(new HashMap()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setStartTime(Timestamp.newBuilder().build()).setDeleteTime(Timestamp.newBuilder().build()).setEtag("etag3123477").setHost("host3208616").putAllEnv(new HashMap()).build();
        Operation resultOperation = Operation.newBuilder().setName("createWorkstationTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockWorkstations.addResponse((AbstractMessage)resultOperation);
        String parent = "parent-995424086";
        Workstation workstation = Workstation.newBuilder().build();
        String workstationId = "workstationId560540030";
        Workstation actualResponse = (Workstation)this.client.createWorkstationAsync(parent, workstation, workstationId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockWorkstations.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateWorkstationRequest actualRequest = (CreateWorkstationRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)workstation, (Object)actualRequest.getWorkstation());
        Assert.assertEquals((Object)workstationId, (Object)actualRequest.getWorkstationId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createWorkstationExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWorkstations.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            Workstation workstation = Workstation.newBuilder().build();
            String workstationId = "workstationId560540030";
            this.client.createWorkstationAsync(parent, workstation, workstationId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void updateWorkstationTest() throws Exception {
        Workstation expectedResponse = Workstation.newBuilder().setName(WorkstationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[WORKSTATION_CLUSTER]", (String)"[WORKSTATION_CONFIG]", (String)"[WORKSTATION]").toString()).setDisplayName("displayName1714148973").setUid("uid115792").setReconciling(true).putAllAnnotations(new HashMap()).putAllLabels(new HashMap()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setStartTime(Timestamp.newBuilder().build()).setDeleteTime(Timestamp.newBuilder().build()).setEtag("etag3123477").setHost("host3208616").putAllEnv(new HashMap()).build();
        Operation resultOperation = Operation.newBuilder().setName("updateWorkstationTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockWorkstations.addResponse((AbstractMessage)resultOperation);
        Workstation workstation = Workstation.newBuilder().build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        Workstation actualResponse = (Workstation)this.client.updateWorkstationAsync(workstation, updateMask).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockWorkstations.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateWorkstationRequest actualRequest = (UpdateWorkstationRequest)actualRequests.get(0);
        Assert.assertEquals((Object)workstation, (Object)actualRequest.getWorkstation());
        Assert.assertEquals((Object)updateMask, (Object)actualRequest.getUpdateMask());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateWorkstationExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWorkstations.addException((Exception)exception);
        try {
            Workstation workstation = Workstation.newBuilder().build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            this.client.updateWorkstationAsync(workstation, updateMask).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void deleteWorkstationTest() throws Exception {
        Workstation expectedResponse = Workstation.newBuilder().setName(WorkstationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[WORKSTATION_CLUSTER]", (String)"[WORKSTATION_CONFIG]", (String)"[WORKSTATION]").toString()).setDisplayName("displayName1714148973").setUid("uid115792").setReconciling(true).putAllAnnotations(new HashMap()).putAllLabels(new HashMap()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setStartTime(Timestamp.newBuilder().build()).setDeleteTime(Timestamp.newBuilder().build()).setEtag("etag3123477").setHost("host3208616").putAllEnv(new HashMap()).build();
        Operation resultOperation = Operation.newBuilder().setName("deleteWorkstationTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockWorkstations.addResponse((AbstractMessage)resultOperation);
        WorkstationName name = WorkstationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[WORKSTATION_CLUSTER]", (String)"[WORKSTATION_CONFIG]", (String)"[WORKSTATION]");
        Workstation actualResponse = (Workstation)this.client.deleteWorkstationAsync(name).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockWorkstations.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteWorkstationRequest actualRequest = (DeleteWorkstationRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteWorkstationExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWorkstations.addException((Exception)exception);
        try {
            WorkstationName name = WorkstationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[WORKSTATION_CLUSTER]", (String)"[WORKSTATION_CONFIG]", (String)"[WORKSTATION]");
            this.client.deleteWorkstationAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void deleteWorkstationTest2() throws Exception {
        Workstation expectedResponse = Workstation.newBuilder().setName(WorkstationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[WORKSTATION_CLUSTER]", (String)"[WORKSTATION_CONFIG]", (String)"[WORKSTATION]").toString()).setDisplayName("displayName1714148973").setUid("uid115792").setReconciling(true).putAllAnnotations(new HashMap()).putAllLabels(new HashMap()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setStartTime(Timestamp.newBuilder().build()).setDeleteTime(Timestamp.newBuilder().build()).setEtag("etag3123477").setHost("host3208616").putAllEnv(new HashMap()).build();
        Operation resultOperation = Operation.newBuilder().setName("deleteWorkstationTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockWorkstations.addResponse((AbstractMessage)resultOperation);
        String name = "name3373707";
        Workstation actualResponse = (Workstation)this.client.deleteWorkstationAsync(name).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockWorkstations.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteWorkstationRequest actualRequest = (DeleteWorkstationRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteWorkstationExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWorkstations.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.deleteWorkstationAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void startWorkstationTest() throws Exception {
        Workstation expectedResponse = Workstation.newBuilder().setName(WorkstationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[WORKSTATION_CLUSTER]", (String)"[WORKSTATION_CONFIG]", (String)"[WORKSTATION]").toString()).setDisplayName("displayName1714148973").setUid("uid115792").setReconciling(true).putAllAnnotations(new HashMap()).putAllLabels(new HashMap()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setStartTime(Timestamp.newBuilder().build()).setDeleteTime(Timestamp.newBuilder().build()).setEtag("etag3123477").setHost("host3208616").putAllEnv(new HashMap()).build();
        Operation resultOperation = Operation.newBuilder().setName("startWorkstationTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockWorkstations.addResponse((AbstractMessage)resultOperation);
        WorkstationName name = WorkstationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[WORKSTATION_CLUSTER]", (String)"[WORKSTATION_CONFIG]", (String)"[WORKSTATION]");
        Workstation actualResponse = (Workstation)this.client.startWorkstationAsync(name).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockWorkstations.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        StartWorkstationRequest actualRequest = (StartWorkstationRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void startWorkstationExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWorkstations.addException((Exception)exception);
        try {
            WorkstationName name = WorkstationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[WORKSTATION_CLUSTER]", (String)"[WORKSTATION_CONFIG]", (String)"[WORKSTATION]");
            this.client.startWorkstationAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void startWorkstationTest2() throws Exception {
        Workstation expectedResponse = Workstation.newBuilder().setName(WorkstationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[WORKSTATION_CLUSTER]", (String)"[WORKSTATION_CONFIG]", (String)"[WORKSTATION]").toString()).setDisplayName("displayName1714148973").setUid("uid115792").setReconciling(true).putAllAnnotations(new HashMap()).putAllLabels(new HashMap()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setStartTime(Timestamp.newBuilder().build()).setDeleteTime(Timestamp.newBuilder().build()).setEtag("etag3123477").setHost("host3208616").putAllEnv(new HashMap()).build();
        Operation resultOperation = Operation.newBuilder().setName("startWorkstationTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockWorkstations.addResponse((AbstractMessage)resultOperation);
        String name = "name3373707";
        Workstation actualResponse = (Workstation)this.client.startWorkstationAsync(name).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockWorkstations.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        StartWorkstationRequest actualRequest = (StartWorkstationRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void startWorkstationExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWorkstations.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.startWorkstationAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void stopWorkstationTest() throws Exception {
        Workstation expectedResponse = Workstation.newBuilder().setName(WorkstationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[WORKSTATION_CLUSTER]", (String)"[WORKSTATION_CONFIG]", (String)"[WORKSTATION]").toString()).setDisplayName("displayName1714148973").setUid("uid115792").setReconciling(true).putAllAnnotations(new HashMap()).putAllLabels(new HashMap()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setStartTime(Timestamp.newBuilder().build()).setDeleteTime(Timestamp.newBuilder().build()).setEtag("etag3123477").setHost("host3208616").putAllEnv(new HashMap()).build();
        Operation resultOperation = Operation.newBuilder().setName("stopWorkstationTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockWorkstations.addResponse((AbstractMessage)resultOperation);
        WorkstationName name = WorkstationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[WORKSTATION_CLUSTER]", (String)"[WORKSTATION_CONFIG]", (String)"[WORKSTATION]");
        Workstation actualResponse = (Workstation)this.client.stopWorkstationAsync(name).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockWorkstations.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        StopWorkstationRequest actualRequest = (StopWorkstationRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void stopWorkstationExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWorkstations.addException((Exception)exception);
        try {
            WorkstationName name = WorkstationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[WORKSTATION_CLUSTER]", (String)"[WORKSTATION_CONFIG]", (String)"[WORKSTATION]");
            this.client.stopWorkstationAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void stopWorkstationTest2() throws Exception {
        Workstation expectedResponse = Workstation.newBuilder().setName(WorkstationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[WORKSTATION_CLUSTER]", (String)"[WORKSTATION_CONFIG]", (String)"[WORKSTATION]").toString()).setDisplayName("displayName1714148973").setUid("uid115792").setReconciling(true).putAllAnnotations(new HashMap()).putAllLabels(new HashMap()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setStartTime(Timestamp.newBuilder().build()).setDeleteTime(Timestamp.newBuilder().build()).setEtag("etag3123477").setHost("host3208616").putAllEnv(new HashMap()).build();
        Operation resultOperation = Operation.newBuilder().setName("stopWorkstationTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockWorkstations.addResponse((AbstractMessage)resultOperation);
        String name = "name3373707";
        Workstation actualResponse = (Workstation)this.client.stopWorkstationAsync(name).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockWorkstations.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        StopWorkstationRequest actualRequest = (StopWorkstationRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void stopWorkstationExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWorkstations.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.stopWorkstationAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void generateAccessTokenTest() throws Exception {
        GenerateAccessTokenResponse expectedResponse = GenerateAccessTokenResponse.newBuilder().setAccessToken("accessToken-1042689291").setExpireTime(Timestamp.newBuilder().build()).build();
        mockWorkstations.addResponse((AbstractMessage)expectedResponse);
        WorkstationName workstation = WorkstationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[WORKSTATION_CLUSTER]", (String)"[WORKSTATION_CONFIG]", (String)"[WORKSTATION]");
        GenerateAccessTokenResponse actualResponse = this.client.generateAccessToken(workstation);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockWorkstations.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GenerateAccessTokenRequest actualRequest = (GenerateAccessTokenRequest)actualRequests.get(0);
        Assert.assertEquals((Object)workstation.toString(), (Object)actualRequest.getWorkstation());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void generateAccessTokenExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWorkstations.addException((Exception)exception);
        try {
            WorkstationName workstation = WorkstationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[WORKSTATION_CLUSTER]", (String)"[WORKSTATION_CONFIG]", (String)"[WORKSTATION]");
            this.client.generateAccessToken(workstation);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void generateAccessTokenTest2() throws Exception {
        GenerateAccessTokenResponse expectedResponse = GenerateAccessTokenResponse.newBuilder().setAccessToken("accessToken-1042689291").setExpireTime(Timestamp.newBuilder().build()).build();
        mockWorkstations.addResponse((AbstractMessage)expectedResponse);
        String workstation = "workstation581588227";
        GenerateAccessTokenResponse actualResponse = this.client.generateAccessToken(workstation);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockWorkstations.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GenerateAccessTokenRequest actualRequest = (GenerateAccessTokenRequest)actualRequests.get(0);
        Assert.assertEquals((Object)workstation, (Object)actualRequest.getWorkstation());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void generateAccessTokenExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWorkstations.addException((Exception)exception);
        try {
            String workstation = "workstation581588227";
            this.client.generateAccessToken(workstation);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void setIamPolicyTest() throws Exception {
        Policy expectedResponse = Policy.newBuilder().setVersion(351608024).addAllBindings(new ArrayList()).addAllAuditConfigs(new ArrayList()).setEtag(ByteString.EMPTY).build();
        mockIAMPolicy.addResponse((AbstractMessage)expectedResponse);
        SetIamPolicyRequest request = SetIamPolicyRequest.newBuilder().setResource(WorkstationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[WORKSTATION_CLUSTER]", (String)"[WORKSTATION_CONFIG]", (String)"[WORKSTATION]").toString()).setPolicy(Policy.newBuilder().build()).setUpdateMask(FieldMask.newBuilder().build()).build();
        Policy actualResponse = this.client.setIamPolicy(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockIAMPolicy.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        SetIamPolicyRequest actualRequest = (SetIamPolicyRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getResource(), (Object)actualRequest.getResource());
        Assert.assertEquals((Object)request.getPolicy(), (Object)actualRequest.getPolicy());
        Assert.assertEquals((Object)request.getUpdateMask(), (Object)actualRequest.getUpdateMask());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void setIamPolicyExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockIAMPolicy.addException((Exception)exception);
        try {
            SetIamPolicyRequest request = SetIamPolicyRequest.newBuilder().setResource(WorkstationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[WORKSTATION_CLUSTER]", (String)"[WORKSTATION_CONFIG]", (String)"[WORKSTATION]").toString()).setPolicy(Policy.newBuilder().build()).setUpdateMask(FieldMask.newBuilder().build()).build();
            this.client.setIamPolicy(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getIamPolicyTest() throws Exception {
        Policy expectedResponse = Policy.newBuilder().setVersion(351608024).addAllBindings(new ArrayList()).addAllAuditConfigs(new ArrayList()).setEtag(ByteString.EMPTY).build();
        mockIAMPolicy.addResponse((AbstractMessage)expectedResponse);
        GetIamPolicyRequest request = GetIamPolicyRequest.newBuilder().setResource(WorkstationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[WORKSTATION_CLUSTER]", (String)"[WORKSTATION_CONFIG]", (String)"[WORKSTATION]").toString()).setOptions(GetPolicyOptions.newBuilder().build()).build();
        Policy actualResponse = this.client.getIamPolicy(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockIAMPolicy.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetIamPolicyRequest actualRequest = (GetIamPolicyRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getResource(), (Object)actualRequest.getResource());
        Assert.assertEquals((Object)request.getOptions(), (Object)actualRequest.getOptions());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getIamPolicyExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockIAMPolicy.addException((Exception)exception);
        try {
            GetIamPolicyRequest request = GetIamPolicyRequest.newBuilder().setResource(WorkstationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[WORKSTATION_CLUSTER]", (String)"[WORKSTATION_CONFIG]", (String)"[WORKSTATION]").toString()).setOptions(GetPolicyOptions.newBuilder().build()).build();
            this.client.getIamPolicy(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testIamPermissionsTest() throws Exception {
        TestIamPermissionsResponse expectedResponse = TestIamPermissionsResponse.newBuilder().addAllPermissions(new ArrayList()).build();
        mockIAMPolicy.addResponse((AbstractMessage)expectedResponse);
        TestIamPermissionsRequest request = TestIamPermissionsRequest.newBuilder().setResource(WorkstationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[WORKSTATION_CLUSTER]", (String)"[WORKSTATION_CONFIG]", (String)"[WORKSTATION]").toString()).addAllPermissions(new ArrayList()).build();
        TestIamPermissionsResponse actualResponse = this.client.testIamPermissions(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockIAMPolicy.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        TestIamPermissionsRequest actualRequest = (TestIamPermissionsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getResource(), (Object)actualRequest.getResource());
        Assert.assertEquals((Object)request.getPermissionsList(), (Object)actualRequest.getPermissionsList());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void testIamPermissionsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockIAMPolicy.addException((Exception)exception);
        try {
            TestIamPermissionsRequest request = TestIamPermissionsRequest.newBuilder().setResource(WorkstationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[WORKSTATION_CLUSTER]", (String)"[WORKSTATION_CONFIG]", (String)"[WORKSTATION]").toString()).addAllPermissions(new ArrayList()).build();
            this.client.testIamPermissions(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }
}

