/*
 * Decompiled with CFR 0.152.
 */
package com.google.iam.v2;

import com.google.api.client.http.HttpTransport;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.testing.MockHttpService;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.ApiExceptionFactory;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.testing.FakeStatusCode;
import com.google.common.collect.Lists;
import com.google.iam.v2.ListPoliciesResponse;
import com.google.iam.v2.PoliciesClient;
import com.google.iam.v2.PoliciesSettings;
import com.google.iam.v2.Policy;
import com.google.iam.v2.UpdatePolicyRequest;
import com.google.iam.v2.stub.HttpJsonPoliciesStub;
import com.google.longrunning.Operation;
import com.google.protobuf.Any;
import com.google.protobuf.Message;
import com.google.protobuf.Timestamp;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class PoliciesClientHttpJsonTest {
    private static MockHttpService mockService;
    private static PoliciesClient client;

    @BeforeClass
    public static void startStaticServer() throws IOException {
        mockService = new MockHttpService(HttpJsonPoliciesStub.getMethodDescriptors(), PoliciesSettings.getDefaultEndpoint());
        PoliciesSettings settings = ((PoliciesSettings.Builder)((PoliciesSettings.Builder)PoliciesSettings.newHttpJsonBuilder().setTransportChannelProvider((TransportChannelProvider)PoliciesSettings.defaultHttpJsonTransportProviderBuilder().setHttpTransport((HttpTransport)mockService).build())).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        client = PoliciesClient.create((PoliciesSettings)settings);
    }

    @AfterClass
    public static void stopServer() {
        client.close();
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() throws Exception {
        mockService.reset();
    }

    @Test
    public void listPoliciesTest() throws Exception {
        Policy responsesElement = Policy.newBuilder().build();
        ListPoliciesResponse expectedResponse = ListPoliciesResponse.newBuilder().setNextPageToken("").addAllPolicies(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "policies/policie-1456/policie-1456";
        PoliciesClient.ListPoliciesPagedResponse pagedListResponse = client.listPolicies(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getPoliciesList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listPoliciesExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "policies/policie-1456/policie-1456";
            client.listPolicies(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getPolicyTest() throws Exception {
        Policy expectedResponse = Policy.newBuilder().setName("name3373707").setUid("uid115792").setKind("kind3292052").setDisplayName("displayName1714148973").putAllAnnotations(new HashMap()).setEtag("etag3123477").setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setDeleteTime(Timestamp.newBuilder().build()).addAllRules(new ArrayList()).setManagingAuthority("managingAuthority867537025").build();
        mockService.addResponse((Object)expectedResponse);
        String name = "policies/policie-3260/policie-3260/policie-3260";
        Policy actualResponse = client.getPolicy(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getPolicyExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "policies/policie-3260/policie-3260/policie-3260";
            client.getPolicy(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createPolicyTest() throws Exception {
        Policy expectedResponse = Policy.newBuilder().setName("name3373707").setUid("uid115792").setKind("kind3292052").setDisplayName("displayName1714148973").putAllAnnotations(new HashMap()).setEtag("etag3123477").setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setDeleteTime(Timestamp.newBuilder().build()).addAllRules(new ArrayList()).setManagingAuthority("managingAuthority867537025").build();
        Operation resultOperation = Operation.newBuilder().setName("createPolicyTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        String parent = "policies/policie-1456/policie-1456";
        Policy policy = Policy.newBuilder().build();
        String policyId = "policyId546908653";
        Policy actualResponse = (Policy)client.createPolicyAsync(parent, policy, policyId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createPolicyExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "policies/policie-1456/policie-1456";
            Policy policy = Policy.newBuilder().build();
            String policyId = "policyId546908653";
            client.createPolicyAsync(parent, policy, policyId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void updatePolicyTest() throws Exception {
        Policy expectedResponse = Policy.newBuilder().setName("name3373707").setUid("uid115792").setKind("kind3292052").setDisplayName("displayName1714148973").putAllAnnotations(new HashMap()).setEtag("etag3123477").setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setDeleteTime(Timestamp.newBuilder().build()).addAllRules(new ArrayList()).setManagingAuthority("managingAuthority867537025").build();
        Operation resultOperation = Operation.newBuilder().setName("updatePolicyTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        UpdatePolicyRequest request = UpdatePolicyRequest.newBuilder().setPolicy(Policy.newBuilder().setName("policies/policie-3260/policie-3260/policie-3260").setUid("uid115792").setKind("kind3292052").setDisplayName("displayName1714148973").putAllAnnotations(new HashMap()).setEtag("etag3123477").setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setDeleteTime(Timestamp.newBuilder().build()).addAllRules(new ArrayList()).setManagingAuthority("managingAuthority867537025").build()).build();
        Policy actualResponse = (Policy)client.updatePolicyAsync(request).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void updatePolicyExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            UpdatePolicyRequest request = UpdatePolicyRequest.newBuilder().setPolicy(Policy.newBuilder().setName("policies/policie-3260/policie-3260/policie-3260").setUid("uid115792").setKind("kind3292052").setDisplayName("displayName1714148973").putAllAnnotations(new HashMap()).setEtag("etag3123477").setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setDeleteTime(Timestamp.newBuilder().build()).addAllRules(new ArrayList()).setManagingAuthority("managingAuthority867537025").build()).build();
            client.updatePolicyAsync(request).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void deletePolicyTest() throws Exception {
        Policy expectedResponse = Policy.newBuilder().setName("name3373707").setUid("uid115792").setKind("kind3292052").setDisplayName("displayName1714148973").putAllAnnotations(new HashMap()).setEtag("etag3123477").setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setDeleteTime(Timestamp.newBuilder().build()).addAllRules(new ArrayList()).setManagingAuthority("managingAuthority867537025").build();
        Operation resultOperation = Operation.newBuilder().setName("deletePolicyTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        String name = "policies/policie-3260/policie-3260/policie-3260";
        Policy actualResponse = (Policy)client.deletePolicyAsync(name).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deletePolicyExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "policies/policie-3260/policie-3260/policie-3260";
            client.deletePolicyAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }
}

