/*
 * Decompiled with CFR 0.152.
 */
package com.google.iam.v2;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.grpc.testing.MockServiceHelper;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.common.collect.Lists;
import com.google.iam.v2.CreatePolicyRequest;
import com.google.iam.v2.DeletePolicyRequest;
import com.google.iam.v2.GetPolicyRequest;
import com.google.iam.v2.ListPoliciesRequest;
import com.google.iam.v2.ListPoliciesResponse;
import com.google.iam.v2.MockPolicies;
import com.google.iam.v2.PoliciesClient;
import com.google.iam.v2.PoliciesSettings;
import com.google.iam.v2.Policy;
import com.google.iam.v2.UpdatePolicyRequest;
import com.google.longrunning.Operation;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.Any;
import com.google.protobuf.Message;
import com.google.protobuf.Timestamp;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class PoliciesClientTest {
    private static MockPolicies mockPolicies;
    private static MockServiceHelper mockServiceHelper;
    private LocalChannelProvider channelProvider;
    private PoliciesClient client;

    @BeforeClass
    public static void startStaticServer() {
        mockPolicies = new MockPolicies();
        mockServiceHelper = new MockServiceHelper(UUID.randomUUID().toString(), Arrays.asList(mockPolicies));
        mockServiceHelper.start();
    }

    @AfterClass
    public static void stopServer() {
        mockServiceHelper.stop();
    }

    @Before
    public void setUp() throws IOException {
        mockServiceHelper.reset();
        this.channelProvider = mockServiceHelper.createChannelProvider();
        PoliciesSettings settings = ((PoliciesSettings.Builder)((PoliciesSettings.Builder)PoliciesSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)this.channelProvider)).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        this.client = PoliciesClient.create((PoliciesSettings)settings);
    }

    @After
    public void tearDown() throws Exception {
        this.client.close();
    }

    @Test
    public void listPoliciesTest() throws Exception {
        Policy responsesElement = Policy.newBuilder().build();
        ListPoliciesResponse expectedResponse = ListPoliciesResponse.newBuilder().setNextPageToken("").addAllPolicies(Arrays.asList(responsesElement)).build();
        mockPolicies.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        PoliciesClient.ListPoliciesPagedResponse pagedListResponse = this.client.listPolicies(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getPoliciesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockPolicies.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListPoliciesRequest actualRequest = (ListPoliciesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listPoliciesExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockPolicies.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listPolicies(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getPolicyTest() throws Exception {
        Policy expectedResponse = Policy.newBuilder().setName("name3373707").setUid("uid115792").setKind("kind3292052").setDisplayName("displayName1714148973").putAllAnnotations(new HashMap()).setEtag("etag3123477").setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setDeleteTime(Timestamp.newBuilder().build()).addAllRules(new ArrayList()).setManagingAuthority("managingAuthority867537025").build();
        mockPolicies.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        Policy actualResponse = this.client.getPolicy(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockPolicies.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetPolicyRequest actualRequest = (GetPolicyRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getPolicyExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockPolicies.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getPolicy(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createPolicyTest() throws Exception {
        Policy expectedResponse = Policy.newBuilder().setName("name3373707").setUid("uid115792").setKind("kind3292052").setDisplayName("displayName1714148973").putAllAnnotations(new HashMap()).setEtag("etag3123477").setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setDeleteTime(Timestamp.newBuilder().build()).addAllRules(new ArrayList()).setManagingAuthority("managingAuthority867537025").build();
        Operation resultOperation = Operation.newBuilder().setName("createPolicyTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockPolicies.addResponse((AbstractMessage)resultOperation);
        String parent = "parent-995424086";
        Policy policy = Policy.newBuilder().build();
        String policyId = "policyId546908653";
        Policy actualResponse = (Policy)this.client.createPolicyAsync(parent, policy, policyId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockPolicies.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreatePolicyRequest actualRequest = (CreatePolicyRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)policy, (Object)actualRequest.getPolicy());
        Assert.assertEquals((Object)policyId, (Object)actualRequest.getPolicyId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createPolicyExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockPolicies.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            Policy policy = Policy.newBuilder().build();
            String policyId = "policyId546908653";
            this.client.createPolicyAsync(parent, policy, policyId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void updatePolicyTest() throws Exception {
        Policy expectedResponse = Policy.newBuilder().setName("name3373707").setUid("uid115792").setKind("kind3292052").setDisplayName("displayName1714148973").putAllAnnotations(new HashMap()).setEtag("etag3123477").setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setDeleteTime(Timestamp.newBuilder().build()).addAllRules(new ArrayList()).setManagingAuthority("managingAuthority867537025").build();
        Operation resultOperation = Operation.newBuilder().setName("updatePolicyTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockPolicies.addResponse((AbstractMessage)resultOperation);
        UpdatePolicyRequest request = UpdatePolicyRequest.newBuilder().setPolicy(Policy.newBuilder().build()).build();
        Policy actualResponse = (Policy)this.client.updatePolicyAsync(request).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockPolicies.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdatePolicyRequest actualRequest = (UpdatePolicyRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getPolicy(), (Object)actualRequest.getPolicy());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updatePolicyExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockPolicies.addException((Exception)exception);
        try {
            UpdatePolicyRequest request = UpdatePolicyRequest.newBuilder().setPolicy(Policy.newBuilder().build()).build();
            this.client.updatePolicyAsync(request).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void deletePolicyTest() throws Exception {
        Policy expectedResponse = Policy.newBuilder().setName("name3373707").setUid("uid115792").setKind("kind3292052").setDisplayName("displayName1714148973").putAllAnnotations(new HashMap()).setEtag("etag3123477").setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setDeleteTime(Timestamp.newBuilder().build()).addAllRules(new ArrayList()).setManagingAuthority("managingAuthority867537025").build();
        Operation resultOperation = Operation.newBuilder().setName("deletePolicyTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockPolicies.addResponse((AbstractMessage)resultOperation);
        String name = "name3373707";
        Policy actualResponse = (Policy)this.client.deletePolicyAsync(name).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockPolicies.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeletePolicyRequest actualRequest = (DeletePolicyRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deletePolicyExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockPolicies.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.deletePolicyAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }
}

