/*
 * Decompiled with CFR 0.152.
 */
package com.google.iam.v3;

import com.google.api.client.http.HttpTransport;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.testing.MockHttpService;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.ApiExceptionFactory;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.testing.FakeStatusCode;
import com.google.common.collect.Lists;
import com.google.iam.v3.FolderLocationName;
import com.google.iam.v3.ListPolicyBindingsResponse;
import com.google.iam.v3.LocationName;
import com.google.iam.v3.OrganizationLocationName;
import com.google.iam.v3.PolicyBinding;
import com.google.iam.v3.PolicyBindingName;
import com.google.iam.v3.PolicyBindingsClient;
import com.google.iam.v3.PolicyBindingsSettings;
import com.google.iam.v3.SearchTargetPolicyBindingsResponse;
import com.google.iam.v3.stub.HttpJsonPolicyBindingsStub;
import com.google.longrunning.Operation;
import com.google.protobuf.Any;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import com.google.protobuf.Message;
import com.google.protobuf.Timestamp;
import com.google.type.Expr;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class PolicyBindingsClientHttpJsonTest {
    private static MockHttpService mockService;
    private static PolicyBindingsClient client;

    @BeforeClass
    public static void startStaticServer() throws IOException {
        mockService = new MockHttpService(HttpJsonPolicyBindingsStub.getMethodDescriptors(), PolicyBindingsSettings.getDefaultEndpoint());
        PolicyBindingsSettings settings = ((PolicyBindingsSettings.Builder)((PolicyBindingsSettings.Builder)PolicyBindingsSettings.newHttpJsonBuilder().setTransportChannelProvider((TransportChannelProvider)PolicyBindingsSettings.defaultHttpJsonTransportProviderBuilder().setHttpTransport((HttpTransport)mockService).build())).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        client = PolicyBindingsClient.create((PolicyBindingsSettings)settings);
    }

    @AfterClass
    public static void stopServer() {
        client.close();
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() throws Exception {
        mockService.reset();
    }

    @Test
    public void createPolicyBindingTest() throws Exception {
        PolicyBinding expectedResponse = PolicyBinding.newBuilder().setName(PolicyBindingName.ofOrganizationLocationPolicyBindingName((String)"[ORGANIZATION]", (String)"[LOCATION]", (String)"[POLICY_BINDING]").toString()).setUid("uid115792").setEtag("etag3123477").setDisplayName("displayName1714148973").putAllAnnotations(new HashMap()).setTarget(PolicyBinding.Target.newBuilder().build()).setPolicy("policy-982670030").setPolicyUid("policyUid-225689154").setCondition(Expr.newBuilder().build()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).build();
        Operation resultOperation = Operation.newBuilder().setName("createPolicyBindingTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        FolderLocationName parent = FolderLocationName.of((String)"[FOLDER]", (String)"[LOCATION]");
        PolicyBinding policyBinding = PolicyBinding.newBuilder().build();
        String policyBindingId = "policyBindingId1375821166";
        PolicyBinding actualResponse = (PolicyBinding)client.createPolicyBindingAsync(parent, policyBinding, policyBindingId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createPolicyBindingExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            FolderLocationName parent = FolderLocationName.of((String)"[FOLDER]", (String)"[LOCATION]");
            PolicyBinding policyBinding = PolicyBinding.newBuilder().build();
            String policyBindingId = "policyBindingId1375821166";
            client.createPolicyBindingAsync(parent, policyBinding, policyBindingId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void createPolicyBindingTest2() throws Exception {
        PolicyBinding expectedResponse = PolicyBinding.newBuilder().setName(PolicyBindingName.ofOrganizationLocationPolicyBindingName((String)"[ORGANIZATION]", (String)"[LOCATION]", (String)"[POLICY_BINDING]").toString()).setUid("uid115792").setEtag("etag3123477").setDisplayName("displayName1714148973").putAllAnnotations(new HashMap()).setTarget(PolicyBinding.Target.newBuilder().build()).setPolicy("policy-982670030").setPolicyUid("policyUid-225689154").setCondition(Expr.newBuilder().build()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).build();
        Operation resultOperation = Operation.newBuilder().setName("createPolicyBindingTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        PolicyBinding policyBinding = PolicyBinding.newBuilder().build();
        String policyBindingId = "policyBindingId1375821166";
        PolicyBinding actualResponse = (PolicyBinding)client.createPolicyBindingAsync(parent, policyBinding, policyBindingId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createPolicyBindingExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            PolicyBinding policyBinding = PolicyBinding.newBuilder().build();
            String policyBindingId = "policyBindingId1375821166";
            client.createPolicyBindingAsync(parent, policyBinding, policyBindingId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void createPolicyBindingTest3() throws Exception {
        PolicyBinding expectedResponse = PolicyBinding.newBuilder().setName(PolicyBindingName.ofOrganizationLocationPolicyBindingName((String)"[ORGANIZATION]", (String)"[LOCATION]", (String)"[POLICY_BINDING]").toString()).setUid("uid115792").setEtag("etag3123477").setDisplayName("displayName1714148973").putAllAnnotations(new HashMap()).setTarget(PolicyBinding.Target.newBuilder().build()).setPolicy("policy-982670030").setPolicyUid("policyUid-225689154").setCondition(Expr.newBuilder().build()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).build();
        Operation resultOperation = Operation.newBuilder().setName("createPolicyBindingTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        OrganizationLocationName parent = OrganizationLocationName.of((String)"[ORGANIZATION]", (String)"[LOCATION]");
        PolicyBinding policyBinding = PolicyBinding.newBuilder().build();
        String policyBindingId = "policyBindingId1375821166";
        PolicyBinding actualResponse = (PolicyBinding)client.createPolicyBindingAsync(parent, policyBinding, policyBindingId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createPolicyBindingExceptionTest3() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            OrganizationLocationName parent = OrganizationLocationName.of((String)"[ORGANIZATION]", (String)"[LOCATION]");
            PolicyBinding policyBinding = PolicyBinding.newBuilder().build();
            String policyBindingId = "policyBindingId1375821166";
            client.createPolicyBindingAsync(parent, policyBinding, policyBindingId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void createPolicyBindingTest4() throws Exception {
        PolicyBinding expectedResponse = PolicyBinding.newBuilder().setName(PolicyBindingName.ofOrganizationLocationPolicyBindingName((String)"[ORGANIZATION]", (String)"[LOCATION]", (String)"[POLICY_BINDING]").toString()).setUid("uid115792").setEtag("etag3123477").setDisplayName("displayName1714148973").putAllAnnotations(new HashMap()).setTarget(PolicyBinding.Target.newBuilder().build()).setPolicy("policy-982670030").setPolicyUid("policyUid-225689154").setCondition(Expr.newBuilder().build()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).build();
        Operation resultOperation = Operation.newBuilder().setName("createPolicyBindingTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        String parent = "projects/project-5833/locations/location-5833";
        PolicyBinding policyBinding = PolicyBinding.newBuilder().build();
        String policyBindingId = "policyBindingId1375821166";
        PolicyBinding actualResponse = (PolicyBinding)client.createPolicyBindingAsync(parent, policyBinding, policyBindingId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createPolicyBindingExceptionTest4() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-5833/locations/location-5833";
            PolicyBinding policyBinding = PolicyBinding.newBuilder().build();
            String policyBindingId = "policyBindingId1375821166";
            client.createPolicyBindingAsync(parent, policyBinding, policyBindingId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void getPolicyBindingTest() throws Exception {
        PolicyBinding expectedResponse = PolicyBinding.newBuilder().setName(PolicyBindingName.ofProjectLocationPolicyBindingName((String)"[PROJECT]", (String)"[LOCATION]", (String)"[POLICY_BINDING]").toString()).setUid("uid115792").setEtag("etag3123477").setDisplayName("displayName1714148973").putAllAnnotations(new HashMap()).setTarget(PolicyBinding.Target.newBuilder().build()).setPolicy("policy-982670030").setPolicyUid("policyUid-225689154").setCondition(Expr.newBuilder().build()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        PolicyBindingName name = PolicyBindingName.ofProjectLocationPolicyBindingName((String)"[PROJECT]", (String)"[LOCATION]", (String)"[POLICY_BINDING]");
        PolicyBinding actualResponse = client.getPolicyBinding(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getPolicyBindingExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            PolicyBindingName name = PolicyBindingName.ofProjectLocationPolicyBindingName((String)"[PROJECT]", (String)"[LOCATION]", (String)"[POLICY_BINDING]");
            client.getPolicyBinding(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getPolicyBindingTest2() throws Exception {
        PolicyBinding expectedResponse = PolicyBinding.newBuilder().setName(PolicyBindingName.ofProjectLocationPolicyBindingName((String)"[PROJECT]", (String)"[LOCATION]", (String)"[POLICY_BINDING]").toString()).setUid("uid115792").setEtag("etag3123477").setDisplayName("displayName1714148973").putAllAnnotations(new HashMap()).setTarget(PolicyBinding.Target.newBuilder().build()).setPolicy("policy-982670030").setPolicyUid("policyUid-225689154").setCondition(Expr.newBuilder().build()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-4400/locations/location-4400/policyBindings/policyBinding-4400";
        PolicyBinding actualResponse = client.getPolicyBinding(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getPolicyBindingExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-4400/locations/location-4400/policyBindings/policyBinding-4400";
            client.getPolicyBinding(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updatePolicyBindingTest() throws Exception {
        PolicyBinding expectedResponse = PolicyBinding.newBuilder().setName(PolicyBindingName.ofProjectLocationPolicyBindingName((String)"[PROJECT]", (String)"[LOCATION]", (String)"[POLICY_BINDING]").toString()).setUid("uid115792").setEtag("etag3123477").setDisplayName("displayName1714148973").putAllAnnotations(new HashMap()).setTarget(PolicyBinding.Target.newBuilder().build()).setPolicy("policy-982670030").setPolicyUid("policyUid-225689154").setCondition(Expr.newBuilder().build()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).build();
        Operation resultOperation = Operation.newBuilder().setName("updatePolicyBindingTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        PolicyBinding policyBinding = PolicyBinding.newBuilder().setName(PolicyBindingName.ofProjectLocationPolicyBindingName((String)"[PROJECT]", (String)"[LOCATION]", (String)"[POLICY_BINDING]").toString()).setUid("uid115792").setEtag("etag3123477").setDisplayName("displayName1714148973").putAllAnnotations(new HashMap()).setTarget(PolicyBinding.Target.newBuilder().build()).setPolicy("policy-982670030").setPolicyUid("policyUid-225689154").setCondition(Expr.newBuilder().build()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        PolicyBinding actualResponse = (PolicyBinding)client.updatePolicyBindingAsync(policyBinding, updateMask).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void updatePolicyBindingExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            PolicyBinding policyBinding = PolicyBinding.newBuilder().setName(PolicyBindingName.ofProjectLocationPolicyBindingName((String)"[PROJECT]", (String)"[LOCATION]", (String)"[POLICY_BINDING]").toString()).setUid("uid115792").setEtag("etag3123477").setDisplayName("displayName1714148973").putAllAnnotations(new HashMap()).setTarget(PolicyBinding.Target.newBuilder().build()).setPolicy("policy-982670030").setPolicyUid("policyUid-225689154").setCondition(Expr.newBuilder().build()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            client.updatePolicyBindingAsync(policyBinding, updateMask).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void deletePolicyBindingTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deletePolicyBindingTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        PolicyBindingName name = PolicyBindingName.ofProjectLocationPolicyBindingName((String)"[PROJECT]", (String)"[LOCATION]", (String)"[POLICY_BINDING]");
        client.deletePolicyBindingAsync(name).get();
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deletePolicyBindingExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            PolicyBindingName name = PolicyBindingName.ofProjectLocationPolicyBindingName((String)"[PROJECT]", (String)"[LOCATION]", (String)"[POLICY_BINDING]");
            client.deletePolicyBindingAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void deletePolicyBindingTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deletePolicyBindingTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        String name = "projects/project-4400/locations/location-4400/policyBindings/policyBinding-4400";
        client.deletePolicyBindingAsync(name).get();
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deletePolicyBindingExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-4400/locations/location-4400/policyBindings/policyBinding-4400";
            client.deletePolicyBindingAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void listPolicyBindingsTest() throws Exception {
        PolicyBinding responsesElement = PolicyBinding.newBuilder().build();
        ListPolicyBindingsResponse expectedResponse = ListPolicyBindingsResponse.newBuilder().setNextPageToken("").addAllPolicyBindings(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        FolderLocationName parent = FolderLocationName.of((String)"[FOLDER]", (String)"[LOCATION]");
        PolicyBindingsClient.ListPolicyBindingsPagedResponse pagedListResponse = client.listPolicyBindings(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getPolicyBindingsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listPolicyBindingsExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            FolderLocationName parent = FolderLocationName.of((String)"[FOLDER]", (String)"[LOCATION]");
            client.listPolicyBindings(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listPolicyBindingsTest2() throws Exception {
        PolicyBinding responsesElement = PolicyBinding.newBuilder().build();
        ListPolicyBindingsResponse expectedResponse = ListPolicyBindingsResponse.newBuilder().setNextPageToken("").addAllPolicyBindings(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        PolicyBindingsClient.ListPolicyBindingsPagedResponse pagedListResponse = client.listPolicyBindings(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getPolicyBindingsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listPolicyBindingsExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            client.listPolicyBindings(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listPolicyBindingsTest3() throws Exception {
        PolicyBinding responsesElement = PolicyBinding.newBuilder().build();
        ListPolicyBindingsResponse expectedResponse = ListPolicyBindingsResponse.newBuilder().setNextPageToken("").addAllPolicyBindings(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        OrganizationLocationName parent = OrganizationLocationName.of((String)"[ORGANIZATION]", (String)"[LOCATION]");
        PolicyBindingsClient.ListPolicyBindingsPagedResponse pagedListResponse = client.listPolicyBindings(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getPolicyBindingsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listPolicyBindingsExceptionTest3() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            OrganizationLocationName parent = OrganizationLocationName.of((String)"[ORGANIZATION]", (String)"[LOCATION]");
            client.listPolicyBindings(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listPolicyBindingsTest4() throws Exception {
        PolicyBinding responsesElement = PolicyBinding.newBuilder().build();
        ListPolicyBindingsResponse expectedResponse = ListPolicyBindingsResponse.newBuilder().setNextPageToken("").addAllPolicyBindings(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "projects/project-5833/locations/location-5833";
        PolicyBindingsClient.ListPolicyBindingsPagedResponse pagedListResponse = client.listPolicyBindings(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getPolicyBindingsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listPolicyBindingsExceptionTest4() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-5833/locations/location-5833";
            client.listPolicyBindings(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void searchTargetPolicyBindingsTest() throws Exception {
        PolicyBinding responsesElement = PolicyBinding.newBuilder().build();
        SearchTargetPolicyBindingsResponse expectedResponse = SearchTargetPolicyBindingsResponse.newBuilder().setNextPageToken("").addAllPolicyBindings(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        FolderLocationName parent = FolderLocationName.of((String)"[FOLDER]", (String)"[LOCATION]");
        String target = "target-880905839";
        PolicyBindingsClient.SearchTargetPolicyBindingsPagedResponse pagedListResponse = client.searchTargetPolicyBindings(parent, target);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getPolicyBindingsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void searchTargetPolicyBindingsExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            FolderLocationName parent = FolderLocationName.of((String)"[FOLDER]", (String)"[LOCATION]");
            String target = "target-880905839";
            client.searchTargetPolicyBindings(parent, target);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void searchTargetPolicyBindingsTest2() throws Exception {
        PolicyBinding responsesElement = PolicyBinding.newBuilder().build();
        SearchTargetPolicyBindingsResponse expectedResponse = SearchTargetPolicyBindingsResponse.newBuilder().setNextPageToken("").addAllPolicyBindings(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        String target = "target-880905839";
        PolicyBindingsClient.SearchTargetPolicyBindingsPagedResponse pagedListResponse = client.searchTargetPolicyBindings(parent, target);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getPolicyBindingsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void searchTargetPolicyBindingsExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            String target = "target-880905839";
            client.searchTargetPolicyBindings(parent, target);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void searchTargetPolicyBindingsTest3() throws Exception {
        PolicyBinding responsesElement = PolicyBinding.newBuilder().build();
        SearchTargetPolicyBindingsResponse expectedResponse = SearchTargetPolicyBindingsResponse.newBuilder().setNextPageToken("").addAllPolicyBindings(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        OrganizationLocationName parent = OrganizationLocationName.of((String)"[ORGANIZATION]", (String)"[LOCATION]");
        String target = "target-880905839";
        PolicyBindingsClient.SearchTargetPolicyBindingsPagedResponse pagedListResponse = client.searchTargetPolicyBindings(parent, target);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getPolicyBindingsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void searchTargetPolicyBindingsExceptionTest3() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            OrganizationLocationName parent = OrganizationLocationName.of((String)"[ORGANIZATION]", (String)"[LOCATION]");
            String target = "target-880905839";
            client.searchTargetPolicyBindings(parent, target);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void searchTargetPolicyBindingsTest4() throws Exception {
        PolicyBinding responsesElement = PolicyBinding.newBuilder().build();
        SearchTargetPolicyBindingsResponse expectedResponse = SearchTargetPolicyBindingsResponse.newBuilder().setNextPageToken("").addAllPolicyBindings(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "projects/project-5833/locations/location-5833";
        String target = "target-880905839";
        PolicyBindingsClient.SearchTargetPolicyBindingsPagedResponse pagedListResponse = client.searchTargetPolicyBindings(parent, target);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getPolicyBindingsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void searchTargetPolicyBindingsExceptionTest4() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-5833/locations/location-5833";
            String target = "target-880905839";
            client.searchTargetPolicyBindings(parent, target);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }
}

