/*
 * Decompiled with CFR 0.152.
 */
package com.google.iam.v3;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.grpc.testing.MockServiceHelper;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.common.collect.Lists;
import com.google.iam.v3.CreatePrincipalAccessBoundaryPolicyRequest;
import com.google.iam.v3.DeletePrincipalAccessBoundaryPolicyRequest;
import com.google.iam.v3.GetPrincipalAccessBoundaryPolicyRequest;
import com.google.iam.v3.ListPrincipalAccessBoundaryPoliciesRequest;
import com.google.iam.v3.ListPrincipalAccessBoundaryPoliciesResponse;
import com.google.iam.v3.MockLocations;
import com.google.iam.v3.MockPrincipalAccessBoundaryPolicies;
import com.google.iam.v3.OrganizationLocationName;
import com.google.iam.v3.PolicyBinding;
import com.google.iam.v3.PrincipalAccessBoundaryPoliciesClient;
import com.google.iam.v3.PrincipalAccessBoundaryPoliciesSettings;
import com.google.iam.v3.PrincipalAccessBoundaryPolicy;
import com.google.iam.v3.PrincipalAccessBoundaryPolicyDetails;
import com.google.iam.v3.PrincipalAccessBoundaryPolicyName;
import com.google.iam.v3.SearchPrincipalAccessBoundaryPolicyBindingsRequest;
import com.google.iam.v3.SearchPrincipalAccessBoundaryPolicyBindingsResponse;
import com.google.iam.v3.UpdatePrincipalAccessBoundaryPolicyRequest;
import com.google.longrunning.Operation;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.Any;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import com.google.protobuf.Message;
import com.google.protobuf.Timestamp;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class PrincipalAccessBoundaryPoliciesClientTest {
    private static MockLocations mockLocations;
    private static MockPrincipalAccessBoundaryPolicies mockPrincipalAccessBoundaryPolicies;
    private static MockServiceHelper mockServiceHelper;
    private LocalChannelProvider channelProvider;
    private PrincipalAccessBoundaryPoliciesClient client;

    @BeforeClass
    public static void startStaticServer() {
        mockPrincipalAccessBoundaryPolicies = new MockPrincipalAccessBoundaryPolicies();
        mockLocations = new MockLocations();
        mockServiceHelper = new MockServiceHelper(UUID.randomUUID().toString(), Arrays.asList(mockPrincipalAccessBoundaryPolicies, mockLocations));
        mockServiceHelper.start();
    }

    @AfterClass
    public static void stopServer() {
        mockServiceHelper.stop();
    }

    @Before
    public void setUp() throws IOException {
        mockServiceHelper.reset();
        this.channelProvider = mockServiceHelper.createChannelProvider();
        PrincipalAccessBoundaryPoliciesSettings settings = ((PrincipalAccessBoundaryPoliciesSettings.Builder)((PrincipalAccessBoundaryPoliciesSettings.Builder)PrincipalAccessBoundaryPoliciesSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)this.channelProvider)).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        this.client = PrincipalAccessBoundaryPoliciesClient.create((PrincipalAccessBoundaryPoliciesSettings)settings);
    }

    @After
    public void tearDown() throws Exception {
        this.client.close();
    }

    @Test
    public void createPrincipalAccessBoundaryPolicyTest() throws Exception {
        PrincipalAccessBoundaryPolicy expectedResponse = PrincipalAccessBoundaryPolicy.newBuilder().setName(PrincipalAccessBoundaryPolicyName.of((String)"[ORGANIZATION]", (String)"[LOCATION]", (String)"[PRINCIPAL_ACCESS_BOUNDARY_POLICY]").toString()).setUid("uid115792").setEtag("etag3123477").setDisplayName("displayName1714148973").putAllAnnotations(new HashMap()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setDetails(PrincipalAccessBoundaryPolicyDetails.newBuilder().build()).build();
        Operation resultOperation = Operation.newBuilder().setName("createPrincipalAccessBoundaryPolicyTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockPrincipalAccessBoundaryPolicies.addResponse((AbstractMessage)resultOperation);
        OrganizationLocationName parent = OrganizationLocationName.of((String)"[ORGANIZATION]", (String)"[LOCATION]");
        PrincipalAccessBoundaryPolicy principalAccessBoundaryPolicy = PrincipalAccessBoundaryPolicy.newBuilder().build();
        String principalAccessBoundaryPolicyId = "principalAccessBoundaryPolicyId-198573175";
        PrincipalAccessBoundaryPolicy actualResponse = (PrincipalAccessBoundaryPolicy)this.client.createPrincipalAccessBoundaryPolicyAsync(parent, principalAccessBoundaryPolicy, principalAccessBoundaryPolicyId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockPrincipalAccessBoundaryPolicies.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreatePrincipalAccessBoundaryPolicyRequest actualRequest = (CreatePrincipalAccessBoundaryPolicyRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)principalAccessBoundaryPolicy, (Object)actualRequest.getPrincipalAccessBoundaryPolicy());
        Assert.assertEquals((Object)principalAccessBoundaryPolicyId, (Object)actualRequest.getPrincipalAccessBoundaryPolicyId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createPrincipalAccessBoundaryPolicyExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockPrincipalAccessBoundaryPolicies.addException((Exception)exception);
        try {
            OrganizationLocationName parent = OrganizationLocationName.of((String)"[ORGANIZATION]", (String)"[LOCATION]");
            PrincipalAccessBoundaryPolicy principalAccessBoundaryPolicy = PrincipalAccessBoundaryPolicy.newBuilder().build();
            String principalAccessBoundaryPolicyId = "principalAccessBoundaryPolicyId-198573175";
            this.client.createPrincipalAccessBoundaryPolicyAsync(parent, principalAccessBoundaryPolicy, principalAccessBoundaryPolicyId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void createPrincipalAccessBoundaryPolicyTest2() throws Exception {
        PrincipalAccessBoundaryPolicy expectedResponse = PrincipalAccessBoundaryPolicy.newBuilder().setName(PrincipalAccessBoundaryPolicyName.of((String)"[ORGANIZATION]", (String)"[LOCATION]", (String)"[PRINCIPAL_ACCESS_BOUNDARY_POLICY]").toString()).setUid("uid115792").setEtag("etag3123477").setDisplayName("displayName1714148973").putAllAnnotations(new HashMap()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setDetails(PrincipalAccessBoundaryPolicyDetails.newBuilder().build()).build();
        Operation resultOperation = Operation.newBuilder().setName("createPrincipalAccessBoundaryPolicyTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockPrincipalAccessBoundaryPolicies.addResponse((AbstractMessage)resultOperation);
        String parent = "parent-995424086";
        PrincipalAccessBoundaryPolicy principalAccessBoundaryPolicy = PrincipalAccessBoundaryPolicy.newBuilder().build();
        String principalAccessBoundaryPolicyId = "principalAccessBoundaryPolicyId-198573175";
        PrincipalAccessBoundaryPolicy actualResponse = (PrincipalAccessBoundaryPolicy)this.client.createPrincipalAccessBoundaryPolicyAsync(parent, principalAccessBoundaryPolicy, principalAccessBoundaryPolicyId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockPrincipalAccessBoundaryPolicies.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreatePrincipalAccessBoundaryPolicyRequest actualRequest = (CreatePrincipalAccessBoundaryPolicyRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)principalAccessBoundaryPolicy, (Object)actualRequest.getPrincipalAccessBoundaryPolicy());
        Assert.assertEquals((Object)principalAccessBoundaryPolicyId, (Object)actualRequest.getPrincipalAccessBoundaryPolicyId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createPrincipalAccessBoundaryPolicyExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockPrincipalAccessBoundaryPolicies.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            PrincipalAccessBoundaryPolicy principalAccessBoundaryPolicy = PrincipalAccessBoundaryPolicy.newBuilder().build();
            String principalAccessBoundaryPolicyId = "principalAccessBoundaryPolicyId-198573175";
            this.client.createPrincipalAccessBoundaryPolicyAsync(parent, principalAccessBoundaryPolicy, principalAccessBoundaryPolicyId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void getPrincipalAccessBoundaryPolicyTest() throws Exception {
        PrincipalAccessBoundaryPolicy expectedResponse = PrincipalAccessBoundaryPolicy.newBuilder().setName(PrincipalAccessBoundaryPolicyName.of((String)"[ORGANIZATION]", (String)"[LOCATION]", (String)"[PRINCIPAL_ACCESS_BOUNDARY_POLICY]").toString()).setUid("uid115792").setEtag("etag3123477").setDisplayName("displayName1714148973").putAllAnnotations(new HashMap()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setDetails(PrincipalAccessBoundaryPolicyDetails.newBuilder().build()).build();
        mockPrincipalAccessBoundaryPolicies.addResponse((AbstractMessage)expectedResponse);
        PrincipalAccessBoundaryPolicyName name = PrincipalAccessBoundaryPolicyName.of((String)"[ORGANIZATION]", (String)"[LOCATION]", (String)"[PRINCIPAL_ACCESS_BOUNDARY_POLICY]");
        PrincipalAccessBoundaryPolicy actualResponse = this.client.getPrincipalAccessBoundaryPolicy(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockPrincipalAccessBoundaryPolicies.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetPrincipalAccessBoundaryPolicyRequest actualRequest = (GetPrincipalAccessBoundaryPolicyRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getPrincipalAccessBoundaryPolicyExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockPrincipalAccessBoundaryPolicies.addException((Exception)exception);
        try {
            PrincipalAccessBoundaryPolicyName name = PrincipalAccessBoundaryPolicyName.of((String)"[ORGANIZATION]", (String)"[LOCATION]", (String)"[PRINCIPAL_ACCESS_BOUNDARY_POLICY]");
            this.client.getPrincipalAccessBoundaryPolicy(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getPrincipalAccessBoundaryPolicyTest2() throws Exception {
        PrincipalAccessBoundaryPolicy expectedResponse = PrincipalAccessBoundaryPolicy.newBuilder().setName(PrincipalAccessBoundaryPolicyName.of((String)"[ORGANIZATION]", (String)"[LOCATION]", (String)"[PRINCIPAL_ACCESS_BOUNDARY_POLICY]").toString()).setUid("uid115792").setEtag("etag3123477").setDisplayName("displayName1714148973").putAllAnnotations(new HashMap()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setDetails(PrincipalAccessBoundaryPolicyDetails.newBuilder().build()).build();
        mockPrincipalAccessBoundaryPolicies.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        PrincipalAccessBoundaryPolicy actualResponse = this.client.getPrincipalAccessBoundaryPolicy(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockPrincipalAccessBoundaryPolicies.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetPrincipalAccessBoundaryPolicyRequest actualRequest = (GetPrincipalAccessBoundaryPolicyRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getPrincipalAccessBoundaryPolicyExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockPrincipalAccessBoundaryPolicies.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getPrincipalAccessBoundaryPolicy(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updatePrincipalAccessBoundaryPolicyTest() throws Exception {
        PrincipalAccessBoundaryPolicy expectedResponse = PrincipalAccessBoundaryPolicy.newBuilder().setName(PrincipalAccessBoundaryPolicyName.of((String)"[ORGANIZATION]", (String)"[LOCATION]", (String)"[PRINCIPAL_ACCESS_BOUNDARY_POLICY]").toString()).setUid("uid115792").setEtag("etag3123477").setDisplayName("displayName1714148973").putAllAnnotations(new HashMap()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setDetails(PrincipalAccessBoundaryPolicyDetails.newBuilder().build()).build();
        Operation resultOperation = Operation.newBuilder().setName("updatePrincipalAccessBoundaryPolicyTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockPrincipalAccessBoundaryPolicies.addResponse((AbstractMessage)resultOperation);
        PrincipalAccessBoundaryPolicy principalAccessBoundaryPolicy = PrincipalAccessBoundaryPolicy.newBuilder().build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        PrincipalAccessBoundaryPolicy actualResponse = (PrincipalAccessBoundaryPolicy)this.client.updatePrincipalAccessBoundaryPolicyAsync(principalAccessBoundaryPolicy, updateMask).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockPrincipalAccessBoundaryPolicies.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdatePrincipalAccessBoundaryPolicyRequest actualRequest = (UpdatePrincipalAccessBoundaryPolicyRequest)actualRequests.get(0);
        Assert.assertEquals((Object)principalAccessBoundaryPolicy, (Object)actualRequest.getPrincipalAccessBoundaryPolicy());
        Assert.assertEquals((Object)updateMask, (Object)actualRequest.getUpdateMask());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updatePrincipalAccessBoundaryPolicyExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockPrincipalAccessBoundaryPolicies.addException((Exception)exception);
        try {
            PrincipalAccessBoundaryPolicy principalAccessBoundaryPolicy = PrincipalAccessBoundaryPolicy.newBuilder().build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            this.client.updatePrincipalAccessBoundaryPolicyAsync(principalAccessBoundaryPolicy, updateMask).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void deletePrincipalAccessBoundaryPolicyTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deletePrincipalAccessBoundaryPolicyTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockPrincipalAccessBoundaryPolicies.addResponse((AbstractMessage)resultOperation);
        PrincipalAccessBoundaryPolicyName name = PrincipalAccessBoundaryPolicyName.of((String)"[ORGANIZATION]", (String)"[LOCATION]", (String)"[PRINCIPAL_ACCESS_BOUNDARY_POLICY]");
        this.client.deletePrincipalAccessBoundaryPolicyAsync(name).get();
        List<AbstractMessage> actualRequests = mockPrincipalAccessBoundaryPolicies.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeletePrincipalAccessBoundaryPolicyRequest actualRequest = (DeletePrincipalAccessBoundaryPolicyRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deletePrincipalAccessBoundaryPolicyExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockPrincipalAccessBoundaryPolicies.addException((Exception)exception);
        try {
            PrincipalAccessBoundaryPolicyName name = PrincipalAccessBoundaryPolicyName.of((String)"[ORGANIZATION]", (String)"[LOCATION]", (String)"[PRINCIPAL_ACCESS_BOUNDARY_POLICY]");
            this.client.deletePrincipalAccessBoundaryPolicyAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void deletePrincipalAccessBoundaryPolicyTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deletePrincipalAccessBoundaryPolicyTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockPrincipalAccessBoundaryPolicies.addResponse((AbstractMessage)resultOperation);
        String name = "name3373707";
        this.client.deletePrincipalAccessBoundaryPolicyAsync(name).get();
        List<AbstractMessage> actualRequests = mockPrincipalAccessBoundaryPolicies.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeletePrincipalAccessBoundaryPolicyRequest actualRequest = (DeletePrincipalAccessBoundaryPolicyRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deletePrincipalAccessBoundaryPolicyExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockPrincipalAccessBoundaryPolicies.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.deletePrincipalAccessBoundaryPolicyAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void listPrincipalAccessBoundaryPoliciesTest() throws Exception {
        PrincipalAccessBoundaryPolicy responsesElement = PrincipalAccessBoundaryPolicy.newBuilder().build();
        ListPrincipalAccessBoundaryPoliciesResponse expectedResponse = ListPrincipalAccessBoundaryPoliciesResponse.newBuilder().setNextPageToken("").addAllPrincipalAccessBoundaryPolicies(Arrays.asList(responsesElement)).build();
        mockPrincipalAccessBoundaryPolicies.addResponse((AbstractMessage)expectedResponse);
        OrganizationLocationName parent = OrganizationLocationName.of((String)"[ORGANIZATION]", (String)"[LOCATION]");
        PrincipalAccessBoundaryPoliciesClient.ListPrincipalAccessBoundaryPoliciesPagedResponse pagedListResponse = this.client.listPrincipalAccessBoundaryPolicies(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getPrincipalAccessBoundaryPoliciesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockPrincipalAccessBoundaryPolicies.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListPrincipalAccessBoundaryPoliciesRequest actualRequest = (ListPrincipalAccessBoundaryPoliciesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listPrincipalAccessBoundaryPoliciesExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockPrincipalAccessBoundaryPolicies.addException((Exception)exception);
        try {
            OrganizationLocationName parent = OrganizationLocationName.of((String)"[ORGANIZATION]", (String)"[LOCATION]");
            this.client.listPrincipalAccessBoundaryPolicies(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listPrincipalAccessBoundaryPoliciesTest2() throws Exception {
        PrincipalAccessBoundaryPolicy responsesElement = PrincipalAccessBoundaryPolicy.newBuilder().build();
        ListPrincipalAccessBoundaryPoliciesResponse expectedResponse = ListPrincipalAccessBoundaryPoliciesResponse.newBuilder().setNextPageToken("").addAllPrincipalAccessBoundaryPolicies(Arrays.asList(responsesElement)).build();
        mockPrincipalAccessBoundaryPolicies.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        PrincipalAccessBoundaryPoliciesClient.ListPrincipalAccessBoundaryPoliciesPagedResponse pagedListResponse = this.client.listPrincipalAccessBoundaryPolicies(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getPrincipalAccessBoundaryPoliciesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockPrincipalAccessBoundaryPolicies.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListPrincipalAccessBoundaryPoliciesRequest actualRequest = (ListPrincipalAccessBoundaryPoliciesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listPrincipalAccessBoundaryPoliciesExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockPrincipalAccessBoundaryPolicies.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listPrincipalAccessBoundaryPolicies(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void searchPrincipalAccessBoundaryPolicyBindingsTest() throws Exception {
        PolicyBinding responsesElement = PolicyBinding.newBuilder().build();
        SearchPrincipalAccessBoundaryPolicyBindingsResponse expectedResponse = SearchPrincipalAccessBoundaryPolicyBindingsResponse.newBuilder().setNextPageToken("").addAllPolicyBindings(Arrays.asList(responsesElement)).build();
        mockPrincipalAccessBoundaryPolicies.addResponse((AbstractMessage)expectedResponse);
        PrincipalAccessBoundaryPolicyName name = PrincipalAccessBoundaryPolicyName.of((String)"[ORGANIZATION]", (String)"[LOCATION]", (String)"[PRINCIPAL_ACCESS_BOUNDARY_POLICY]");
        PrincipalAccessBoundaryPoliciesClient.SearchPrincipalAccessBoundaryPolicyBindingsPagedResponse pagedListResponse = this.client.searchPrincipalAccessBoundaryPolicyBindings(name);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getPolicyBindingsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockPrincipalAccessBoundaryPolicies.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        SearchPrincipalAccessBoundaryPolicyBindingsRequest actualRequest = (SearchPrincipalAccessBoundaryPolicyBindingsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void searchPrincipalAccessBoundaryPolicyBindingsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockPrincipalAccessBoundaryPolicies.addException((Exception)exception);
        try {
            PrincipalAccessBoundaryPolicyName name = PrincipalAccessBoundaryPolicyName.of((String)"[ORGANIZATION]", (String)"[LOCATION]", (String)"[PRINCIPAL_ACCESS_BOUNDARY_POLICY]");
            this.client.searchPrincipalAccessBoundaryPolicyBindings(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void searchPrincipalAccessBoundaryPolicyBindingsTest2() throws Exception {
        PolicyBinding responsesElement = PolicyBinding.newBuilder().build();
        SearchPrincipalAccessBoundaryPolicyBindingsResponse expectedResponse = SearchPrincipalAccessBoundaryPolicyBindingsResponse.newBuilder().setNextPageToken("").addAllPolicyBindings(Arrays.asList(responsesElement)).build();
        mockPrincipalAccessBoundaryPolicies.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        PrincipalAccessBoundaryPoliciesClient.SearchPrincipalAccessBoundaryPolicyBindingsPagedResponse pagedListResponse = this.client.searchPrincipalAccessBoundaryPolicyBindings(name);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getPolicyBindingsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockPrincipalAccessBoundaryPolicies.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        SearchPrincipalAccessBoundaryPolicyBindingsRequest actualRequest = (SearchPrincipalAccessBoundaryPolicyBindingsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void searchPrincipalAccessBoundaryPolicyBindingsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockPrincipalAccessBoundaryPolicies.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.searchPrincipalAccessBoundaryPolicyBindings(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }
}

