/*
 * Decompiled with CFR 0.152.
 */
package com.google.iam.v3beta;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.grpc.testing.MockServiceHelper;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.common.collect.Lists;
import com.google.iam.v3beta.CreatePolicyBindingRequest;
import com.google.iam.v3beta.DeletePolicyBindingRequest;
import com.google.iam.v3beta.FolderLocationName;
import com.google.iam.v3beta.GetPolicyBindingRequest;
import com.google.iam.v3beta.ListPolicyBindingsRequest;
import com.google.iam.v3beta.ListPolicyBindingsResponse;
import com.google.iam.v3beta.LocationName;
import com.google.iam.v3beta.MockLocations;
import com.google.iam.v3beta.MockPolicyBindings;
import com.google.iam.v3beta.OrganizationLocationName;
import com.google.iam.v3beta.PolicyBinding;
import com.google.iam.v3beta.PolicyBindingName;
import com.google.iam.v3beta.PolicyBindingsClient;
import com.google.iam.v3beta.PolicyBindingsSettings;
import com.google.iam.v3beta.SearchTargetPolicyBindingsRequest;
import com.google.iam.v3beta.SearchTargetPolicyBindingsResponse;
import com.google.iam.v3beta.UpdatePolicyBindingRequest;
import com.google.longrunning.Operation;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.Any;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import com.google.protobuf.Message;
import com.google.protobuf.Timestamp;
import com.google.type.Expr;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class PolicyBindingsClientTest {
    private static MockLocations mockLocations;
    private static MockPolicyBindings mockPolicyBindings;
    private static MockServiceHelper mockServiceHelper;
    private LocalChannelProvider channelProvider;
    private PolicyBindingsClient client;

    @BeforeClass
    public static void startStaticServer() {
        mockPolicyBindings = new MockPolicyBindings();
        mockLocations = new MockLocations();
        mockServiceHelper = new MockServiceHelper(UUID.randomUUID().toString(), Arrays.asList(mockPolicyBindings, mockLocations));
        mockServiceHelper.start();
    }

    @AfterClass
    public static void stopServer() {
        mockServiceHelper.stop();
    }

    @Before
    public void setUp() throws IOException {
        mockServiceHelper.reset();
        this.channelProvider = mockServiceHelper.createChannelProvider();
        PolicyBindingsSettings settings = ((PolicyBindingsSettings.Builder)((PolicyBindingsSettings.Builder)PolicyBindingsSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)this.channelProvider)).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        this.client = PolicyBindingsClient.create((PolicyBindingsSettings)settings);
    }

    @After
    public void tearDown() throws Exception {
        this.client.close();
    }

    @Test
    public void createPolicyBindingTest() throws Exception {
        PolicyBinding expectedResponse = PolicyBinding.newBuilder().setName(PolicyBindingName.ofOrganizationLocationPolicyBindingName((String)"[ORGANIZATION]", (String)"[LOCATION]", (String)"[POLICY_BINDING]").toString()).setUid("uid115792").setEtag("etag3123477").setDisplayName("displayName1714148973").putAllAnnotations(new HashMap()).setTarget(PolicyBinding.Target.newBuilder().build()).setPolicy("policy-982670030").setPolicyUid("policyUid-225689154").setCondition(Expr.newBuilder().build()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).build();
        Operation resultOperation = Operation.newBuilder().setName("createPolicyBindingTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockPolicyBindings.addResponse((AbstractMessage)resultOperation);
        FolderLocationName parent = FolderLocationName.of((String)"[FOLDER]", (String)"[LOCATION]");
        PolicyBinding policyBinding = PolicyBinding.newBuilder().build();
        String policyBindingId = "policyBindingId1375821166";
        PolicyBinding actualResponse = (PolicyBinding)this.client.createPolicyBindingAsync(parent, policyBinding, policyBindingId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockPolicyBindings.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreatePolicyBindingRequest actualRequest = (CreatePolicyBindingRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)policyBinding, (Object)actualRequest.getPolicyBinding());
        Assert.assertEquals((Object)policyBindingId, (Object)actualRequest.getPolicyBindingId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createPolicyBindingExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockPolicyBindings.addException((Exception)exception);
        try {
            FolderLocationName parent = FolderLocationName.of((String)"[FOLDER]", (String)"[LOCATION]");
            PolicyBinding policyBinding = PolicyBinding.newBuilder().build();
            String policyBindingId = "policyBindingId1375821166";
            this.client.createPolicyBindingAsync(parent, policyBinding, policyBindingId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void createPolicyBindingTest2() throws Exception {
        PolicyBinding expectedResponse = PolicyBinding.newBuilder().setName(PolicyBindingName.ofOrganizationLocationPolicyBindingName((String)"[ORGANIZATION]", (String)"[LOCATION]", (String)"[POLICY_BINDING]").toString()).setUid("uid115792").setEtag("etag3123477").setDisplayName("displayName1714148973").putAllAnnotations(new HashMap()).setTarget(PolicyBinding.Target.newBuilder().build()).setPolicy("policy-982670030").setPolicyUid("policyUid-225689154").setCondition(Expr.newBuilder().build()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).build();
        Operation resultOperation = Operation.newBuilder().setName("createPolicyBindingTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockPolicyBindings.addResponse((AbstractMessage)resultOperation);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        PolicyBinding policyBinding = PolicyBinding.newBuilder().build();
        String policyBindingId = "policyBindingId1375821166";
        PolicyBinding actualResponse = (PolicyBinding)this.client.createPolicyBindingAsync(parent, policyBinding, policyBindingId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockPolicyBindings.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreatePolicyBindingRequest actualRequest = (CreatePolicyBindingRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)policyBinding, (Object)actualRequest.getPolicyBinding());
        Assert.assertEquals((Object)policyBindingId, (Object)actualRequest.getPolicyBindingId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createPolicyBindingExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockPolicyBindings.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            PolicyBinding policyBinding = PolicyBinding.newBuilder().build();
            String policyBindingId = "policyBindingId1375821166";
            this.client.createPolicyBindingAsync(parent, policyBinding, policyBindingId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void createPolicyBindingTest3() throws Exception {
        PolicyBinding expectedResponse = PolicyBinding.newBuilder().setName(PolicyBindingName.ofOrganizationLocationPolicyBindingName((String)"[ORGANIZATION]", (String)"[LOCATION]", (String)"[POLICY_BINDING]").toString()).setUid("uid115792").setEtag("etag3123477").setDisplayName("displayName1714148973").putAllAnnotations(new HashMap()).setTarget(PolicyBinding.Target.newBuilder().build()).setPolicy("policy-982670030").setPolicyUid("policyUid-225689154").setCondition(Expr.newBuilder().build()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).build();
        Operation resultOperation = Operation.newBuilder().setName("createPolicyBindingTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockPolicyBindings.addResponse((AbstractMessage)resultOperation);
        OrganizationLocationName parent = OrganizationLocationName.of((String)"[ORGANIZATION]", (String)"[LOCATION]");
        PolicyBinding policyBinding = PolicyBinding.newBuilder().build();
        String policyBindingId = "policyBindingId1375821166";
        PolicyBinding actualResponse = (PolicyBinding)this.client.createPolicyBindingAsync(parent, policyBinding, policyBindingId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockPolicyBindings.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreatePolicyBindingRequest actualRequest = (CreatePolicyBindingRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)policyBinding, (Object)actualRequest.getPolicyBinding());
        Assert.assertEquals((Object)policyBindingId, (Object)actualRequest.getPolicyBindingId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createPolicyBindingExceptionTest3() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockPolicyBindings.addException((Exception)exception);
        try {
            OrganizationLocationName parent = OrganizationLocationName.of((String)"[ORGANIZATION]", (String)"[LOCATION]");
            PolicyBinding policyBinding = PolicyBinding.newBuilder().build();
            String policyBindingId = "policyBindingId1375821166";
            this.client.createPolicyBindingAsync(parent, policyBinding, policyBindingId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void createPolicyBindingTest4() throws Exception {
        PolicyBinding expectedResponse = PolicyBinding.newBuilder().setName(PolicyBindingName.ofOrganizationLocationPolicyBindingName((String)"[ORGANIZATION]", (String)"[LOCATION]", (String)"[POLICY_BINDING]").toString()).setUid("uid115792").setEtag("etag3123477").setDisplayName("displayName1714148973").putAllAnnotations(new HashMap()).setTarget(PolicyBinding.Target.newBuilder().build()).setPolicy("policy-982670030").setPolicyUid("policyUid-225689154").setCondition(Expr.newBuilder().build()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).build();
        Operation resultOperation = Operation.newBuilder().setName("createPolicyBindingTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockPolicyBindings.addResponse((AbstractMessage)resultOperation);
        String parent = "parent-995424086";
        PolicyBinding policyBinding = PolicyBinding.newBuilder().build();
        String policyBindingId = "policyBindingId1375821166";
        PolicyBinding actualResponse = (PolicyBinding)this.client.createPolicyBindingAsync(parent, policyBinding, policyBindingId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockPolicyBindings.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreatePolicyBindingRequest actualRequest = (CreatePolicyBindingRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)policyBinding, (Object)actualRequest.getPolicyBinding());
        Assert.assertEquals((Object)policyBindingId, (Object)actualRequest.getPolicyBindingId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createPolicyBindingExceptionTest4() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockPolicyBindings.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            PolicyBinding policyBinding = PolicyBinding.newBuilder().build();
            String policyBindingId = "policyBindingId1375821166";
            this.client.createPolicyBindingAsync(parent, policyBinding, policyBindingId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void getPolicyBindingTest() throws Exception {
        PolicyBinding expectedResponse = PolicyBinding.newBuilder().setName(PolicyBindingName.ofProjectLocationPolicyBindingName((String)"[PROJECT]", (String)"[LOCATION]", (String)"[POLICY_BINDING]").toString()).setUid("uid115792").setEtag("etag3123477").setDisplayName("displayName1714148973").putAllAnnotations(new HashMap()).setTarget(PolicyBinding.Target.newBuilder().build()).setPolicy("policy-982670030").setPolicyUid("policyUid-225689154").setCondition(Expr.newBuilder().build()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).build();
        mockPolicyBindings.addResponse((AbstractMessage)expectedResponse);
        PolicyBindingName name = PolicyBindingName.ofProjectLocationPolicyBindingName((String)"[PROJECT]", (String)"[LOCATION]", (String)"[POLICY_BINDING]");
        PolicyBinding actualResponse = this.client.getPolicyBinding(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockPolicyBindings.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetPolicyBindingRequest actualRequest = (GetPolicyBindingRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getPolicyBindingExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockPolicyBindings.addException((Exception)exception);
        try {
            PolicyBindingName name = PolicyBindingName.ofProjectLocationPolicyBindingName((String)"[PROJECT]", (String)"[LOCATION]", (String)"[POLICY_BINDING]");
            this.client.getPolicyBinding(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getPolicyBindingTest2() throws Exception {
        PolicyBinding expectedResponse = PolicyBinding.newBuilder().setName(PolicyBindingName.ofProjectLocationPolicyBindingName((String)"[PROJECT]", (String)"[LOCATION]", (String)"[POLICY_BINDING]").toString()).setUid("uid115792").setEtag("etag3123477").setDisplayName("displayName1714148973").putAllAnnotations(new HashMap()).setTarget(PolicyBinding.Target.newBuilder().build()).setPolicy("policy-982670030").setPolicyUid("policyUid-225689154").setCondition(Expr.newBuilder().build()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).build();
        mockPolicyBindings.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        PolicyBinding actualResponse = this.client.getPolicyBinding(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockPolicyBindings.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetPolicyBindingRequest actualRequest = (GetPolicyBindingRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getPolicyBindingExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockPolicyBindings.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getPolicyBinding(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updatePolicyBindingTest() throws Exception {
        PolicyBinding expectedResponse = PolicyBinding.newBuilder().setName(PolicyBindingName.ofProjectLocationPolicyBindingName((String)"[PROJECT]", (String)"[LOCATION]", (String)"[POLICY_BINDING]").toString()).setUid("uid115792").setEtag("etag3123477").setDisplayName("displayName1714148973").putAllAnnotations(new HashMap()).setTarget(PolicyBinding.Target.newBuilder().build()).setPolicy("policy-982670030").setPolicyUid("policyUid-225689154").setCondition(Expr.newBuilder().build()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).build();
        Operation resultOperation = Operation.newBuilder().setName("updatePolicyBindingTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockPolicyBindings.addResponse((AbstractMessage)resultOperation);
        PolicyBinding policyBinding = PolicyBinding.newBuilder().build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        PolicyBinding actualResponse = (PolicyBinding)this.client.updatePolicyBindingAsync(policyBinding, updateMask).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockPolicyBindings.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdatePolicyBindingRequest actualRequest = (UpdatePolicyBindingRequest)actualRequests.get(0);
        Assert.assertEquals((Object)policyBinding, (Object)actualRequest.getPolicyBinding());
        Assert.assertEquals((Object)updateMask, (Object)actualRequest.getUpdateMask());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updatePolicyBindingExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockPolicyBindings.addException((Exception)exception);
        try {
            PolicyBinding policyBinding = PolicyBinding.newBuilder().build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            this.client.updatePolicyBindingAsync(policyBinding, updateMask).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void deletePolicyBindingTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deletePolicyBindingTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockPolicyBindings.addResponse((AbstractMessage)resultOperation);
        PolicyBindingName name = PolicyBindingName.ofProjectLocationPolicyBindingName((String)"[PROJECT]", (String)"[LOCATION]", (String)"[POLICY_BINDING]");
        this.client.deletePolicyBindingAsync(name).get();
        List<AbstractMessage> actualRequests = mockPolicyBindings.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeletePolicyBindingRequest actualRequest = (DeletePolicyBindingRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deletePolicyBindingExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockPolicyBindings.addException((Exception)exception);
        try {
            PolicyBindingName name = PolicyBindingName.ofProjectLocationPolicyBindingName((String)"[PROJECT]", (String)"[LOCATION]", (String)"[POLICY_BINDING]");
            this.client.deletePolicyBindingAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void deletePolicyBindingTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deletePolicyBindingTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockPolicyBindings.addResponse((AbstractMessage)resultOperation);
        String name = "name3373707";
        this.client.deletePolicyBindingAsync(name).get();
        List<AbstractMessage> actualRequests = mockPolicyBindings.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeletePolicyBindingRequest actualRequest = (DeletePolicyBindingRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deletePolicyBindingExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockPolicyBindings.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.deletePolicyBindingAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void listPolicyBindingsTest() throws Exception {
        PolicyBinding responsesElement = PolicyBinding.newBuilder().build();
        ListPolicyBindingsResponse expectedResponse = ListPolicyBindingsResponse.newBuilder().setNextPageToken("").addAllPolicyBindings(Arrays.asList(responsesElement)).build();
        mockPolicyBindings.addResponse((AbstractMessage)expectedResponse);
        FolderLocationName parent = FolderLocationName.of((String)"[FOLDER]", (String)"[LOCATION]");
        PolicyBindingsClient.ListPolicyBindingsPagedResponse pagedListResponse = this.client.listPolicyBindings(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getPolicyBindingsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockPolicyBindings.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListPolicyBindingsRequest actualRequest = (ListPolicyBindingsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listPolicyBindingsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockPolicyBindings.addException((Exception)exception);
        try {
            FolderLocationName parent = FolderLocationName.of((String)"[FOLDER]", (String)"[LOCATION]");
            this.client.listPolicyBindings(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listPolicyBindingsTest2() throws Exception {
        PolicyBinding responsesElement = PolicyBinding.newBuilder().build();
        ListPolicyBindingsResponse expectedResponse = ListPolicyBindingsResponse.newBuilder().setNextPageToken("").addAllPolicyBindings(Arrays.asList(responsesElement)).build();
        mockPolicyBindings.addResponse((AbstractMessage)expectedResponse);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        PolicyBindingsClient.ListPolicyBindingsPagedResponse pagedListResponse = this.client.listPolicyBindings(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getPolicyBindingsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockPolicyBindings.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListPolicyBindingsRequest actualRequest = (ListPolicyBindingsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listPolicyBindingsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockPolicyBindings.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            this.client.listPolicyBindings(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listPolicyBindingsTest3() throws Exception {
        PolicyBinding responsesElement = PolicyBinding.newBuilder().build();
        ListPolicyBindingsResponse expectedResponse = ListPolicyBindingsResponse.newBuilder().setNextPageToken("").addAllPolicyBindings(Arrays.asList(responsesElement)).build();
        mockPolicyBindings.addResponse((AbstractMessage)expectedResponse);
        OrganizationLocationName parent = OrganizationLocationName.of((String)"[ORGANIZATION]", (String)"[LOCATION]");
        PolicyBindingsClient.ListPolicyBindingsPagedResponse pagedListResponse = this.client.listPolicyBindings(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getPolicyBindingsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockPolicyBindings.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListPolicyBindingsRequest actualRequest = (ListPolicyBindingsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listPolicyBindingsExceptionTest3() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockPolicyBindings.addException((Exception)exception);
        try {
            OrganizationLocationName parent = OrganizationLocationName.of((String)"[ORGANIZATION]", (String)"[LOCATION]");
            this.client.listPolicyBindings(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listPolicyBindingsTest4() throws Exception {
        PolicyBinding responsesElement = PolicyBinding.newBuilder().build();
        ListPolicyBindingsResponse expectedResponse = ListPolicyBindingsResponse.newBuilder().setNextPageToken("").addAllPolicyBindings(Arrays.asList(responsesElement)).build();
        mockPolicyBindings.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        PolicyBindingsClient.ListPolicyBindingsPagedResponse pagedListResponse = this.client.listPolicyBindings(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getPolicyBindingsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockPolicyBindings.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListPolicyBindingsRequest actualRequest = (ListPolicyBindingsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listPolicyBindingsExceptionTest4() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockPolicyBindings.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listPolicyBindings(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void searchTargetPolicyBindingsTest() throws Exception {
        PolicyBinding responsesElement = PolicyBinding.newBuilder().build();
        SearchTargetPolicyBindingsResponse expectedResponse = SearchTargetPolicyBindingsResponse.newBuilder().setNextPageToken("").addAllPolicyBindings(Arrays.asList(responsesElement)).build();
        mockPolicyBindings.addResponse((AbstractMessage)expectedResponse);
        FolderLocationName parent = FolderLocationName.of((String)"[FOLDER]", (String)"[LOCATION]");
        String target = "target-880905839";
        PolicyBindingsClient.SearchTargetPolicyBindingsPagedResponse pagedListResponse = this.client.searchTargetPolicyBindings(parent, target);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getPolicyBindingsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockPolicyBindings.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        SearchTargetPolicyBindingsRequest actualRequest = (SearchTargetPolicyBindingsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)target, (Object)actualRequest.getTarget());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void searchTargetPolicyBindingsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockPolicyBindings.addException((Exception)exception);
        try {
            FolderLocationName parent = FolderLocationName.of((String)"[FOLDER]", (String)"[LOCATION]");
            String target = "target-880905839";
            this.client.searchTargetPolicyBindings(parent, target);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void searchTargetPolicyBindingsTest2() throws Exception {
        PolicyBinding responsesElement = PolicyBinding.newBuilder().build();
        SearchTargetPolicyBindingsResponse expectedResponse = SearchTargetPolicyBindingsResponse.newBuilder().setNextPageToken("").addAllPolicyBindings(Arrays.asList(responsesElement)).build();
        mockPolicyBindings.addResponse((AbstractMessage)expectedResponse);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        String target = "target-880905839";
        PolicyBindingsClient.SearchTargetPolicyBindingsPagedResponse pagedListResponse = this.client.searchTargetPolicyBindings(parent, target);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getPolicyBindingsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockPolicyBindings.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        SearchTargetPolicyBindingsRequest actualRequest = (SearchTargetPolicyBindingsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)target, (Object)actualRequest.getTarget());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void searchTargetPolicyBindingsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockPolicyBindings.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            String target = "target-880905839";
            this.client.searchTargetPolicyBindings(parent, target);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void searchTargetPolicyBindingsTest3() throws Exception {
        PolicyBinding responsesElement = PolicyBinding.newBuilder().build();
        SearchTargetPolicyBindingsResponse expectedResponse = SearchTargetPolicyBindingsResponse.newBuilder().setNextPageToken("").addAllPolicyBindings(Arrays.asList(responsesElement)).build();
        mockPolicyBindings.addResponse((AbstractMessage)expectedResponse);
        OrganizationLocationName parent = OrganizationLocationName.of((String)"[ORGANIZATION]", (String)"[LOCATION]");
        String target = "target-880905839";
        PolicyBindingsClient.SearchTargetPolicyBindingsPagedResponse pagedListResponse = this.client.searchTargetPolicyBindings(parent, target);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getPolicyBindingsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockPolicyBindings.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        SearchTargetPolicyBindingsRequest actualRequest = (SearchTargetPolicyBindingsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)target, (Object)actualRequest.getTarget());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void searchTargetPolicyBindingsExceptionTest3() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockPolicyBindings.addException((Exception)exception);
        try {
            OrganizationLocationName parent = OrganizationLocationName.of((String)"[ORGANIZATION]", (String)"[LOCATION]");
            String target = "target-880905839";
            this.client.searchTargetPolicyBindings(parent, target);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void searchTargetPolicyBindingsTest4() throws Exception {
        PolicyBinding responsesElement = PolicyBinding.newBuilder().build();
        SearchTargetPolicyBindingsResponse expectedResponse = SearchTargetPolicyBindingsResponse.newBuilder().setNextPageToken("").addAllPolicyBindings(Arrays.asList(responsesElement)).build();
        mockPolicyBindings.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        String target = "target-880905839";
        PolicyBindingsClient.SearchTargetPolicyBindingsPagedResponse pagedListResponse = this.client.searchTargetPolicyBindings(parent, target);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getPolicyBindingsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockPolicyBindings.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        SearchTargetPolicyBindingsRequest actualRequest = (SearchTargetPolicyBindingsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)target, (Object)actualRequest.getTarget());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void searchTargetPolicyBindingsExceptionTest4() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockPolicyBindings.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            String target = "target-880905839";
            this.client.searchTargetPolicyBindings(parent, target);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }
}

