/*
 * Decompiled with CFR 0.152.
 */
package com.google.iam.v3beta;

import com.google.api.client.http.HttpTransport;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.testing.MockHttpService;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.ApiExceptionFactory;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.testing.FakeStatusCode;
import com.google.common.collect.Lists;
import com.google.iam.v3beta.ListPrincipalAccessBoundaryPoliciesResponse;
import com.google.iam.v3beta.OrganizationLocationName;
import com.google.iam.v3beta.PolicyBinding;
import com.google.iam.v3beta.PrincipalAccessBoundaryPoliciesClient;
import com.google.iam.v3beta.PrincipalAccessBoundaryPoliciesSettings;
import com.google.iam.v3beta.PrincipalAccessBoundaryPolicy;
import com.google.iam.v3beta.PrincipalAccessBoundaryPolicyDetails;
import com.google.iam.v3beta.PrincipalAccessBoundaryPolicyName;
import com.google.iam.v3beta.SearchPrincipalAccessBoundaryPolicyBindingsResponse;
import com.google.iam.v3beta.stub.HttpJsonPrincipalAccessBoundaryPoliciesStub;
import com.google.longrunning.Operation;
import com.google.protobuf.Any;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import com.google.protobuf.Message;
import com.google.protobuf.Timestamp;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class PrincipalAccessBoundaryPoliciesClientHttpJsonTest {
    private static MockHttpService mockService;
    private static PrincipalAccessBoundaryPoliciesClient client;

    @BeforeClass
    public static void startStaticServer() throws IOException {
        mockService = new MockHttpService(HttpJsonPrincipalAccessBoundaryPoliciesStub.getMethodDescriptors(), PrincipalAccessBoundaryPoliciesSettings.getDefaultEndpoint());
        PrincipalAccessBoundaryPoliciesSettings settings = ((PrincipalAccessBoundaryPoliciesSettings.Builder)((PrincipalAccessBoundaryPoliciesSettings.Builder)PrincipalAccessBoundaryPoliciesSettings.newHttpJsonBuilder().setTransportChannelProvider((TransportChannelProvider)PrincipalAccessBoundaryPoliciesSettings.defaultHttpJsonTransportProviderBuilder().setHttpTransport((HttpTransport)mockService).build())).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        client = PrincipalAccessBoundaryPoliciesClient.create((PrincipalAccessBoundaryPoliciesSettings)settings);
    }

    @AfterClass
    public static void stopServer() {
        client.close();
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() throws Exception {
        mockService.reset();
    }

    @Test
    public void createPrincipalAccessBoundaryPolicyTest() throws Exception {
        PrincipalAccessBoundaryPolicy expectedResponse = PrincipalAccessBoundaryPolicy.newBuilder().setName(PrincipalAccessBoundaryPolicyName.of((String)"[ORGANIZATION]", (String)"[LOCATION]", (String)"[PRINCIPAL_ACCESS_BOUNDARY_POLICY]").toString()).setUid("uid115792").setEtag("etag3123477").setDisplayName("displayName1714148973").putAllAnnotations(new HashMap()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setDetails(PrincipalAccessBoundaryPolicyDetails.newBuilder().build()).build();
        Operation resultOperation = Operation.newBuilder().setName("createPrincipalAccessBoundaryPolicyTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        OrganizationLocationName parent = OrganizationLocationName.of((String)"[ORGANIZATION]", (String)"[LOCATION]");
        PrincipalAccessBoundaryPolicy principalAccessBoundaryPolicy = PrincipalAccessBoundaryPolicy.newBuilder().build();
        String principalAccessBoundaryPolicyId = "principalAccessBoundaryPolicyId-198573175";
        PrincipalAccessBoundaryPolicy actualResponse = (PrincipalAccessBoundaryPolicy)client.createPrincipalAccessBoundaryPolicyAsync(parent, principalAccessBoundaryPolicy, principalAccessBoundaryPolicyId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createPrincipalAccessBoundaryPolicyExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            OrganizationLocationName parent = OrganizationLocationName.of((String)"[ORGANIZATION]", (String)"[LOCATION]");
            PrincipalAccessBoundaryPolicy principalAccessBoundaryPolicy = PrincipalAccessBoundaryPolicy.newBuilder().build();
            String principalAccessBoundaryPolicyId = "principalAccessBoundaryPolicyId-198573175";
            client.createPrincipalAccessBoundaryPolicyAsync(parent, principalAccessBoundaryPolicy, principalAccessBoundaryPolicyId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void createPrincipalAccessBoundaryPolicyTest2() throws Exception {
        PrincipalAccessBoundaryPolicy expectedResponse = PrincipalAccessBoundaryPolicy.newBuilder().setName(PrincipalAccessBoundaryPolicyName.of((String)"[ORGANIZATION]", (String)"[LOCATION]", (String)"[PRINCIPAL_ACCESS_BOUNDARY_POLICY]").toString()).setUid("uid115792").setEtag("etag3123477").setDisplayName("displayName1714148973").putAllAnnotations(new HashMap()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setDetails(PrincipalAccessBoundaryPolicyDetails.newBuilder().build()).build();
        Operation resultOperation = Operation.newBuilder().setName("createPrincipalAccessBoundaryPolicyTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        String parent = "organizations/organization-9365/locations/location-9365";
        PrincipalAccessBoundaryPolicy principalAccessBoundaryPolicy = PrincipalAccessBoundaryPolicy.newBuilder().build();
        String principalAccessBoundaryPolicyId = "principalAccessBoundaryPolicyId-198573175";
        PrincipalAccessBoundaryPolicy actualResponse = (PrincipalAccessBoundaryPolicy)client.createPrincipalAccessBoundaryPolicyAsync(parent, principalAccessBoundaryPolicy, principalAccessBoundaryPolicyId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createPrincipalAccessBoundaryPolicyExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "organizations/organization-9365/locations/location-9365";
            PrincipalAccessBoundaryPolicy principalAccessBoundaryPolicy = PrincipalAccessBoundaryPolicy.newBuilder().build();
            String principalAccessBoundaryPolicyId = "principalAccessBoundaryPolicyId-198573175";
            client.createPrincipalAccessBoundaryPolicyAsync(parent, principalAccessBoundaryPolicy, principalAccessBoundaryPolicyId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void getPrincipalAccessBoundaryPolicyTest() throws Exception {
        PrincipalAccessBoundaryPolicy expectedResponse = PrincipalAccessBoundaryPolicy.newBuilder().setName(PrincipalAccessBoundaryPolicyName.of((String)"[ORGANIZATION]", (String)"[LOCATION]", (String)"[PRINCIPAL_ACCESS_BOUNDARY_POLICY]").toString()).setUid("uid115792").setEtag("etag3123477").setDisplayName("displayName1714148973").putAllAnnotations(new HashMap()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setDetails(PrincipalAccessBoundaryPolicyDetails.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        PrincipalAccessBoundaryPolicyName name = PrincipalAccessBoundaryPolicyName.of((String)"[ORGANIZATION]", (String)"[LOCATION]", (String)"[PRINCIPAL_ACCESS_BOUNDARY_POLICY]");
        PrincipalAccessBoundaryPolicy actualResponse = client.getPrincipalAccessBoundaryPolicy(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getPrincipalAccessBoundaryPolicyExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            PrincipalAccessBoundaryPolicyName name = PrincipalAccessBoundaryPolicyName.of((String)"[ORGANIZATION]", (String)"[LOCATION]", (String)"[PRINCIPAL_ACCESS_BOUNDARY_POLICY]");
            client.getPrincipalAccessBoundaryPolicy(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getPrincipalAccessBoundaryPolicyTest2() throws Exception {
        PrincipalAccessBoundaryPolicy expectedResponse = PrincipalAccessBoundaryPolicy.newBuilder().setName(PrincipalAccessBoundaryPolicyName.of((String)"[ORGANIZATION]", (String)"[LOCATION]", (String)"[PRINCIPAL_ACCESS_BOUNDARY_POLICY]").toString()).setUid("uid115792").setEtag("etag3123477").setDisplayName("displayName1714148973").putAllAnnotations(new HashMap()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setDetails(PrincipalAccessBoundaryPolicyDetails.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        String name = "organizations/organization-2178/locations/location-2178/principalAccessBoundaryPolicies/principalAccessBoundaryPolicie-2178";
        PrincipalAccessBoundaryPolicy actualResponse = client.getPrincipalAccessBoundaryPolicy(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getPrincipalAccessBoundaryPolicyExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "organizations/organization-2178/locations/location-2178/principalAccessBoundaryPolicies/principalAccessBoundaryPolicie-2178";
            client.getPrincipalAccessBoundaryPolicy(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updatePrincipalAccessBoundaryPolicyTest() throws Exception {
        PrincipalAccessBoundaryPolicy expectedResponse = PrincipalAccessBoundaryPolicy.newBuilder().setName(PrincipalAccessBoundaryPolicyName.of((String)"[ORGANIZATION]", (String)"[LOCATION]", (String)"[PRINCIPAL_ACCESS_BOUNDARY_POLICY]").toString()).setUid("uid115792").setEtag("etag3123477").setDisplayName("displayName1714148973").putAllAnnotations(new HashMap()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setDetails(PrincipalAccessBoundaryPolicyDetails.newBuilder().build()).build();
        Operation resultOperation = Operation.newBuilder().setName("updatePrincipalAccessBoundaryPolicyTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        PrincipalAccessBoundaryPolicy principalAccessBoundaryPolicy = PrincipalAccessBoundaryPolicy.newBuilder().setName(PrincipalAccessBoundaryPolicyName.of((String)"[ORGANIZATION]", (String)"[LOCATION]", (String)"[PRINCIPAL_ACCESS_BOUNDARY_POLICY]").toString()).setUid("uid115792").setEtag("etag3123477").setDisplayName("displayName1714148973").putAllAnnotations(new HashMap()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setDetails(PrincipalAccessBoundaryPolicyDetails.newBuilder().build()).build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        PrincipalAccessBoundaryPolicy actualResponse = (PrincipalAccessBoundaryPolicy)client.updatePrincipalAccessBoundaryPolicyAsync(principalAccessBoundaryPolicy, updateMask).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void updatePrincipalAccessBoundaryPolicyExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            PrincipalAccessBoundaryPolicy principalAccessBoundaryPolicy = PrincipalAccessBoundaryPolicy.newBuilder().setName(PrincipalAccessBoundaryPolicyName.of((String)"[ORGANIZATION]", (String)"[LOCATION]", (String)"[PRINCIPAL_ACCESS_BOUNDARY_POLICY]").toString()).setUid("uid115792").setEtag("etag3123477").setDisplayName("displayName1714148973").putAllAnnotations(new HashMap()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setDetails(PrincipalAccessBoundaryPolicyDetails.newBuilder().build()).build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            client.updatePrincipalAccessBoundaryPolicyAsync(principalAccessBoundaryPolicy, updateMask).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void deletePrincipalAccessBoundaryPolicyTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deletePrincipalAccessBoundaryPolicyTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        PrincipalAccessBoundaryPolicyName name = PrincipalAccessBoundaryPolicyName.of((String)"[ORGANIZATION]", (String)"[LOCATION]", (String)"[PRINCIPAL_ACCESS_BOUNDARY_POLICY]");
        client.deletePrincipalAccessBoundaryPolicyAsync(name).get();
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deletePrincipalAccessBoundaryPolicyExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            PrincipalAccessBoundaryPolicyName name = PrincipalAccessBoundaryPolicyName.of((String)"[ORGANIZATION]", (String)"[LOCATION]", (String)"[PRINCIPAL_ACCESS_BOUNDARY_POLICY]");
            client.deletePrincipalAccessBoundaryPolicyAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void deletePrincipalAccessBoundaryPolicyTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deletePrincipalAccessBoundaryPolicyTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        String name = "organizations/organization-2178/locations/location-2178/principalAccessBoundaryPolicies/principalAccessBoundaryPolicie-2178";
        client.deletePrincipalAccessBoundaryPolicyAsync(name).get();
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deletePrincipalAccessBoundaryPolicyExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "organizations/organization-2178/locations/location-2178/principalAccessBoundaryPolicies/principalAccessBoundaryPolicie-2178";
            client.deletePrincipalAccessBoundaryPolicyAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void listPrincipalAccessBoundaryPoliciesTest() throws Exception {
        PrincipalAccessBoundaryPolicy responsesElement = PrincipalAccessBoundaryPolicy.newBuilder().build();
        ListPrincipalAccessBoundaryPoliciesResponse expectedResponse = ListPrincipalAccessBoundaryPoliciesResponse.newBuilder().setNextPageToken("").addAllPrincipalAccessBoundaryPolicies(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        OrganizationLocationName parent = OrganizationLocationName.of((String)"[ORGANIZATION]", (String)"[LOCATION]");
        PrincipalAccessBoundaryPoliciesClient.ListPrincipalAccessBoundaryPoliciesPagedResponse pagedListResponse = client.listPrincipalAccessBoundaryPolicies(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getPrincipalAccessBoundaryPoliciesList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listPrincipalAccessBoundaryPoliciesExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            OrganizationLocationName parent = OrganizationLocationName.of((String)"[ORGANIZATION]", (String)"[LOCATION]");
            client.listPrincipalAccessBoundaryPolicies(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listPrincipalAccessBoundaryPoliciesTest2() throws Exception {
        PrincipalAccessBoundaryPolicy responsesElement = PrincipalAccessBoundaryPolicy.newBuilder().build();
        ListPrincipalAccessBoundaryPoliciesResponse expectedResponse = ListPrincipalAccessBoundaryPoliciesResponse.newBuilder().setNextPageToken("").addAllPrincipalAccessBoundaryPolicies(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "organizations/organization-9365/locations/location-9365";
        PrincipalAccessBoundaryPoliciesClient.ListPrincipalAccessBoundaryPoliciesPagedResponse pagedListResponse = client.listPrincipalAccessBoundaryPolicies(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getPrincipalAccessBoundaryPoliciesList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listPrincipalAccessBoundaryPoliciesExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "organizations/organization-9365/locations/location-9365";
            client.listPrincipalAccessBoundaryPolicies(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void searchPrincipalAccessBoundaryPolicyBindingsTest() throws Exception {
        PolicyBinding responsesElement = PolicyBinding.newBuilder().build();
        SearchPrincipalAccessBoundaryPolicyBindingsResponse expectedResponse = SearchPrincipalAccessBoundaryPolicyBindingsResponse.newBuilder().setNextPageToken("").addAllPolicyBindings(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        PrincipalAccessBoundaryPolicyName name = PrincipalAccessBoundaryPolicyName.of((String)"[ORGANIZATION]", (String)"[LOCATION]", (String)"[PRINCIPAL_ACCESS_BOUNDARY_POLICY]");
        PrincipalAccessBoundaryPoliciesClient.SearchPrincipalAccessBoundaryPolicyBindingsPagedResponse pagedListResponse = client.searchPrincipalAccessBoundaryPolicyBindings(name);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getPolicyBindingsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void searchPrincipalAccessBoundaryPolicyBindingsExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            PrincipalAccessBoundaryPolicyName name = PrincipalAccessBoundaryPolicyName.of((String)"[ORGANIZATION]", (String)"[LOCATION]", (String)"[PRINCIPAL_ACCESS_BOUNDARY_POLICY]");
            client.searchPrincipalAccessBoundaryPolicyBindings(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void searchPrincipalAccessBoundaryPolicyBindingsTest2() throws Exception {
        PolicyBinding responsesElement = PolicyBinding.newBuilder().build();
        SearchPrincipalAccessBoundaryPolicyBindingsResponse expectedResponse = SearchPrincipalAccessBoundaryPolicyBindingsResponse.newBuilder().setNextPageToken("").addAllPolicyBindings(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        String name = "organizations/organization-2178/locations/location-2178/principalAccessBoundaryPolicies/principalAccessBoundaryPolicie-2178";
        PrincipalAccessBoundaryPoliciesClient.SearchPrincipalAccessBoundaryPolicyBindingsPagedResponse pagedListResponse = client.searchPrincipalAccessBoundaryPolicyBindings(name);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getPolicyBindingsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void searchPrincipalAccessBoundaryPolicyBindingsExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "organizations/organization-2178/locations/location-2178/principalAccessBoundaryPolicies/principalAccessBoundaryPolicie-2178";
            client.searchPrincipalAccessBoundaryPolicyBindings(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }
}

