/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.healthcare.deid.redactor;

import com.google.cloud.healthcare.deid.redactor.protos.DicomConfigProtos;
import com.google.protobuf.Message;
import com.google.protobuf.TextFormat;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.StandardElementDictionary;
import org.dcm4che3.data.VR;
import org.dcm4che3.imageio.codec.TransferSyntaxType;
import org.dcm4che3.io.BulkDataDescriptor;
import org.dcm4che3.io.DicomInputStream;
import org.dcm4che3.io.DicomOutputStream;
import org.dcm4che3.util.UIDUtils;

public class DicomRedactor {
    private final RedactorSettings settings;
    private static final List<Integer> replaceUIDs = new ArrayList<Integer>(Arrays.asList(524312, 0x20000D, 0x20000E, 131075));
    private static final String CHC_BASIC_FILE = "chc_basic.textproto";

    public DicomRedactor(DicomConfigProtos.DicomConfig config) throws Exception {
        this.settings = this.parseConfig(config);
    }

    public DicomRedactor(DicomConfigProtos.DicomConfig config, String prefix) throws Exception {
        this(config);
        UIDUtils.setRoot((String)prefix);
    }

    private RedactorSettings parseConfig(DicomConfigProtos.DicomConfig config) throws IllegalArgumentException {
        DicomConfigProtos.DicomConfig.TagFilterList tags;
        RedactorSettings ret = new RedactorSettings();
        switch (config.getTagFilterCase()) {
            case KEEP_LIST: {
                ret.isKeepList = true;
                tags = config.getKeepList();
                break;
            }
            case REMOVE_LIST: {
                ret.isKeepList = false;
                tags = config.getRemoveList();
                break;
            }
            case FILTER_PROFILE: {
                switch (config.getFilterProfile()) {
                    case TAG_FILTER_PROFILE_UNSPECIFIED: 
                    case CHC_BASIC: {
                        DicomConfigProtos.DicomConfig.Builder configBuilder = DicomConfigProtos.DicomConfig.newBuilder();
                        TextFormat.Parser parser = TextFormat.Parser.newBuilder().build();
                        StringBuilder protoString = new StringBuilder();
                        try (BufferedReader protoReader = new BufferedReader(new InputStreamReader(DicomRedactor.class.getClassLoader().getResourceAsStream(CHC_BASIC_FILE)));){
                            String line;
                            while ((line = protoReader.readLine()) != null) {
                                protoString.append(line).append('\n');
                            }
                            parser.merge((CharSequence)protoString.toString(), (Message.Builder)configBuilder);
                            if (configBuilder.hasFilterProfile()) {
                                throw new InternalError("Profile cannot point to another profile");
                            }
                        }
                        catch (Exception e) {
                            throw new InternalError("Failed to load selected profile.", e);
                        }
                        return this.parseConfig(configBuilder.build());
                    }
                }
                throw new IllegalArgumentException("Config specifies an unrecognized profile.");
            }
            default: {
                throw new IllegalArgumentException("Config does not specify a tag filtration method.");
            }
        }
        ret.tagSet = new HashSet<Integer>();
        for (String tag : tags.getTagsList()) {
            int tagID = this.toTagID(tag);
            ret.tagSet.add(tagID);
        }
        return ret;
    }

    private int toTagID(String tag) throws IllegalArgumentException {
        int ret;
        int tagNum = StandardElementDictionary.tagForKeyword((String)tag, null);
        if (tagNum != -1) {
            return tagNum;
        }
        try {
            ret = Integer.parseInt(tag, 16);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Failed to recognize DICOM tag: %s", tag));
        }
        return ret;
    }

    private void regenUID(Attributes attrs, int tag) {
        String newUID = UIDUtils.createNameBasedUID((byte[])attrs.getString(tag).getBytes());
        attrs.setString(tag, VR.UI, newUID);
    }

    public void redact(InputStream inStream, OutputStream outStream) throws IOException, IllegalArgumentException {
        Attributes dataset;
        Attributes metadata;
        try (DicomInputStream dicomInputStream = new DicomInputStream(inStream);){
            dicomInputStream.setIncludeBulkData(DicomInputStream.IncludeBulkData.YES);
            dicomInputStream.setBulkDataDescriptor(BulkDataDescriptor.PIXELDATA);
            metadata = dicomInputStream.getFileMetaInformation();
            dataset = dicomInputStream.readDataset(-1, -1);
        }
        catch (Exception e) {
            throw new IOException("Failed to read input DICOM object", e);
        }
        try {
            RedactVisitor visitor = new RedactVisitor();
            dataset.accept((Attributes.Visitor)visitor, false);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to redact one or more tags", e);
        }
        this.regenUID(metadata, 131075);
        String ts = metadata.getString(131088);
        if (dataset.contains(this.toTagID("PixelData")) && !dataset.containsValue(this.toTagID("PixelData")) && TransferSyntaxType.forUID((String)ts) != TransferSyntaxType.NATIVE) {
            metadata.setString(131088, VR.UI, "1.2.840.10008.1.2.1");
        }
        try (DicomOutputStream dicomOutputStream = new DicomOutputStream(outStream, "1.2.840.10008.1.2.1");){
            dicomOutputStream.writeDataset(metadata, dataset);
        }
        catch (Exception e) {
            throw new IOException("Failed to write output DICOM object", e);
        }
    }

    private class RedactVisitor
    implements Attributes.Visitor {
        private RedactVisitor() {
        }

        public boolean visit(Attributes attrs, int tag, VR vr, Object value) {
            if (replaceUIDs.contains(tag)) {
                DicomRedactor.this.regenUID(attrs, tag);
                return true;
            }
            if (((DicomRedactor)DicomRedactor.this).settings.isKeepList && !((DicomRedactor)DicomRedactor.this).settings.tagSet.contains(tag) || !((DicomRedactor)DicomRedactor.this).settings.isKeepList && ((DicomRedactor)DicomRedactor.this).settings.tagSet.contains(tag)) {
                attrs.setNull(tag, vr);
            }
            return true;
        }
    }

    private final class RedactorSettings {
        public Set<Integer> tagSet;
        public boolean isKeepList;

        private RedactorSettings() {
        }
    }
}

