/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.opensource.classpath;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.nio.file.Path;
import java.util.Objects;

public final class ClassFile {
    private final Path jar;
    private final String className;

    public ClassFile(Path jar, String className) {
        this.jar = (Path)Preconditions.checkNotNull((Object)jar);
        this.className = (String)Preconditions.checkNotNull((Object)className);
    }

    public Path getJar() {
        return this.jar;
    }

    public String getClassName() {
        return this.className;
    }

    public ClassFile topLevelClassFile() {
        return this.className.contains("$") ? new ClassFile(this.jar, this.className.split("\\$")[0]) : this;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ClassFile that = (ClassFile)other;
        return Objects.equals(this.jar, that.jar) && Objects.equals(this.className, that.className);
    }

    public int hashCode() {
        return Objects.hash(this.jar, this.className);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("jar", (Object)this.jar).add("className", (Object)this.className).toString();
    }
}

