/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.opensource.classpath;

import com.google.cloud.tools.opensource.dependencies.Artifacts;
import com.google.cloud.tools.opensource.dependencies.DependencyGraph;
import com.google.cloud.tools.opensource.dependencies.DependencyGraphBuilder;
import com.google.cloud.tools.opensource.dependencies.DependencyPath;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Maps;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.aether.RepositoryException;
import org.eclipse.aether.artifact.Artifact;

public class ClassPathBuilder {
    public static ImmutableList<Path> artifactsToClasspath(List<Artifact> artifacts) throws RepositoryException {
        LinkedListMultimap<Path, DependencyPath> multimap = ClassPathBuilder.artifactsToDependencyPaths(artifacts);
        return ImmutableList.copyOf((Collection)multimap.keySet());
    }

    public static LinkedListMultimap<Path, DependencyPath> artifactsToDependencyPaths(List<Artifact> artifacts) throws RepositoryException {
        LinkedListMultimap multimap = LinkedListMultimap.create();
        if (artifacts.isEmpty()) {
            return multimap;
        }
        DependencyGraph dependencyGraph = DependencyGraphBuilder.getStaticLinkageCheckDependencyGraph(artifacts);
        List<DependencyPath> dependencyPaths = dependencyGraph.list();
        HashMap keyToFirstArtifactVersion = Maps.newHashMap();
        for (DependencyPath dependencyPath : dependencyPaths) {
            Artifact artifact = dependencyPath.getLeaf();
            Path jarAbsolutePath = artifact.getFile().toPath().toAbsolutePath();
            if (!jarAbsolutePath.toString().endsWith(".jar")) continue;
            String artifactVersion = artifact.getVersion();
            String dependencyMediationKey = Artifacts.makeKey(artifact);
            String firstArtifactVersionForKey = (String)keyToFirstArtifactVersion.get(dependencyMediationKey);
            if (firstArtifactVersionForKey != null && !artifactVersion.equals(firstArtifactVersionForKey)) continue;
            keyToFirstArtifactVersion.put(dependencyMediationKey, artifact.getVersion());
            multimap.put((Object)jarAbsolutePath, (Object)dependencyPath);
        }
        return multimap;
    }
}

