/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.opensource.classpath;

import com.google.cloud.tools.opensource.classpath.ClassDumper;
import com.google.cloud.tools.opensource.classpath.ClassFile;
import com.google.cloud.tools.opensource.classpath.ClassSymbol;
import com.google.cloud.tools.opensource.classpath.SymbolReferenceMaps;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.MutableGraph;
import com.google.common.graph.SuccessorsFunction;
import com.google.common.graph.Traverser;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Set;

public class ClassReferenceGraph {
    private final ImmutableSet<String> reachableClasses;

    static ClassReferenceGraph create(SymbolReferenceMaps symbolReferenceMaps, Set<Path> entryPointJars) throws IOException {
        ImmutableSet.Builder entryPointClassBuilder = ImmutableSet.builder();
        for (Path jar : entryPointJars) {
            for (String className : ClassDumper.listClassFileNames(jar)) {
                entryPointClassBuilder.add((Object)className);
            }
        }
        return new ClassReferenceGraph(symbolReferenceMaps.getClassToClassSymbols(), (Set<String>)entryPointClassBuilder.build());
    }

    private ClassReferenceGraph(ImmutableSetMultimap<ClassFile, ClassSymbol> classSymbolReferences, Set<String> entryPointClasses) {
        MutableGraph graph = GraphBuilder.directed().allowsSelfLoops(false).build();
        classSymbolReferences.forEach((classFile, classSymbol) -> {
            String targetClassName;
            String sourceClassName = classFile.getClassName();
            if (!sourceClassName.equals(targetClassName = classSymbol.getClassName())) {
                graph.putEdge((Object)sourceClassName, (Object)targetClassName);
            }
        });
        entryPointClasses.forEach(arg_0 -> ((MutableGraph)graph).addNode(arg_0));
        this.reachableClasses = ImmutableSet.copyOf((Iterable)Traverser.forGraph((SuccessorsFunction)graph).breadthFirst(entryPointClasses));
    }

    public boolean isReachable(String className) {
        return this.reachableClasses.contains((Object)className);
    }
}

