/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.opensource.classpath;

import com.google.cloud.tools.opensource.classpath.ClassDumper;
import com.google.cloud.tools.opensource.classpath.ClassFile;
import com.google.cloud.tools.opensource.classpath.ClassPathBuilder;
import com.google.cloud.tools.opensource.classpath.ClassReferenceGraph;
import com.google.cloud.tools.opensource.classpath.ClassSymbol;
import com.google.cloud.tools.opensource.classpath.ErrorType;
import com.google.cloud.tools.opensource.classpath.FieldSymbol;
import com.google.cloud.tools.opensource.classpath.InterfaceSymbol;
import com.google.cloud.tools.opensource.classpath.MethodSymbol;
import com.google.cloud.tools.opensource.classpath.SuperClassSymbol;
import com.google.cloud.tools.opensource.classpath.SymbolProblem;
import com.google.cloud.tools.opensource.classpath.SymbolReferenceMaps;
import com.google.cloud.tools.opensource.dependencies.Bom;
import com.google.cloud.tools.opensource.dependencies.DependencyPath;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.FieldOrMethod;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.eclipse.aether.RepositoryException;
import org.eclipse.aether.artifact.Artifact;

public class LinkageChecker {
    private static final Logger logger = Logger.getLogger(LinkageChecker.class.getName());
    private static final ImmutableSet<String> SOURCE_CLASSES_TO_SUPPRESS = ImmutableSet.of((Object)"reactor.core.publisher.Traces");
    private final ClassDumper classDumper;
    private final ImmutableList<Path> jars;
    private final SymbolReferenceMaps classToSymbols;
    private final ClassReferenceGraph classReferenceGraph;

    @VisibleForTesting
    SymbolReferenceMaps getClassToSymbols() {
        return this.classToSymbols;
    }

    public ClassReferenceGraph getClassReferenceGraph() {
        return this.classReferenceGraph;
    }

    public static LinkageChecker create(List<Path> jars, Iterable<Path> entryPoints) throws IOException {
        Preconditions.checkArgument((!jars.isEmpty() ? 1 : 0) != 0, (Object)"The linkage classpath is empty. Specify input to supply one or more jar files");
        ClassDumper dumper = ClassDumper.create(jars);
        SymbolReferenceMaps symbolReferenceMaps = dumper.findSymbolReferences();
        ClassReferenceGraph classReferenceGraph = ClassReferenceGraph.create(symbolReferenceMaps, (Set<Path>)ImmutableSet.copyOf(entryPoints));
        return new LinkageChecker(dumper, jars, symbolReferenceMaps, classReferenceGraph);
    }

    public static LinkageChecker create(Bom bom) throws RepositoryException, IOException {
        ImmutableList<Artifact> managedDependencies = bom.getManagedDependencies();
        LinkedListMultimap<Path, DependencyPath> jarToDependencyPaths = ClassPathBuilder.artifactsToDependencyPaths(managedDependencies);
        ImmutableList classpath = ImmutableList.copyOf((Collection)jarToDependencyPaths.keySet());
        ImmutableList artifactJarsInBom = classpath.subList(0, managedDependencies.size());
        ImmutableSet entryPoints = ImmutableSet.copyOf((Collection)artifactJarsInBom);
        return LinkageChecker.create((List<Path>)classpath, (Iterable<Path>)entryPoints);
    }

    @VisibleForTesting
    LinkageChecker cloneWith(SymbolReferenceMaps newSymbolMaps) {
        return new LinkageChecker(this.classDumper, (List<Path>)this.jars, newSymbolMaps, this.classReferenceGraph);
    }

    private LinkageChecker(ClassDumper classDumper, List<Path> jars, SymbolReferenceMaps symbolReferenceMaps, ClassReferenceGraph classReferenceGraph) {
        this.classDumper = (ClassDumper)Preconditions.checkNotNull((Object)classDumper);
        this.jars = ImmutableList.copyOf(jars);
        this.classReferenceGraph = (ClassReferenceGraph)Preconditions.checkNotNull((Object)classReferenceGraph);
        this.classToSymbols = (SymbolReferenceMaps)Preconditions.checkNotNull((Object)symbolReferenceMaps);
    }

    public ImmutableSetMultimap<SymbolProblem, ClassFile> findSymbolProblems() {
        ImmutableSetMultimap.Builder problemToClass = ImmutableSetMultimap.builder();
        ImmutableSetMultimap<ClassFile, ClassSymbol> classToClassSymbols = this.classToSymbols.getClassToClassSymbols();
        classToClassSymbols.forEach((classFile, classSymbol) -> {
            ImmutableList<SymbolProblem> problems;
            if (classSymbol instanceof SuperClassSymbol && !(problems = this.findAbstractParentProblems((ClassFile)classFile, (SuperClassSymbol)classSymbol)).isEmpty()) {
                String superClassName = classSymbol.getClassName();
                Path superClassLocation = this.classDumper.findClassLocation(superClassName);
                ClassFile superClassFile = new ClassFile(superClassLocation, superClassName);
                for (SymbolProblem problem2 : problems) {
                    problemToClass.put((Object)problem2, (Object)superClassFile);
                }
            }
            if (!this.classDumper.classesDefinedInJar(classFile.getJar()).contains((Object)classSymbol.getClassName())) {
                if (classSymbol instanceof InterfaceSymbol) {
                    problems = this.findInterfaceProblems((ClassFile)classFile, (InterfaceSymbol)classSymbol);
                    if (!problems.isEmpty()) {
                        String interfaceName = classSymbol.getClassName();
                        Path interfaceLocation = this.classDumper.findClassLocation(interfaceName);
                        ClassFile interfaceClassFile = new ClassFile(interfaceLocation, interfaceName);
                        for (SymbolProblem problem2 : problems) {
                            problemToClass.put((Object)problem2, (Object)interfaceClassFile);
                        }
                    }
                } else {
                    this.findSymbolProblem((ClassFile)classFile, (ClassSymbol)classSymbol).ifPresent(problem -> problemToClass.put(problem, (Object)classFile.topLevelClassFile()));
                }
            }
        });
        ImmutableSetMultimap<ClassFile, MethodSymbol> classToMethodSymbols = this.classToSymbols.getClassToMethodSymbols();
        classToMethodSymbols.forEach((classFile, methodSymbol) -> {
            if (!this.classDumper.classesDefinedInJar(classFile.getJar()).contains((Object)methodSymbol.getClassName())) {
                this.findSymbolProblem((ClassFile)classFile, (MethodSymbol)methodSymbol).ifPresent(problem -> problemToClass.put(problem, (Object)classFile.topLevelClassFile()));
            }
        });
        ImmutableSetMultimap<ClassFile, FieldSymbol> classToFieldSymbols = this.classToSymbols.getClassToFieldSymbols();
        classToFieldSymbols.forEach((classFile, fieldSymbol) -> {
            if (!this.classDumper.classesDefinedInJar(classFile.getJar()).contains((Object)fieldSymbol.getClassName())) {
                this.findSymbolProblem((ClassFile)classFile, (FieldSymbol)fieldSymbol).ifPresent(problem -> problemToClass.put(problem, (Object)classFile.topLevelClassFile()));
            }
        });
        SetMultimap filteredMap = Multimaps.filterEntries((SetMultimap)problemToClass.build(), LinkageChecker::problemFilter);
        return ImmutableSetMultimap.copyOf((Multimap)filteredMap);
    }

    private static boolean problemFilter(Map.Entry<SymbolProblem, ClassFile> entry) {
        ClassFile classFile = entry.getValue();
        SymbolProblem symbolProblem = entry.getKey();
        String sourceClassName = classFile.getClassName();
        if (SOURCE_CLASSES_TO_SUPPRESS.contains((Object)sourceClassName)) {
            return false;
        }
        String problematicClassName = symbolProblem.getSymbol().getClassName();
        if (problematicClassName.startsWith("jdk.vm.ci") && (sourceClassName.startsWith("com.oracle.svm") || sourceClassName.startsWith("com.oracle.graal") || sourceClassName.startsWith("org.graalvm"))) {
            return false;
        }
        return !problematicClassName.equals("org.mockito.internal.creation.bytebuddy.MockMethodDispatcher") || !sourceClassName.startsWith("org.mockito.internal.creation.bytebuddy");
    }

    @VisibleForTesting
    Optional<SymbolProblem> findSymbolProblem(ClassFile classFile, MethodSymbol symbol) {
        String sourceClassName = classFile.getClassName();
        String targetClassName = symbol.getClassName();
        String methodName = symbol.getName();
        if (this.classDumper.isSystemClass(targetClassName)) {
            return Optional.empty();
        }
        try {
            ClassFile containingClassFile;
            JavaClass targetJavaClass = this.classDumper.loadJavaClass(targetClassName);
            Path classFileLocation = this.classDumper.findClassLocation(targetClassName);
            ClassFile classFile2 = containingClassFile = classFileLocation == null ? null : new ClassFile(classFileLocation, targetClassName);
            if (!this.isClassAccessibleFrom(targetJavaClass, sourceClassName)) {
                return Optional.of(new SymbolProblem(symbol, ErrorType.INACCESSIBLE_CLASS, containingClassFile));
            }
            if (targetJavaClass.isInterface() != symbol.isInterfaceMethod()) {
                return Optional.of(new SymbolProblem(symbol, ErrorType.INCOMPATIBLE_CLASS_CHANGE, containingClassFile));
            }
            Optional<SymbolProblem> parentSymbolProblem = this.findParentSymbolProblem(targetClassName);
            if (parentSymbolProblem.isPresent()) {
                return parentSymbolProblem;
            }
            Iterable typesToCheck = Iterables.concat(ClassDumper.getClassHierarchy(targetJavaClass), Arrays.asList(targetJavaClass.getAllInterfaces()));
            for (JavaClass javaClass : typesToCheck) {
                for (Method method : javaClass.getMethods()) {
                    if (!method.getName().equals(methodName) || !method.getSignature().equals(symbol.getDescriptor())) continue;
                    if (!this.isMemberAccessibleFrom(javaClass, (FieldOrMethod)method, sourceClassName)) {
                        return Optional.of(new SymbolProblem(symbol, ErrorType.INACCESSIBLE_MEMBER, containingClassFile));
                    }
                    return Optional.empty();
                }
            }
            if (this.classDumper.catchesLinkageError(sourceClassName)) {
                return Optional.empty();
            }
            return Optional.of(new SymbolProblem(symbol, ErrorType.SYMBOL_NOT_FOUND, containingClassFile));
        }
        catch (ClassNotFoundException ex) {
            if (this.classDumper.catchesLinkageError(sourceClassName)) {
                return Optional.empty();
            }
            ClassSymbol classSymbol = new ClassSymbol(symbol.getClassName());
            return Optional.of(new SymbolProblem(classSymbol, ErrorType.CLASS_NOT_FOUND, null));
        }
    }

    private ImmutableList<SymbolProblem> findInterfaceProblems(ClassFile classFile, InterfaceSymbol interfaceSymbol) {
        String interfaceName = interfaceSymbol.getClassName();
        if (this.classDumper.isSystemClass(interfaceName)) {
            return ImmutableList.of();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        try {
            JavaClass implementingClass = this.classDumper.loadJavaClass(classFile.getClassName());
            if (implementingClass.isAbstract()) {
                return ImmutableList.of();
            }
            JavaClass interfaceDefinition = this.classDumper.loadJavaClass(interfaceName);
            for (Method interfaceMethod : interfaceDefinition.getMethods()) {
                if (interfaceMethod.getCode() != null) continue;
                String interfaceMethodName = interfaceMethod.getName();
                String interfaceMethodDescriptor = interfaceMethod.getSignature();
                boolean methodFound = false;
                Iterable typesToCheck = Iterables.concat((Iterable[])new Iterable[]{ClassDumper.getClassHierarchy(implementingClass)});
                block3: for (JavaClass javaClass : typesToCheck) {
                    for (Method method : javaClass.getMethods()) {
                        if (!method.getName().equals(interfaceMethodName) || !method.getSignature().equals(interfaceMethodDescriptor)) continue;
                        methodFound = true;
                        continue block3;
                    }
                }
                if (methodFound) continue;
                MethodSymbol missingMethodOnClass = new MethodSymbol(classFile.getClassName(), interfaceMethodName, interfaceMethodDescriptor, false);
                builder.add((Object)new SymbolProblem(missingMethodOnClass, ErrorType.ABSTRACT_METHOD, classFile));
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return builder.build();
    }

    @VisibleForTesting
    Optional<SymbolProblem> findSymbolProblem(ClassFile classFile, FieldSymbol symbol) {
        String sourceClassName = classFile.getClassName();
        String targetClassName = symbol.getClassName();
        String fieldName = symbol.getName();
        try {
            ClassFile containingClassFile;
            JavaClass targetJavaClass = this.classDumper.loadJavaClass(targetClassName);
            Path classFileLocation = this.classDumper.findClassLocation(targetClassName);
            ClassFile classFile2 = containingClassFile = classFileLocation == null ? null : new ClassFile(classFileLocation, targetClassName);
            if (!this.isClassAccessibleFrom(targetJavaClass, sourceClassName)) {
                return Optional.of(new SymbolProblem(symbol, ErrorType.INACCESSIBLE_CLASS, containingClassFile));
            }
            for (JavaClass javaClass : ClassDumper.getClassHierarchy(targetJavaClass)) {
                for (Field field : javaClass.getFields()) {
                    if (!field.getName().equals(fieldName)) continue;
                    if (!this.isMemberAccessibleFrom(javaClass, (FieldOrMethod)field, sourceClassName)) {
                        return Optional.of(new SymbolProblem(symbol, ErrorType.INACCESSIBLE_MEMBER, containingClassFile));
                    }
                    return Optional.empty();
                }
            }
            return Optional.of(new SymbolProblem(symbol, ErrorType.SYMBOL_NOT_FOUND, containingClassFile));
        }
        catch (ClassNotFoundException ex) {
            if (this.classDumper.catchesLinkageError(sourceClassName)) {
                return Optional.empty();
            }
            ClassSymbol classSymbol = new ClassSymbol(symbol.getClassName());
            return Optional.of(new SymbolProblem(classSymbol, ErrorType.CLASS_NOT_FOUND, null));
        }
    }

    private boolean isMemberAccessibleFrom(JavaClass targetClass, FieldOrMethod member, String sourceClassName) {
        if (member.isPublic()) {
            return true;
        }
        if (member.isProtected()) {
            if (ClassDumper.classesInSamePackage(targetClass.getClassName(), sourceClassName)) {
                return true;
            }
            try {
                JavaClass sourceClass = this.classDumper.loadJavaClass(sourceClassName);
                if (ClassDumper.isClassSubClassOf(sourceClass, targetClass)) {
                    return true;
                }
            }
            catch (ClassNotFoundException ex) {
                logger.warning("The source class " + sourceClassName + " of a reference was not found in the class path when checking accessibility");
                return false;
            }
        }
        if (member.isPrivate()) {
            return false;
        }
        return ClassDumper.classesInSamePackage(targetClass.getClassName(), sourceClassName);
    }

    @VisibleForTesting
    Optional<SymbolProblem> findSymbolProblem(ClassFile classFile, ClassSymbol symbol) {
        String sourceClassName = classFile.getClassName();
        String targetClassName = symbol.getClassName();
        try {
            JavaClass targetClass = this.classDumper.loadJavaClass(targetClassName);
            Path classFileLocation = this.classDumper.findClassLocation(targetClassName);
            ClassFile containingClassFile = classFileLocation == null ? null : new ClassFile(classFileLocation, targetClassName);
            boolean isSubclassReference = symbol instanceof SuperClassSymbol;
            if (isSubclassReference && !this.classDumper.hasValidSuperclass(this.classDumper.loadJavaClass(sourceClassName), targetClass)) {
                return Optional.of(new SymbolProblem(symbol, ErrorType.INCOMPATIBLE_CLASS_CHANGE, containingClassFile));
            }
            if (!this.isClassAccessibleFrom(targetClass, sourceClassName)) {
                return Optional.of(new SymbolProblem(symbol, ErrorType.INACCESSIBLE_CLASS, containingClassFile));
            }
            return Optional.empty();
        }
        catch (ClassNotFoundException ex) {
            if (this.classDumper.isUnusedClassSymbolReference(sourceClassName, symbol) || this.classDumper.catchesLinkageError(sourceClassName)) {
                return Optional.empty();
            }
            return Optional.of(new SymbolProblem(symbol, ErrorType.CLASS_NOT_FOUND, null));
        }
    }

    private boolean isClassAccessibleFrom(JavaClass javaClass, String sourceClassName) throws ClassNotFoundException {
        if (javaClass.isPrivate()) {
            return false;
        }
        String targetClassName = javaClass.getClassName();
        if (javaClass.isPublic() || ClassDumper.classesInSamePackage(targetClassName, sourceClassName)) {
            String enclosingClassName = ClassDumper.enclosingClassName(targetClassName);
            if (enclosingClassName != null) {
                JavaClass enclosingJavaClass = this.classDumper.loadJavaClass(enclosingClassName);
                return this.isClassAccessibleFrom(enclosingJavaClass, sourceClassName);
            }
            return true;
        }
        return false;
    }

    private Optional<SymbolProblem> findParentSymbolProblem(String baseClassName) {
        ArrayDeque<String> queue = new ArrayDeque<String>();
        queue.add(baseClassName);
        while (!queue.isEmpty()) {
            String className = (String)queue.remove();
            if (Object.class.getName().equals(className)) continue;
            String potentiallyMissingClassName = className;
            try {
                JavaClass baseClass = this.classDumper.loadJavaClass(className);
                queue.add(baseClass.getSuperclassName());
                String[] stringArray = baseClass.getInterfaceNames();
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String interfaceName;
                    potentiallyMissingClassName = interfaceName = stringArray[i];
                    JavaClass interfaceClass = this.classDumper.loadJavaClass(interfaceName);
                    queue.addAll(Arrays.asList(interfaceClass.getInterfaceNames()));
                }
            }
            catch (ClassNotFoundException ex) {
                SymbolProblem problem = new SymbolProblem(new ClassSymbol(potentiallyMissingClassName), ErrorType.SYMBOL_NOT_FOUND, null);
                return Optional.of(problem);
            }
        }
        return Optional.empty();
    }

    private ImmutableList<SymbolProblem> findAbstractParentProblems(ClassFile classFile, SuperClassSymbol superClassSymbol) {
        ImmutableList.Builder builder = ImmutableList.builder();
        String superClassName = superClassSymbol.getClassName();
        if (this.classDumper.isSystemClass(superClassName)) {
            return ImmutableList.of();
        }
        try {
            String className = classFile.getClassName();
            JavaClass implementingClass = this.classDumper.loadJavaClass(className);
            if (implementingClass.isAbstract()) {
                return ImmutableList.of();
            }
            JavaClass superClass = this.classDumper.loadJavaClass(superClassName);
            if (!superClass.isAbstract()) {
                return ImmutableList.of();
            }
            JavaClass abstractClass = superClass;
            HashSet<Method> implementedMethods = new HashSet<Method>();
            implementedMethods.addAll((Collection<Method>)ImmutableList.copyOf((Object[])implementingClass.getMethods()));
            while (abstractClass.isAbstract()) {
                for (Method abstractMethod : abstractClass.getMethods()) {
                    if (!abstractMethod.isAbstract()) {
                        implementedMethods.add(abstractMethod);
                        continue;
                    }
                    if (implementedMethods.contains(abstractMethod)) continue;
                    String unimplementedMethodName = abstractMethod.getName();
                    String unimplementedMethodDescriptor = abstractMethod.getSignature();
                    MethodSymbol missingMethodOnClass = new MethodSymbol(className, unimplementedMethodName, unimplementedMethodDescriptor, false);
                    builder.add((Object)new SymbolProblem(missingMethodOnClass, ErrorType.ABSTRACT_METHOD, classFile));
                }
                abstractClass = abstractClass.getSuperClass();
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return builder.build();
    }
}

