/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.opensource.classpath;

import com.google.cloud.tools.opensource.classpath.ClassPathBuilder;
import com.google.cloud.tools.opensource.dependencies.RepositoryUtility;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.eclipse.aether.RepositoryException;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;

final class LinkageCheckerArguments {
    private static final Options options = LinkageCheckerArguments.configureOptions();
    private static final HelpFormatter helpFormatter = new HelpFormatter();
    private final CommandLine commandLine;
    private ImmutableList<Path> cachedInputClasspath;
    private ImmutableList<Artifact> cachedArtifacts;
    private final ImmutableList<String> extraMavenRepositoryUrls;
    private final boolean addMavenCentral;
    private final boolean reportOnlyReachable;

    private LinkageCheckerArguments(CommandLine commandLine) {
        this.commandLine = (CommandLine)Preconditions.checkNotNull((Object)commandLine);
        this.extraMavenRepositoryUrls = commandLine.hasOption("m") ? ImmutableList.copyOf((Object[])commandLine.getOptionValues("m")) : ImmutableList.of();
        this.extraMavenRepositoryUrls.forEach(RepositoryUtility::mavenRepositoryFromUrl);
        this.addMavenCentral = !commandLine.hasOption("nm");
        this.reportOnlyReachable = commandLine.hasOption("-r");
    }

    static LinkageCheckerArguments readCommandLine(String ... arguments) throws ParseException {
        DefaultParser parser = new DefaultParser();
        try {
            return new LinkageCheckerArguments(parser.parse(options, arguments));
        }
        catch (IllegalArgumentException ex) {
            throw new ParseException("Invalid URL syntax in Maven repository URL");
        }
        catch (ParseException ex) {
            helpFormatter.printHelp("LinkageChecker", options);
            throw ex;
        }
    }

    private static Options configureOptions() {
        Options options = new Options();
        OptionGroup inputGroup = new OptionGroup();
        inputGroup.setRequired(true);
        Option bomOption = Option.builder((String)"b").longOpt("bom").hasArg().desc("BOM to generate a class path, specified by its Maven coordinates").build();
        inputGroup.addOption(bomOption);
        Option artifactOption = Option.builder((String)"a").longOpt("artifacts").hasArgs().valueSeparator(',').desc("Maven coordinates for Maven artifacts (separated by ',') to generate a class path").build();
        inputGroup.addOption(artifactOption);
        Option jarOption = Option.builder((String)"j").longOpt("jars").hasArgs().valueSeparator(',').desc("Jar files (separated by ',') to generate a class path").build();
        inputGroup.addOption(jarOption);
        Option repositoryOption = Option.builder((String)"m").longOpt("maven-repositories").hasArgs().valueSeparator(',').desc("Maven repository URLs to search for dependencies. The repositories are added to a repository list in order before the default Maven Central (http://repo1.maven.org/maven2/).").build();
        options.addOption(repositoryOption);
        Option noMavenCentralOption = Option.builder((String)"nm").longOpt("no-maven-central").hasArg(false).desc("Do not search Maven Central in addition to the repositories specified by -m. Useful when Maven Central is inaccessible.").build();
        options.addOption(noMavenCentralOption);
        Option reportOnlyReachable = Option.builder((String)"r").longOpt("report-only-reachable").hasArg(false).desc("Report only reachable linkage errors from the classes in the specified BOM or Maven artifacts").build();
        options.addOption(reportOnlyReachable);
        options.addOptionGroup(inputGroup);
        return options;
    }

    ImmutableList<Artifact> getArtifacts() throws RepositoryException {
        if (this.cachedArtifacts != null) {
            return this.cachedArtifacts;
        }
        if (this.commandLine.hasOption("b")) {
            String bomCoordinates = this.commandLine.getOptionValue("b");
            this.cachedArtifacts = RepositoryUtility.readBom(bomCoordinates).getManagedDependencies();
            return this.cachedArtifacts;
        }
        if (this.commandLine.hasOption("a")) {
            String[] mavenCoordinatesOption = this.commandLine.getOptionValues("a");
            this.cachedArtifacts = (ImmutableList)Arrays.stream(mavenCoordinatesOption).map(DefaultArtifact::new).collect(ImmutableList.toImmutableList());
            return this.cachedArtifacts;
        }
        throw new IllegalArgumentException("The arguments must have option 'a' or 'b' to list Maven artifacts");
    }

    ImmutableList<Path> getInputClasspath() throws RepositoryException {
        if (this.cachedInputClasspath != null) {
            return this.cachedInputClasspath;
        }
        if (this.commandLine.hasOption("b") || this.commandLine.hasOption("a")) {
            ImmutableList<Artifact> artifacts = this.getArtifacts();
            this.cachedInputClasspath = ClassPathBuilder.artifactsToClasspath(artifacts);
        } else {
            String[] jarFiles = this.commandLine.getOptionValues("j");
            this.cachedInputClasspath = (ImmutableList)Arrays.stream(jarFiles).map(name -> Paths.get(name, new String[0]).toAbsolutePath()).collect(ImmutableList.toImmutableList());
        }
        return this.cachedInputClasspath;
    }

    ImmutableSet<Path> getEntryPointJars() throws RepositoryException {
        if (this.commandLine.hasOption("a") || this.commandLine.hasOption('b')) {
            int artifactCount = this.getArtifacts().size();
            return ImmutableSet.copyOf((Collection)this.getInputClasspath().subList(0, artifactCount));
        }
        return ImmutableSet.copyOf(this.getInputClasspath());
    }

    ImmutableList<String> getExtraMavenRepositoryUrls() {
        return this.extraMavenRepositoryUrls;
    }

    boolean getAddMavenCentral() {
        return this.addMavenCentral;
    }

    boolean getReportOnlyReachable() {
        return this.reportOnlyReachable;
    }
}

