/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.opensource.classpath;

import com.google.cloud.tools.opensource.classpath.ClassReferenceGraph;
import com.google.cloud.tools.opensource.classpath.LinkageChecker;
import com.google.cloud.tools.opensource.classpath.LinkageCheckerArguments;
import com.google.cloud.tools.opensource.classpath.SymbolProblem;
import com.google.cloud.tools.opensource.dependencies.RepositoryUtility;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.io.IOException;
import org.apache.commons.cli.ParseException;
import org.eclipse.aether.RepositoryException;

class LinkageCheckerMain {
    LinkageCheckerMain() {
    }

    public static void main(String[] arguments) throws IOException, RepositoryException, ParseException {
        LinkageCheckerArguments linkageCheckerArguments = LinkageCheckerArguments.readCommandLine(arguments);
        RepositoryUtility.setRepositories(linkageCheckerArguments.getExtraMavenRepositoryUrls(), linkageCheckerArguments.getAddMavenCentral());
        LinkageChecker linkageChecker = LinkageChecker.create(linkageCheckerArguments.getInputClasspath(), linkageCheckerArguments.getEntryPointJars());
        ImmutableSetMultimap symbolProblems = linkageChecker.findSymbolProblems();
        if (linkageCheckerArguments.getReportOnlyReachable()) {
            ClassReferenceGraph graph = linkageChecker.getClassReferenceGraph();
            symbolProblems = ImmutableSetMultimap.copyOf((Multimap)Multimaps.filterValues(symbolProblems, classFile -> graph.isReachable(classFile.getClassName())));
        }
        System.out.println(SymbolProblem.formatSymbolProblems(symbolProblems));
    }
}

