/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.opensource.classpath;

import com.google.cloud.tools.opensource.classpath.Symbol;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.apache.bcel.classfile.Utility;

public final class MethodSymbol
extends Symbol {
    private final String name;
    private final String descriptor;
    private final boolean isInterfaceMethod;

    public MethodSymbol(String className, String name, String descriptor, boolean isInterfaceMethod) {
        super(className);
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.descriptor = (String)Preconditions.checkNotNull((Object)descriptor);
        this.isInterfaceMethod = isInterfaceMethod;
    }

    String getName() {
        return this.name;
    }

    String getDescriptor() {
        return this.descriptor;
    }

    boolean isInterfaceMethod() {
        return this.isInterfaceMethod;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        if (!super.equals(other)) {
            return false;
        }
        MethodSymbol that = (MethodSymbol)other;
        return this.isInterfaceMethod == that.isInterfaceMethod && this.name.equals(that.name) && this.descriptor.equals(that.descriptor);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.name, this.descriptor, this.isInterfaceMethod);
    }

    @Override
    public String toString() {
        String signaturePlusReturnType = Utility.methodSignatureToString((String)this.descriptor, (String)this.name, (String)"");
        String signature = signaturePlusReturnType.substring(signaturePlusReturnType.indexOf(32) + 1);
        return (this.isInterfaceMethod ? "Interface " : "") + this.getClassName() + "'s method " + signature;
    }
}

