/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.opensource.classpath;

import com.google.cloud.tools.opensource.classpath.ClassFile;
import com.google.cloud.tools.opensource.classpath.ClassSymbol;
import com.google.cloud.tools.opensource.classpath.ErrorType;
import com.google.cloud.tools.opensource.classpath.SuperClassSymbol;
import com.google.cloud.tools.opensource.classpath.Symbol;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSetMultimap;
import java.util.Objects;
import javax.annotation.Nullable;

public final class SymbolProblem {
    private final ErrorType errorType;
    private final Symbol symbol;
    private final ClassFile containingClass;

    public SymbolProblem(Symbol symbol, ErrorType errorType, @Nullable ClassFile containingClass) {
        Preconditions.checkNotNull((Object)symbol);
        this.symbol = symbol instanceof SuperClassSymbol ? new ClassSymbol(symbol.getClassName()) : symbol;
        this.errorType = (ErrorType)((Object)Preconditions.checkNotNull((Object)((Object)errorType)));
        this.containingClass = containingClass;
    }

    ErrorType getErrorType() {
        return this.errorType;
    }

    Symbol getSymbol() {
        return this.symbol;
    }

    @Nullable
    public ClassFile getContainingClass() {
        return this.containingClass;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        SymbolProblem that = (SymbolProblem)other;
        return this.errorType == that.errorType && this.symbol.equals(that.symbol) && Objects.equals(this.containingClass, that.containingClass);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.errorType, this.symbol, this.containingClass});
    }

    public final String toString() {
        String jarInfo = this.containingClass != null ? String.format("(%s) ", this.containingClass.getJar().getFileName()) : "";
        return jarInfo + this.getErrorType().getMessage(this.symbol.toString());
    }

    public static String formatSymbolProblems(ImmutableSetMultimap<SymbolProblem, ClassFile> symbolProblems) {
        StringBuilder output = new StringBuilder();
        symbolProblems.asMap().forEach((problem, classFiles) -> {
            int referenceCount = classFiles.size();
            output.append(String.format("%s;\n  referenced by %d class file%s\n", problem, referenceCount, referenceCount > 1 ? "s" : ""));
            classFiles.forEach(classFile -> {
                output.append("    " + classFile.getClassName());
                output.append(" (" + classFile.getJar().getFileName() + ")\n");
            });
        });
        return output.toString();
    }
}

