/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.opensource.classpath;

import com.google.cloud.tools.opensource.classpath.ClassFile;
import com.google.cloud.tools.opensource.classpath.ClassSymbol;
import com.google.cloud.tools.opensource.classpath.FieldSymbol;
import com.google.cloud.tools.opensource.classpath.MethodSymbol;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import java.util.Objects;

class SymbolReferenceMaps {
    private final ImmutableSetMultimap<ClassFile, ClassSymbol> classToClassSymbols;
    private final ImmutableSetMultimap<ClassFile, MethodSymbol> classToMethodSymbols;
    private final ImmutableSetMultimap<ClassFile, FieldSymbol> classToFieldSymbols;

    ImmutableSetMultimap<ClassFile, ClassSymbol> getClassToClassSymbols() {
        return this.classToClassSymbols;
    }

    ImmutableSetMultimap<ClassFile, MethodSymbol> getClassToMethodSymbols() {
        return this.classToMethodSymbols;
    }

    ImmutableSetMultimap<ClassFile, FieldSymbol> getClassToFieldSymbols() {
        return this.classToFieldSymbols;
    }

    @VisibleForTesting
    SymbolReferenceMaps(ImmutableSetMultimap<ClassFile, ClassSymbol> classToClassSymbols, ImmutableSetMultimap<ClassFile, MethodSymbol> classToMethodSymbols, ImmutableSetMultimap<ClassFile, FieldSymbol> classToFieldSymbols) {
        this.classToClassSymbols = (ImmutableSetMultimap)Preconditions.checkNotNull(classToClassSymbols);
        this.classToMethodSymbols = (ImmutableSetMultimap)Preconditions.checkNotNull(classToMethodSymbols);
        this.classToFieldSymbols = (ImmutableSetMultimap)Preconditions.checkNotNull(classToFieldSymbols);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        SymbolReferenceMaps that = (SymbolReferenceMaps)other;
        return this.classToClassSymbols.equals(that.classToClassSymbols) && this.classToMethodSymbols.equals(that.classToMethodSymbols) && this.classToFieldSymbols.equals(that.classToFieldSymbols);
    }

    public int hashCode() {
        return Objects.hash(this.classToClassSymbols, this.classToMethodSymbols, this.classToFieldSymbols);
    }

    static class Builder {
        private final ImmutableSetMultimap.Builder<ClassFile, ClassSymbol> classToClassSymbols = ImmutableSetMultimap.builder();
        private final ImmutableSetMultimap.Builder<ClassFile, MethodSymbol> classToMethodSymbols = ImmutableSetMultimap.builder();
        private final ImmutableSetMultimap.Builder<ClassFile, FieldSymbol> classToFieldSymbols = ImmutableSetMultimap.builder();

        Builder() {
        }

        Builder addClassReference(ClassFile source, ClassSymbol symbol) {
            this.classToClassSymbols.put((Object)source, (Object)symbol);
            return this;
        }

        Builder addMethodReference(ClassFile source, MethodSymbol symbol) {
            this.classToMethodSymbols.put((Object)source, (Object)symbol);
            return this;
        }

        Builder addFieldReference(ClassFile source, FieldSymbol symbol) {
            this.classToFieldSymbols.put((Object)source, (Object)symbol);
            return this;
        }

        SymbolReferenceMaps build() {
            return new SymbolReferenceMaps((ImmutableSetMultimap<ClassFile, ClassSymbol>)this.classToClassSymbols.build(), (ImmutableSetMultimap<ClassFile, MethodSymbol>)this.classToMethodSymbols.build(), (ImmutableSetMultimap<ClassFile, FieldSymbol>)this.classToFieldSymbols.build());
        }

        Builder addAll(Builder other) {
            this.classToClassSymbols.putAll((Multimap)other.classToClassSymbols.build());
            this.classToMethodSymbols.putAll((Multimap)other.classToMethodSymbols.build());
            this.classToFieldSymbols.putAll((Multimap)other.classToFieldSymbols.build());
            return this;
        }
    }
}

