/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.opensource.dependencies;

import com.google.cloud.tools.opensource.dependencies.ExceptionAndPath;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.eclipse.aether.RepositoryException;

public class AggregatedRepositoryException
extends RepositoryException {
    private final ImmutableList<ExceptionAndPath> underlyingFailures;

    AggregatedRepositoryException(List<ExceptionAndPath> failures) {
        super("There were failure(s) in dependency resolution");
        this.underlyingFailures = ImmutableList.copyOf(failures);
    }

    public String getMessage() {
        StringBuilder builder = new StringBuilder(super.getMessage());
        builder.append("\n");
        for (ExceptionAndPath exceptionAndPath : this.underlyingFailures) {
            builder.append(Joiner.on((String)" / ").join(exceptionAndPath.getPath()));
            builder.append(": ");
            builder.append((Object)exceptionAndPath.getException());
            builder.append("\n");
        }
        return builder.toString();
    }
}

