/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.opensource.dependencies;

import com.google.cloud.tools.opensource.dependencies.Artifacts;
import com.google.cloud.tools.opensource.dependencies.DependencyPath;
import com.google.cloud.tools.opensource.dependencies.Update;
import com.google.cloud.tools.opensource.dependencies.VersionComparator;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.TreeMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Set;
import org.eclipse.aether.artifact.Artifact;

public class DependencyGraph {
    private final List<DependencyPath> graph = new ArrayList<DependencyPath>();
    private final TreeMultimap<String, String> versions = TreeMultimap.create(Comparator.naturalOrder(), (Comparator)new VersionComparator());
    private SetMultimap<String, DependencyPath> paths = HashMultimap.create();

    @VisibleForTesting
    public DependencyGraph() {
    }

    void addPath(DependencyPath path) {
        this.graph.add(path);
        Artifact leaf = path.getLeaf();
        String coordinates = Artifacts.toCoordinates(leaf);
        this.versions.put((Object)Artifacts.makeKey(leaf), (Object)leaf.getVersion());
        this.paths.put((Object)coordinates, (Object)path);
    }

    List<DependencyPath> findConflicts() {
        ArrayList<DependencyPath> result = new ArrayList<DependencyPath>();
        for (String coordinates : this.versions.keySet()) {
            NavigableSet artifactVersions = this.versions.get((Object)coordinates);
            if (artifactVersions.size() <= 1) continue;
            for (String conflictingVersion : artifactVersions) {
                result.addAll(this.paths.get((Object)(coordinates + ":" + conflictingVersion)));
            }
        }
        return result;
    }

    public List<DependencyPath> list() {
        return new ArrayList<DependencyPath>(this.graph);
    }

    public Set<DependencyPath> getPaths(String coordinates) {
        return this.paths.get((Object)coordinates);
    }

    public List<Update> findUpdates() {
        List<DependencyPath> paths = this.findConflicts();
        LinkedHashSet<Update> upgrades = new LinkedHashSet<Update>();
        for (DependencyPath path : paths) {
            Artifact leaf = path.getLeaf();
            String key = Artifacts.makeKey(leaf);
            String highestVersion = (String)this.versions.get((Object)key).last();
            if (leaf.getVersion().equals(highestVersion)) continue;
            Artifact parent = path.get(path.size() - 2);
            String lastParentVersion = (String)this.versions.get((Object)Artifacts.makeKey(parent)).last();
            if (!parent.getVersion().equals(lastParentVersion)) continue;
            Artifact updated = leaf.setVersion(highestVersion);
            Update update = Update.builder().setParent(parent).setFrom(leaf).setTo(updated).build();
            upgrades.add(update);
        }
        return new ArrayList<Update>(upgrades);
    }

    public Map<String, String> getHighestVersionMap() {
        NavigableMap input = this.versions.asMap();
        HashMap<String, String> output = new HashMap<String, String>();
        VersionComparator comparator = new VersionComparator();
        for (Map.Entry entry : input.entrySet()) {
            String highestVersion = Collections.max((Collection)entry.getValue(), comparator);
            output.put((String)entry.getKey(), highestVersion);
        }
        return output;
    }
}

