/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.opensource.dependencies;

import com.google.cloud.tools.opensource.dependencies.AggregatedRepositoryException;
import com.google.cloud.tools.opensource.dependencies.Artifacts;
import com.google.cloud.tools.opensource.dependencies.DependencyGraph;
import com.google.cloud.tools.opensource.dependencies.DependencyPath;
import com.google.cloud.tools.opensource.dependencies.ExceptionAndPath;
import com.google.cloud.tools.opensource.dependencies.RepositoryUtility;
import com.google.common.base.CharMatcher;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import java.util.logging.Logger;
import org.eclipse.aether.RepositoryException;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.CollectResult;
import org.eclipse.aether.collection.DependencyCollectionException;
import org.eclipse.aether.graph.DefaultDependencyNode;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;

public class DependencyGraphBuilder {
    private static final Logger logger = Logger.getLogger(DependencyGraphBuilder.class.getName());
    private static final RepositorySystem system = RepositoryUtility.newRepositorySystem();
    private static final CharMatcher LOWER_ALPHA_NUMERIC = CharMatcher.inRange((char)'a', (char)'z').or(CharMatcher.inRange((char)'0', (char)'9'));
    private static final Map<Dependency, DependencyNode> cacheWithProvidedScope;
    private static final Map<Dependency, DependencyNode> cacheWithoutProvidedScope;

    public static ImmutableMap<String, String> detectOsProperties() {
        String osDetectedName = DependencyGraphBuilder.osDetectedName();
        String osDetectedArch = DependencyGraphBuilder.osDetectedArch();
        return ImmutableMap.of((Object)"os.detected.name", (Object)osDetectedName, (Object)"os.detected.arch", (Object)osDetectedArch, (Object)"os.detected.classifier", (Object)(osDetectedName + "-" + osDetectedArch));
    }

    private static String osDetectedName() {
        String osNameNormalized = LOWER_ALPHA_NUMERIC.retainFrom((CharSequence)System.getProperty("os.name").toLowerCase(Locale.ENGLISH));
        if (osNameNormalized.startsWith("macosx") || osNameNormalized.startsWith("osx")) {
            return "osx";
        }
        if (osNameNormalized.startsWith("windows")) {
            return "windows";
        }
        return "linux";
    }

    private static String osDetectedArch() {
        String osArchNormalized;
        switch (osArchNormalized = LOWER_ALPHA_NUMERIC.retainFrom((CharSequence)System.getProperty("os.arch").toLowerCase(Locale.ENGLISH))) {
            case "x8664": 
            case "amd64": 
            case "ia32e": 
            case "em64t": 
            case "x64": {
                return "x86_64";
            }
        }
        return "x86_32";
    }

    private static DependencyNode resolveCompileTimeDependencies(DependencyNode rootDependencyArtifact) throws DependencyCollectionException, DependencyResolutionException {
        return DependencyGraphBuilder.resolveCompileTimeDependencies(rootDependencyArtifact, false);
    }

    private static DependencyNode resolveCompileTimeDependencies(DependencyNode rootDependencyArtifact, boolean includeProvidedScope) throws DependencyCollectionException, DependencyResolutionException {
        return DependencyGraphBuilder.resolveCompileTimeDependencies((List<DependencyNode>)ImmutableList.of((Object)rootDependencyArtifact), includeProvidedScope);
    }

    private static DependencyNode resolveCompileTimeDependencies(List<DependencyNode> dependencyNodes, boolean includeProvidedScope) throws DependencyCollectionException, DependencyResolutionException {
        Dependency cacheKey;
        ImmutableList.Builder dependenciesBuilder = ImmutableList.builder();
        for (DependencyNode dependencyNode : dependencyNodes) {
            Dependency dependency = dependencyNode.getDependency();
            if (dependency == null) {
                dependenciesBuilder.add((Object)new Dependency(dependencyNode.getArtifact(), "compile"));
                continue;
            }
            dependenciesBuilder.add((Object)dependency.setScope("compile"));
        }
        ImmutableList dependencyList = dependenciesBuilder.build();
        Map<Dependency, DependencyNode> cache = includeProvidedScope ? cacheWithProvidedScope : cacheWithoutProvidedScope;
        Dependency dependency = cacheKey = dependencyList.size() == 1 ? (Dependency)dependencyList.get(0) : null;
        if (cacheKey != null && cache.containsKey(cacheKey)) {
            return cache.get(cacheKey);
        }
        RepositorySystemSession session = includeProvidedScope ? RepositoryUtility.newSessionWithProvidedScope(system) : RepositoryUtility.newSession(system);
        CollectRequest collectRequest = new CollectRequest();
        if (dependencyList.size() == 1) {
            collectRequest.setRoot((Dependency)dependencyList.get(0));
        } else {
            collectRequest.setDependencies((List)dependencyList);
        }
        RepositoryUtility.addRepositoriesToRequest(collectRequest);
        CollectResult collectResult = system.collectDependencies(session, collectRequest);
        DependencyNode node = collectResult.getRoot();
        DependencyRequest dependencyRequest = new DependencyRequest();
        dependencyRequest.setRoot(node);
        dependencyRequest.setCollectRequest(collectRequest);
        system.resolveDependencies(session, dependencyRequest);
        if (cacheKey != null) {
            cache.put(cacheKey, node);
        }
        return node;
    }

    public static List<Artifact> getDirectDependencies(Artifact artifact) throws RepositoryException {
        ArrayList<Artifact> result = new ArrayList<Artifact>();
        DependencyNode node = DependencyGraphBuilder.resolveCompileTimeDependencies((DependencyNode)new DefaultDependencyNode(artifact));
        for (DependencyNode child : node.getChildren()) {
            result.add(child.getArtifact());
        }
        return result;
    }

    public static DependencyGraph getStaticLinkageCheckDependencyGraph(List<Artifact> artifacts) throws RepositoryException {
        ImmutableList dependencyNodes = (ImmutableList)artifacts.stream().map(DefaultDependencyNode::new).collect(ImmutableList.toImmutableList());
        DependencyNode node = DependencyGraphBuilder.resolveCompileTimeDependencies((List<DependencyNode>)dependencyNodes, true);
        return DependencyGraphBuilder.levelOrder(node, GraphTraversalOption.FULL_DEPENDENCY_WITH_PROVIDED);
    }

    public static DependencyGraph getCompleteDependencies(Artifact artifact) throws RepositoryException {
        DependencyNode node = DependencyGraphBuilder.resolveCompileTimeDependencies((DependencyNode)new DefaultDependencyNode(artifact));
        return DependencyGraphBuilder.levelOrder(node, GraphTraversalOption.FULL_DEPENDENCY);
    }

    public static DependencyGraph getTransitiveDependencies(Artifact artifact) throws RepositoryException {
        DependencyNode node = DependencyGraphBuilder.resolveCompileTimeDependencies((DependencyNode)new DefaultDependencyNode(artifact));
        return DependencyGraphBuilder.levelOrder(node);
    }

    private static DependencyGraph levelOrder(DependencyNode node) throws AggregatedRepositoryException {
        return DependencyGraphBuilder.levelOrder(node, GraphTraversalOption.NONE);
    }

    private static DependencyGraph levelOrder(DependencyNode firstNode, GraphTraversalOption graphTraversalOption) throws AggregatedRepositoryException {
        DependencyGraph graph = new DependencyGraph();
        boolean resolveFullDependency = graphTraversalOption.resolveFullDependencies();
        ArrayDeque<LevelOrderQueueItem> queue = new ArrayDeque<LevelOrderQueueItem>();
        queue.add(new LevelOrderQueueItem(firstNode, new Stack<DependencyNode>()));
        ArrayList<ExceptionAndPath> resolutionFailures = new ArrayList<ExceptionAndPath>();
        while (!queue.isEmpty()) {
            Stack<DependencyNode> parentNodes;
            DependencyNode dependencyNode;
            block9: {
                LevelOrderQueueItem item = (LevelOrderQueueItem)queue.poll();
                dependencyNode = item.dependencyNode;
                DependencyPath path = new DependencyPath();
                parentNodes = item.parentNodes;
                parentNodes.forEach(parentNode -> path.add(parentNode.getArtifact(), parentNode.getDependency().getScope(), parentNode.getDependency().getOptional()));
                Artifact artifact = dependencyNode.getArtifact();
                if (artifact != null) {
                    String groupIdAndArtifactId = Artifacts.makeKey(artifact);
                    boolean parentHasSameKey = parentNodes.stream().map(node -> Artifacts.makeKey(node.getArtifact())).anyMatch(key -> key.equals(groupIdAndArtifactId));
                    if (parentHasSameKey) continue;
                    path.add(artifact, dependencyNode.getDependency().getScope(), dependencyNode.getDependency().getOptional());
                    parentNodes.push(dependencyNode);
                    graph.addPath(path);
                    if (resolveFullDependency && !"system".equals(dependencyNode.getDependency().getScope())) {
                        try {
                            boolean includeProvidedScope = graphTraversalOption == GraphTraversalOption.FULL_DEPENDENCY_WITH_PROVIDED;
                            dependencyNode = DependencyGraphBuilder.resolveCompileTimeDependencies(dependencyNode, includeProvidedScope);
                        }
                        catch (DependencyResolutionException resolutionException) {
                            for (ArtifactResult artifactResult : resolutionException.getResult().getArtifactResults()) {
                                DependencyNode failedDependencyNode;
                                ExceptionAndPath failure;
                                if (artifactResult.getExceptions().isEmpty() || !DependencyGraphBuilder.requiredDependency((failure = ExceptionAndPath.create(parentNodes, failedDependencyNode = artifactResult.getRequest().getDependencyNode(), (RepositoryException)resolutionException)).getPath())) continue;
                                resolutionFailures.add(failure);
                            }
                        }
                        catch (DependencyCollectionException collectionException) {
                            DependencyNode failedDependencyNode = collectionException.getResult().getRoot();
                            ExceptionAndPath failure = ExceptionAndPath.create(parentNodes, failedDependencyNode, (RepositoryException)collectionException);
                            if (!DependencyGraphBuilder.requiredDependency(failure.getPath())) break block9;
                            resolutionFailures.add(failure);
                        }
                    }
                }
            }
            for (DependencyNode child : dependencyNode.getChildren()) {
                Stack clone = (Stack)parentNodes.clone();
                queue.add(new LevelOrderQueueItem(child, clone));
            }
        }
        if (!resolutionFailures.isEmpty()) {
            throw new AggregatedRepositoryException(resolutionFailures);
        }
        return graph;
    }

    public static boolean requiredDependency(List<DependencyNode> dependencyPath) {
        boolean hasOptional = dependencyPath.stream().filter(node -> node.getDependency() != null).anyMatch(node -> node.getDependency().isOptional());
        if (!hasOptional) {
            return true;
        }
        boolean hasProvided = dependencyPath.stream().filter(node -> node.getDependency() != null).anyMatch(node -> "provided".equals(node.getDependency().getScope()));
        return !hasProvided;
    }

    static {
        DependencyGraphBuilder.detectOsProperties().forEach(System::setProperty);
        cacheWithProvidedScope = new HashMap<Dependency, DependencyNode>();
        cacheWithoutProvidedScope = new HashMap<Dependency, DependencyNode>();
    }

    private static enum GraphTraversalOption {
        NONE,
        FULL_DEPENDENCY,
        FULL_DEPENDENCY_WITH_PROVIDED;


        private boolean resolveFullDependencies() {
            return this == FULL_DEPENDENCY || this == FULL_DEPENDENCY_WITH_PROVIDED;
        }
    }

    private static final class LevelOrderQueueItem {
        final DependencyNode dependencyNode;
        final Stack<DependencyNode> parentNodes;

        LevelOrderQueueItem(DependencyNode dependencyNode, Stack<DependencyNode> parentNodes) {
            this.dependencyNode = dependencyNode;
            this.parentNodes = parentNodes;
        }
    }
}

