/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.opensource.dependencies;

import com.google.cloud.tools.opensource.dependencies.Artifacts;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.aether.artifact.Artifact;

public final class DependencyPath {
    private List<Node> path = new ArrayList<Node>();

    @VisibleForTesting
    public void add(Artifact artifact, String scope, Boolean optional) {
        this.path.add(new Node(artifact, scope, optional));
    }

    public int size() {
        return this.path.size();
    }

    public Artifact getLeaf() {
        return this.path.get(this.size() - 1).getArtifact();
    }

    public ImmutableList<Artifact> getArtifacts() {
        return (ImmutableList)this.path.stream().map(rec$ -> ((Node)rec$).getArtifact()).collect(ImmutableList.toImmutableList());
    }

    public Artifact get(int i) {
        return this.path.get(i).getArtifact();
    }

    public String toString() {
        return Joiner.on((String)" / ").join(this.path);
    }

    public boolean equals(Object o) {
        if (!(o instanceof DependencyPath)) {
            return false;
        }
        DependencyPath other = (DependencyPath)o;
        if (other.path.size() != this.path.size()) {
            return false;
        }
        for (int i = 0; i < this.path.size(); ++i) {
            Node thisNode = this.path.get(i);
            Node otherNode = other.path.get(i);
            if (!DependencyPath.artifactsEqual(thisNode.getArtifact(), otherNode.getArtifact())) {
                return false;
            }
            if (!thisNode.getScope().equals(otherNode.getScope())) {
                return false;
            }
            if (thisNode.isOptional() == otherNode.isOptional()) continue;
            return false;
        }
        return true;
    }

    private static boolean artifactsEqual(Artifact artifact1, Artifact artifact2) {
        return artifact1.getArtifactId().equals(artifact2.getArtifactId()) && artifact1.getGroupId().equals(artifact2.getGroupId()) && artifact1.getVersion().equals(artifact2.getVersion());
    }

    public int hashCode() {
        int hashCode = 31;
        for (Node node : this.path) {
            Artifact artifact = node.getArtifact();
            hashCode = 37 * hashCode + Objects.hash(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), node.scope, node.optional);
        }
        return hashCode;
    }

    private static class Node {
        private Artifact artifact;
        private String scope;
        private boolean optional;

        private Node(Artifact artifact, String scope, boolean optional) {
            this.artifact = (Artifact)Preconditions.checkNotNull((Object)artifact);
            this.scope = (String)Preconditions.checkNotNull((Object)scope);
            this.optional = optional;
        }

        private Artifact getArtifact() {
            return this.artifact;
        }

        private String getScope() {
            return this.scope;
        }

        private boolean isOptional() {
            return this.optional;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Node)) {
                return false;
            }
            Node that = (Node)other;
            return this.optional == that.optional && this.artifact.equals(that.artifact) && this.scope.equals(that.scope);
        }

        public int hashCode() {
            return Objects.hash(this.artifact, this.scope, this.optional);
        }

        public String toString() {
            String scopeAndOptional = this.scope + (this.optional ? ", optional" : "");
            String coordinates = Artifacts.toCoordinates(this.artifact);
            return String.format("%s (%s)", coordinates, scopeAndOptional);
        }
    }
}

