/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.opensource.dependencies;

import com.google.cloud.tools.opensource.dependencies.DependencyPath;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.Collection;
import java.util.List;
import org.eclipse.aether.artifact.Artifact;

public class DependencyTreeFormatter {
    static String formatDependencyPaths(List<DependencyPath> dependencyPaths) {
        StringBuilder stringBuilder = new StringBuilder();
        ListMultimap<DependencyPath, DependencyPath> tree = DependencyTreeFormatter.buildDependencyPathTree(dependencyPaths);
        DependencyTreeFormatter.formatDependencyPathTree(stringBuilder, tree, new DependencyPath());
        return stringBuilder.toString();
    }

    private static void formatDependencyPathTree(StringBuilder stringBuilder, ListMultimap<DependencyPath, DependencyPath> tree, DependencyPath currentNode) {
        String indentCharacter = "  ";
        int depth = currentNode.size();
        if (depth > 0) {
            stringBuilder.append(Strings.repeat((String)indentCharacter, (int)depth));
            stringBuilder.append(currentNode.getLeaf());
            stringBuilder.append("\n");
        }
        for (DependencyPath childPath : tree.get((Object)currentNode)) {
            DependencyTreeFormatter.formatDependencyPathTree(stringBuilder, tree, childPath);
        }
    }

    public static ListMultimap<DependencyPath, DependencyPath> buildDependencyPathTree(Collection<DependencyPath> dependencyPaths) {
        LinkedListMultimap tree = LinkedListMultimap.create();
        for (DependencyPath dependencyPath : dependencyPaths) {
            ImmutableList<Artifact> artifactPath = dependencyPath.getArtifacts();
            List parentArtifactPath = artifactPath.subList(0, artifactPath.size() - 1);
            DependencyPath parentDependencyPath = new DependencyPath();
            parentArtifactPath.forEach(parentArtifactPathNode -> parentDependencyPath.add((Artifact)parentArtifactPathNode, "compile", false));
            tree.put((Object)parentDependencyPath, (Object)dependencyPath);
        }
        return tree;
    }
}

