/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.opensource.dependencies;

import com.google.cloud.tools.opensource.dependencies.DependencyGraph;
import com.google.cloud.tools.opensource.dependencies.DependencyGraphBuilder;
import com.google.cloud.tools.opensource.dependencies.DependencyTreeFormatter;
import org.eclipse.aether.RepositoryException;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;

class DependencyTreePrinter {
    DependencyTreePrinter() {
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.err.println("Maven coordinates not provided. E.g., 'io.grpc:grpc-auth:1.19.0'");
            return;
        }
        for (String coordinates : args) {
            try {
                DependencyTreePrinter.printDependencyTree(coordinates);
            }
            catch (RepositoryException e) {
                System.err.println(coordinates + " : Failed to retrieve dependency information:" + e.getMessage());
            }
        }
    }

    private static void printDependencyTree(String coordinates) throws RepositoryException {
        DefaultArtifact rootArtifact = new DefaultArtifact(coordinates);
        DependencyGraph dependencyGraph = DependencyGraphBuilder.getCompleteDependencies((Artifact)rootArtifact);
        System.out.println("Dependencies for " + coordinates);
        System.out.println(DependencyTreeFormatter.formatDependencyPaths(dependencyGraph.list()));
    }
}

