/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.opensource.dependencies;

import com.google.cloud.tools.opensource.dependencies.DependencyGraphBuilder;
import java.util.List;
import org.eclipse.aether.RepositoryException;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;

class DirectReport {
    DirectReport() {
    }

    public static void main(String[] args) throws RepositoryException {
        if (args.length != 1 || !args[0].contains(":")) {
            System.err.println("Usage: java " + DirectReport.class.getCanonicalName() + " groupdId:artifactId:version");
            return;
        }
        System.out.println("Dependencies of " + args[0] + ":");
        System.out.println();
        DefaultArtifact input = new DefaultArtifact(args[0]);
        List<Artifact> dependencies = DependencyGraphBuilder.getDirectDependencies((Artifact)input);
        for (Artifact artifact : dependencies) {
            System.out.println("  <dependency>");
            System.out.println("    <groupId>" + artifact.getGroupId() + "</groupId>");
            System.out.println("    <artifactId>" + artifact.getArtifactId() + "</artifactId>");
            System.out.println("    <version>" + artifact.getVersion() + "</version>");
            System.out.println("  </dependency>");
        }
    }
}

