/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.opensource.dependencies;

import com.google.cloud.tools.opensource.dependencies.Bom;
import com.google.cloud.tools.opensource.dependencies.DependencyGraphBuilder;
import com.google.cloud.tools.opensource.dependencies.FilteringZipDependencySelector;
import com.google.cloud.tools.opensource.dependencies.MavenRepositoryException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.execution.DefaultMavenExecutionRequest;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.codehaus.plexus.ContainerConfiguration;
import org.codehaus.plexus.DefaultContainerConfiguration;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.PlexusContainerException;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.ArtifactTypeRegistry;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.DependencySelector;
import org.eclipse.aether.connector.basic.BasicRepositoryConnectorFactory;
import org.eclipse.aether.impl.DefaultServiceLocator;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactDescriptorException;
import org.eclipse.aether.resolution.ArtifactDescriptorRequest;
import org.eclipse.aether.resolution.ArtifactDescriptorResult;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.eclipse.aether.transport.file.FileTransporterFactory;
import org.eclipse.aether.transport.http.HttpTransporterFactory;
import org.eclipse.aether.util.graph.selector.AndDependencySelector;
import org.eclipse.aether.util.graph.selector.ExclusionDependencySelector;
import org.eclipse.aether.util.graph.selector.OptionalDependencySelector;
import org.eclipse.aether.util.graph.selector.ScopeDependencySelector;

public final class RepositoryUtility {
    private static final Logger logger = Logger.getLogger(RepositoryUtility.class.getName());
    public static final RemoteRepository CENTRAL = new RemoteRepository.Builder("central", "default", "https://repo1.maven.org/maven2/").build();
    private static ImmutableList<RemoteRepository> mavenRepositories = ImmutableList.of((Object)CENTRAL);
    private static final ImmutableSet<String> ALLOWED_REPOSITORY_URL_SCHEMES = ImmutableSet.of((Object)"file", (Object)"http", (Object)"https");
    private static final ImmutableSet<String> BOM_SKIP_ARTIFACT_IDS = ImmutableSet.of((Object)"google-cloud-logging-logback", (Object)"google-cloud-contrib");

    private RepositoryUtility() {
    }

    public static RepositorySystem newRepositorySystem() {
        DefaultServiceLocator locator = MavenRepositorySystemUtils.newServiceLocator();
        locator.addService(RepositoryConnectorFactory.class, BasicRepositoryConnectorFactory.class);
        locator.addService(TransporterFactory.class, FileTransporterFactory.class);
        locator.addService(TransporterFactory.class, HttpTransporterFactory.class);
        return (RepositorySystem)locator.getService(RepositorySystem.class);
    }

    private static DefaultRepositorySystemSession createDefaultRepositorySystemSession(RepositorySystem system) {
        DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();
        LocalRepository localRepository = new LocalRepository(RepositoryUtility.findLocalRepository().getAbsolutePath());
        session.setLocalRepositoryManager(system.newLocalRepositoryManager((RepositorySystemSession)session, localRepository));
        return session;
    }

    public static RepositorySystemSession newSession(RepositorySystem system) {
        DefaultRepositorySystemSession session = RepositoryUtility.createDefaultRepositorySystemSession(system);
        session.setReadOnly();
        return session;
    }

    static RepositorySystemSession newSessionWithProvidedScope(RepositorySystem system) {
        DefaultRepositorySystemSession session = RepositoryUtility.createDefaultRepositorySystemSession(system);
        AndDependencySelector dependencySelector = new AndDependencySelector(new DependencySelector[]{new ScopeDependencySelector(new String[]{"test"}), new OptionalDependencySelector(), new ExclusionDependencySelector(), new FilteringZipDependencySelector()});
        session.setDependencySelector((DependencySelector)dependencySelector);
        session.setReadOnly();
        return session;
    }

    private static File findLocalRepository() {
        Path home = Paths.get(System.getProperty("user.home"), new String[0]);
        Path localRepo = home.resolve(".m2").resolve("repository");
        if (Files.isDirectory(localRepo, new LinkOption[0])) {
            return localRepo.toFile();
        }
        File temporaryDirectory = com.google.common.io.Files.createTempDir();
        temporaryDirectory.deleteOnExit();
        return temporaryDirectory;
    }

    public static Bom readBom(Path pomFile) throws MavenRepositoryException {
        RepositorySystem system = RepositoryUtility.newRepositorySystem();
        RepositorySystemSession session = RepositoryUtility.newSession(system);
        MavenProject mavenProject = RepositoryUtility.createMavenProject(pomFile, session);
        String coordinates = mavenProject.getGroupId() + ":" + mavenProject.getArtifactId() + ":" + mavenProject.getVersion();
        DependencyManagement dependencyManagement = mavenProject.getDependencyManagement();
        List dependencies = dependencyManagement.getDependencies();
        ArtifactTypeRegistry registry = session.getArtifactTypeRegistry();
        ImmutableList artifacts = (ImmutableList)dependencies.stream().map(dependency -> RepositoryUtils.toDependency((Dependency)dependency, (ArtifactTypeRegistry)registry)).map(org.eclipse.aether.graph.Dependency::getArtifact).filter(artifact -> !RepositoryUtility.shouldSkipBomMember(artifact)).collect(ImmutableList.toImmutableList());
        Bom bom = new Bom(coordinates, (ImmutableList<Artifact>)artifacts);
        return bom;
    }

    private static MavenProject createMavenProject(Path pomFile, RepositorySystemSession session) throws MavenRepositoryException {
        ClassWorld classWorld = new ClassWorld("plexus.core", Thread.currentThread().getContextClassLoader());
        ContainerConfiguration containerConfiguration = new DefaultContainerConfiguration().setClassWorld(classWorld).setRealm(classWorld.getClassRealm("plexus.core")).setClassPathScanning("index").setAutoWiring(true).setJSR250Lifecycle(true).setName("linkage-checker");
        try {
            DefaultPlexusContainer container = new DefaultPlexusContainer(containerConfiguration);
            DefaultMavenExecutionRequest mavenExecutionRequest = new DefaultMavenExecutionRequest();
            ProjectBuildingRequest projectBuildingRequest = mavenExecutionRequest.getProjectBuildingRequest();
            projectBuildingRequest.setRepositorySession(session);
            Properties properties = new Properties();
            properties.putAll((Map<?, ?>)projectBuildingRequest.getSystemProperties());
            properties.putAll((Map<?, ?>)DependencyGraphBuilder.detectOsProperties());
            properties.putAll((Map<?, ?>)System.getProperties());
            projectBuildingRequest.setSystemProperties(properties);
            ProjectBuilder projectBuilder = (ProjectBuilder)container.lookup(ProjectBuilder.class);
            ProjectBuildingResult projectBuildingResult = projectBuilder.build(pomFile.toFile(), projectBuildingRequest);
            return projectBuildingResult.getProject();
        }
        catch (ProjectBuildingException | PlexusContainerException | ComponentLookupException ex) {
            throw new MavenRepositoryException((Exception)ex);
        }
    }

    public static Bom readBom(String coordinates) throws ArtifactDescriptorException {
        DefaultArtifact artifact = new DefaultArtifact(coordinates);
        RepositorySystem system = RepositoryUtility.newRepositorySystem();
        RepositorySystemSession session = RepositoryUtility.newSession(system);
        ArtifactDescriptorRequest request = new ArtifactDescriptorRequest();
        for (RemoteRepository repository : mavenRepositories) {
            request.addRepository(repository);
        }
        request.setArtifact((Artifact)artifact);
        ArtifactDescriptorResult resolved = system.readArtifactDescriptor(session, request);
        List exceptions = resolved.getExceptions();
        if (!exceptions.isEmpty()) {
            throw new ArtifactDescriptorException(resolved, ((Exception)exceptions.get(0)).getMessage());
        }
        ArrayList<Artifact> managedDependencies = new ArrayList<Artifact>();
        for (org.eclipse.aether.graph.Dependency dependency : resolved.getManagedDependencies()) {
            Artifact managed = dependency.getArtifact();
            if (RepositoryUtility.shouldSkipBomMember(managed)) continue;
            if (!managedDependencies.contains(managed)) {
                managedDependencies.add(managed);
                continue;
            }
            logger.severe("Duplicate dependency " + dependency);
        }
        Bom bom = new Bom(coordinates, (ImmutableList<Artifact>)ImmutableList.copyOf(managedDependencies));
        return bom;
    }

    public static boolean shouldSkipBomMember(Artifact artifact) {
        if ("testlib".equals(artifact.getClassifier())) {
            return true;
        }
        String type = artifact.getProperty("type", "jar");
        if ("test-jar".equals(type)) {
            return true;
        }
        return BOM_SKIP_ARTIFACT_IDS.contains((Object)artifact.getArtifactId());
    }

    public static void setRepositories(Iterable<String> mavenRepositoryUrls, boolean addMavenCentral) {
        ImmutableList.Builder repositoryListBuilder = ImmutableList.builder();
        for (String mavenRepositoryUrl : mavenRepositoryUrls) {
            RemoteRepository repository = RepositoryUtility.mavenRepositoryFromUrl(mavenRepositoryUrl);
            repositoryListBuilder.add((Object)repository);
        }
        if (addMavenCentral) {
            repositoryListBuilder.add((Object)CENTRAL);
        }
        mavenRepositories = repositoryListBuilder.build();
    }

    public static void addRepositoriesToRequest(CollectRequest collectRequest) {
        for (RemoteRepository repository : mavenRepositories) {
            collectRequest.addRepository(repository);
        }
    }

    public static RemoteRepository mavenRepositoryFromUrl(String mavenRepositoryUrl) {
        try {
            new URI((String)Preconditions.checkNotNull((Object)mavenRepositoryUrl));
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException("Invalid URL syntax: " + mavenRepositoryUrl);
        }
        RemoteRepository repository = new RemoteRepository.Builder(null, "default", mavenRepositoryUrl).build();
        Preconditions.checkArgument((boolean)ALLOWED_REPOSITORY_URL_SCHEMES.contains((Object)repository.getProtocol()), (String)"Scheme: '%s' is not in %s", (Object)repository.getProtocol(), ALLOWED_REPOSITORY_URL_SCHEMES);
        return repository;
    }

    private static VersionRangeResult findVersionRange(RepositorySystem repositorySystem, RepositorySystemSession session, String groupId, String artifactId) throws MavenRepositoryException {
        DefaultArtifact artifactWithVersionRange = new DefaultArtifact(groupId, artifactId, null, "(0,]");
        VersionRangeRequest request = new VersionRangeRequest((Artifact)artifactWithVersionRange, (List)ImmutableList.of((Object)CENTRAL), null);
        try {
            return repositorySystem.resolveVersionRange(session, request);
        }
        catch (VersionRangeResolutionException ex) {
            throw new MavenRepositoryException((Exception)((Object)ex));
        }
    }

    @VisibleForTesting
    static String findHighestVersion(RepositorySystem repositorySystem, RepositorySystemSession session, String groupId, String artifactId) throws MavenRepositoryException {
        return RepositoryUtility.findVersionRange(repositorySystem, session, groupId, artifactId).getHighestVersion().toString();
    }

    public static ImmutableList<String> findVersions(RepositorySystem repositorySystem, String groupId, String artifactId) throws MavenRepositoryException {
        RepositorySystemSession session = RepositoryUtility.newSession(repositorySystem);
        return (ImmutableList)RepositoryUtility.findVersionRange(repositorySystem, session, groupId, artifactId).getVersions().stream().map(version -> version.toString()).collect(ImmutableList.toImmutableList());
    }

    public static String findLatestCoordinates(RepositorySystem repositorySystem, String groupId, String artifactId) throws MavenRepositoryException {
        RepositorySystemSession session = RepositoryUtility.newSession(repositorySystem);
        String highestVersion = RepositoryUtility.findHighestVersion(repositorySystem, session, groupId, artifactId);
        return String.format("%s:%s:%s", groupId, artifactId, highestVersion);
    }
}

