/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.opensource.classpath;

import com.google.cloud.tools.opensource.classpath.ClassPathEntry;
import com.google.cloud.tools.opensource.classpath.ClassPathResult;
import com.google.cloud.tools.opensource.classpath.MavenDependencyMediation;
import com.google.cloud.tools.opensource.dependencies.DependencyGraph;
import com.google.cloud.tools.opensource.dependencies.DependencyGraphBuilder;
import com.google.cloud.tools.opensource.dependencies.DependencyPath;
import com.google.cloud.tools.opensource.dependencies.UnresolvableArtifactProblem;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.List;
import org.eclipse.aether.artifact.Artifact;

public final class ClassPathBuilder {
    private final DependencyGraphBuilder dependencyGraphBuilder;

    public ClassPathBuilder() {
        this(new DependencyGraphBuilder());
    }

    public ClassPathBuilder(DependencyGraphBuilder dependencyGraphBuilder) {
        this.dependencyGraphBuilder = dependencyGraphBuilder;
    }

    public ClassPathResult resolve(List<Artifact> artifacts) {
        LinkedListMultimap multimap = LinkedListMultimap.create();
        if (artifacts.isEmpty()) {
            return new ClassPathResult((ListMultimap<ClassPathEntry, DependencyPath>)multimap, (Iterable<UnresolvableArtifactProblem>)ImmutableList.of());
        }
        DependencyGraph result = this.dependencyGraphBuilder.buildFullDependencyGraph(artifacts);
        List<DependencyPath> dependencyPaths = result.list();
        MavenDependencyMediation mediation = new MavenDependencyMediation();
        for (DependencyPath dependencyPath : dependencyPaths) {
            Artifact artifact = dependencyPath.getLeaf();
            mediation.put(dependencyPath);
            if (!mediation.selects(artifact)) continue;
            multimap.put((Object)new ClassPathEntry(artifact), (Object)dependencyPath);
        }
        return new ClassPathResult((ListMultimap<ClassPathEntry, DependencyPath>)multimap, result.getUnresolvedArtifacts());
    }
}

