/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.opensource.classpath;

import com.google.cloud.tools.opensource.classpath.ClassFile;
import com.google.cloud.tools.opensource.classpath.ClassPathEntry;
import com.google.cloud.tools.opensource.classpath.ClassSymbol;
import com.google.cloud.tools.opensource.classpath.SymbolReferences;
import com.google.common.collect.ImmutableSet;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.MutableGraph;
import com.google.common.graph.SuccessorsFunction;
import com.google.common.graph.Traverser;
import java.io.IOException;
import java.util.Set;

public class ClassReferenceGraph {
    private final ImmutableSet<String> reachableClasses;

    static ClassReferenceGraph create(SymbolReferences symbolReferences, Set<ClassPathEntry> entryPoints) throws IOException {
        ImmutableSet.Builder entryPointClassBuilder = ImmutableSet.builder();
        for (ClassPathEntry entry : entryPoints) {
            for (String className : entry.getFileNames()) {
                entryPointClassBuilder.add((Object)className);
            }
        }
        return new ClassReferenceGraph(symbolReferences, (Set<String>)entryPointClassBuilder.build());
    }

    private ClassReferenceGraph(SymbolReferences symbolReferences, Set<String> entryPointClasses) {
        MutableGraph graph = GraphBuilder.directed().allowsSelfLoops(false).build();
        for (ClassFile classFile : symbolReferences.getClassFiles()) {
            String sourceClassName = classFile.getBinaryName();
            for (ClassSymbol symbol : symbolReferences.getClassSymbols(classFile)) {
                String targetClassName = symbol.getClassBinaryName();
                if (sourceClassName.equals(targetClassName)) continue;
                graph.putEdge((Object)sourceClassName, (Object)targetClassName);
            }
        }
        entryPointClasses.forEach(arg_0 -> ((MutableGraph)graph).addNode(arg_0));
        this.reachableClasses = ImmutableSet.copyOf((Iterable)Traverser.forGraph((SuccessorsFunction)graph).breadthFirst(entryPointClasses));
    }

    public boolean isReachable(String className) {
        return this.reachableClasses.contains((Object)className);
    }
}

