/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.opensource.classpath;

import com.google.cloud.tools.opensource.classpath.ClassFile;
import com.google.cloud.tools.opensource.classpath.ExclusionFiles;
import com.google.cloud.tools.opensource.classpath.LinkageChecker;
import com.google.cloud.tools.opensource.classpath.LinkageErrorMatcher;
import com.google.cloud.tools.opensource.classpath.SymbolProblem;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import javax.annotation.Nullable;
import org.iso_relax.verifier.VerifierConfigurationException;
import org.xml.sax.SAXException;

class ExcludedErrors {
    private final ImmutableList<LinkageErrorMatcher> exclusionMatchers;

    static ExcludedErrors create(@Nullable Path exclusionFile) throws IOException {
        ImmutableList.Builder exclusionMatchers = ImmutableList.builder();
        try {
            URL defaultRuleUrl = LinkageChecker.class.getClassLoader().getResource("linkage-checker-exclusion-default.xml");
            ImmutableList<LinkageErrorMatcher> defaultMatchers = ExclusionFiles.parse(defaultRuleUrl);
            exclusionMatchers.addAll(defaultMatchers);
        }
        catch (VerifierConfigurationException | SAXException ex) {
            throw new IOException("Could not read default exclusion rule", ex);
        }
        try {
            if (exclusionFile != null) {
                exclusionMatchers.addAll(ExclusionFiles.parse(exclusionFile));
            }
        }
        catch (VerifierConfigurationException | SAXException ex) {
            throw new IOException("Could not read exclusion rule file " + exclusionFile, ex);
        }
        return new ExcludedErrors((Iterable<LinkageErrorMatcher>)exclusionMatchers.build());
    }

    private ExcludedErrors(Iterable<LinkageErrorMatcher> exclusionMatchers) {
        this.exclusionMatchers = ImmutableList.copyOf(exclusionMatchers);
    }

    boolean contains(SymbolProblem symbolProblem, ClassFile sourceClass) {
        for (LinkageErrorMatcher matcher : this.exclusionMatchers) {
            if (!matcher.match(symbolProblem, sourceClass)) continue;
            return true;
        }
        return false;
    }
}

