/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.opensource.classpath;

import com.google.cloud.tools.opensource.classpath.ClassFile;
import com.google.cloud.tools.opensource.classpath.ClassSymbol;
import com.google.cloud.tools.opensource.classpath.ExclusionFileHandler;
import com.google.cloud.tools.opensource.classpath.FieldSymbol;
import com.google.cloud.tools.opensource.classpath.LinkageErrorMatcher;
import com.google.cloud.tools.opensource.classpath.MethodSymbol;
import com.google.cloud.tools.opensource.classpath.Symbol;
import com.google.cloud.tools.opensource.classpath.SymbolProblem;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.thaiopensource.xml.sax.DraconianErrorHandler;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.iso_relax.verifier.Schema;
import org.iso_relax.verifier.Verifier;
import org.iso_relax.verifier.VerifierConfigurationException;
import org.iso_relax.verifier.VerifierFactory;
import org.iso_relax.verifier.VerifierFilter;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

class ExclusionFiles {
    private static final XMLEventFactory eventFactory = XMLEventFactory.newInstance();
    private static final QName LINKAGE_CHECKER_FILTER_TAG = QName.valueOf("LinkageCheckerFilter");
    private static final QName CLASS_TAG = QName.valueOf("Class");
    private static final QName LINKAGE_ERROR_TAG = QName.valueOf("LinkageError");
    private static final QName TARGET_TAG = QName.valueOf("Target");
    private static final QName SOURCE_TAG = QName.valueOf("Source");
    private static final QName METHOD_TAG = QName.valueOf("Method");
    private static final QName FIELD_TAG = QName.valueOf("Field");

    ExclusionFiles() {
    }

    static ImmutableList<LinkageErrorMatcher> parse(Path exclusionFile) throws SAXException, IOException, VerifierConfigurationException {
        InputSource inputSource = new InputSource(Files.newInputStream(exclusionFile, new OpenOption[0]));
        inputSource.setSystemId(exclusionFile.toUri().toString());
        return ExclusionFiles.parse(inputSource);
    }

    static ImmutableList<LinkageErrorMatcher> parse(URL exclusionFile) throws SAXException, IOException, VerifierConfigurationException {
        InputSource inputSource = new InputSource(exclusionFile.openStream());
        inputSource.setSystemId(exclusionFile.toString());
        return ExclusionFiles.parse(inputSource);
    }

    private static ImmutableList<LinkageErrorMatcher> parse(InputSource inputSource) throws SAXException, IOException, VerifierConfigurationException {
        XMLReader reader = ExclusionFiles.createXmlReader();
        ExclusionFileHandler handler = new ExclusionFileHandler();
        reader.setContentHandler(handler);
        reader.parse(inputSource);
        return handler.getMatchers();
    }

    private static XMLReader createXmlReader() throws SAXException, IOException, VerifierConfigurationException {
        VerifierFactory factory = VerifierFactory.newInstance((String)"http://relaxng.org/ns/structure/1.0");
        InputStream linkageCheckerSchema = ExclusionFiles.class.getClassLoader().getResourceAsStream("linkage-checker-exclusion.rng");
        Schema schema = factory.compileSchema(linkageCheckerSchema);
        Verifier verifier = schema.newVerifier();
        verifier.setErrorHandler((ErrorHandler)new DraconianErrorHandler());
        VerifierFilter filter = verifier.getVerifierFilter();
        filter.setParent(XMLReaderFactory.createXMLReader());
        return filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void write(Path outputFile, Multimap<SymbolProblem, ClassFile> linkageErrors) throws IOException, XMLStreamException, TransformerException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        try (XMLEventWriter writer = null;){
            writer = XMLOutputFactory.newInstance().createXMLEventWriter(buffer);
            writer.add(eventFactory.createStartDocument());
            writer.add(eventFactory.createStartElement(LINKAGE_CHECKER_FILTER_TAG, null, null));
            for (SymbolProblem symbolProblem : linkageErrors.keySet()) {
                for (ClassFile classFile : linkageErrors.get((Object)symbolProblem)) {
                    ExclusionFiles.writeXmlEvents(writer, symbolProblem, classFile);
                }
            }
            writer.add(eventFactory.createEndElement(LINKAGE_CHECKER_FILTER_TAG, null));
            writer.add(eventFactory.createEndDocument());
        }
        try (OutputStream outputStream = Files.newOutputStream(outputFile, new OpenOption[0]);){
            ExclusionFiles.insertIndent(new ByteArrayInputStream(buffer.toByteArray()), outputStream);
        }
    }

    private static void insertIndent(InputStream inputStream, OutputStream outputStream) throws TransformerException {
        System.setProperty("javax.xml.transform.TransformerFactory", "com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl");
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer indentTransformer = transformerFactory.newTransformer();
        indentTransformer.setOutputProperty("indent", "yes");
        indentTransformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        indentTransformer.setOutputProperty("doctype-public", "yes");
        indentTransformer.transform(new StreamSource(inputStream), new StreamResult(outputStream));
    }

    private static void writeXmlEvents(XMLEventWriter writer, SymbolProblem symbolProblem, ClassFile classFile) throws XMLStreamException {
        writer.add(eventFactory.createStartElement(LINKAGE_ERROR_TAG, null, null));
        writer.add(eventFactory.createStartElement(TARGET_TAG, null, null));
        ExclusionFiles.writeXmlElement(writer, symbolProblem.getSymbol());
        writer.add(eventFactory.createEndElement(TARGET_TAG, null));
        writer.add(eventFactory.createStartElement(SOURCE_TAG, null, null));
        ExclusionFiles.writeXmlElement(writer, classFile);
        writer.add(eventFactory.createEndElement(SOURCE_TAG, null));
        writer.add(eventFactory.createEndElement(LINKAGE_ERROR_TAG, null));
    }

    private static void writeXmlElement(XMLEventWriter writer, Symbol symbol) throws XMLStreamException {
        if (symbol instanceof ClassSymbol) {
            Attribute className = eventFactory.createAttribute("name", symbol.getClassBinaryName());
            StartElement event = eventFactory.createStartElement(CLASS_TAG, (Iterator<? extends Attribute>)ImmutableList.of((Object)className).iterator(), null);
            writer.add(event);
            writer.add(eventFactory.createEndElement(CLASS_TAG, null));
        } else if (symbol instanceof MethodSymbol) {
            MethodSymbol methodSymbol = (MethodSymbol)symbol;
            Attribute className = eventFactory.createAttribute("className", symbol.getClassBinaryName());
            Attribute methodName = eventFactory.createAttribute("name", methodSymbol.getName());
            StartElement event = eventFactory.createStartElement(METHOD_TAG, (Iterator<? extends Attribute>)ImmutableList.of((Object)className, (Object)methodName).iterator(), null);
            writer.add(event);
            writer.add(eventFactory.createEndElement(METHOD_TAG, null));
        } else if (symbol instanceof FieldSymbol) {
            FieldSymbol fieldSymbol = (FieldSymbol)symbol;
            Attribute className = eventFactory.createAttribute("className", symbol.getClassBinaryName());
            Attribute methodName = eventFactory.createAttribute("name", fieldSymbol.getName());
            StartElement event = eventFactory.createStartElement(FIELD_TAG, (Iterator<? extends Attribute>)ImmutableList.of((Object)className, (Object)methodName).iterator(), null);
            writer.add(event);
            writer.add(eventFactory.createEndElement(FIELD_TAG, null));
        }
    }

    private static void writeXmlElement(XMLEventWriter writer, ClassFile classFile) throws XMLStreamException {
        Attribute className = eventFactory.createAttribute("name", classFile.getBinaryName());
        writer.add(eventFactory.createStartElement(CLASS_TAG, (Iterator<? extends Attribute>)ImmutableList.of((Object)className).iterator(), null));
        writer.add(eventFactory.createEndElement(CLASS_TAG, null));
    }
}

