/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.opensource.classpath;

import com.google.cloud.tools.opensource.classpath.ClassDumper;
import com.google.cloud.tools.opensource.classpath.ClassFile;
import com.google.cloud.tools.opensource.classpath.ClassPathBuilder;
import com.google.cloud.tools.opensource.classpath.ClassPathEntry;
import com.google.cloud.tools.opensource.classpath.ClassPathResult;
import com.google.cloud.tools.opensource.classpath.ClassReferenceGraph;
import com.google.cloud.tools.opensource.classpath.ClassSymbol;
import com.google.cloud.tools.opensource.classpath.ErrorType;
import com.google.cloud.tools.opensource.classpath.ExcludedErrors;
import com.google.cloud.tools.opensource.classpath.FieldSymbol;
import com.google.cloud.tools.opensource.classpath.InterfaceSymbol;
import com.google.cloud.tools.opensource.classpath.MethodSymbol;
import com.google.cloud.tools.opensource.classpath.SuperClassSymbol;
import com.google.cloud.tools.opensource.classpath.SymbolProblem;
import com.google.cloud.tools.opensource.classpath.SymbolReferences;
import com.google.cloud.tools.opensource.dependencies.Bom;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.FieldOrMethod;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.eclipse.aether.artifact.Artifact;

public class LinkageChecker {
    private static final Logger logger = Logger.getLogger(LinkageChecker.class.getName());
    private final ClassDumper classDumper;
    private final ImmutableList<ClassPathEntry> classPath;
    private final SymbolReferences symbolReferences;
    private final ClassReferenceGraph classReferenceGraph;
    private final ExcludedErrors excludedErrors;

    @VisibleForTesting
    SymbolReferences getSymbolReferences() {
        return this.symbolReferences;
    }

    public ClassReferenceGraph getClassReferenceGraph() {
        return this.classReferenceGraph;
    }

    public static LinkageChecker create(List<ClassPathEntry> classPath) throws IOException {
        return LinkageChecker.create(classPath, (Iterable<ClassPathEntry>)ImmutableSet.copyOf(classPath), null);
    }

    public static LinkageChecker create(List<ClassPathEntry> classPath, Iterable<ClassPathEntry> entryPoints, @Nullable Path exclusionFile) throws IOException {
        Preconditions.checkArgument((!classPath.isEmpty() ? 1 : 0) != 0, (Object)"The linkage classpath is empty.");
        ClassDumper dumper = ClassDumper.create(classPath);
        SymbolReferences symbolReferenceMaps = dumper.findSymbolReferences();
        ClassReferenceGraph classReferenceGraph = ClassReferenceGraph.create(symbolReferenceMaps, (Set<ClassPathEntry>)ImmutableSet.copyOf(entryPoints));
        return new LinkageChecker(dumper, classPath, symbolReferenceMaps, classReferenceGraph, ExcludedErrors.create(exclusionFile));
    }

    public static LinkageChecker create(Bom bom) throws IOException {
        return LinkageChecker.create(bom, null);
    }

    public static LinkageChecker create(Bom bom, Path exclusionFile) throws IOException {
        ImmutableList<Artifact> managedDependencies = bom.getManagedDependencies();
        ClassPathBuilder classPathBuilder = new ClassPathBuilder();
        ClassPathResult classPathResult = classPathBuilder.resolve((List<Artifact>)managedDependencies);
        ImmutableList<ClassPathEntry> classpath = classPathResult.getClassPath();
        ImmutableList artifactsInBom = classpath.subList(0, managedDependencies.size());
        ImmutableSet entryPoints = ImmutableSet.copyOf((Collection)artifactsInBom);
        return LinkageChecker.create(classpath, (Iterable<ClassPathEntry>)entryPoints, exclusionFile);
    }

    @VisibleForTesting
    LinkageChecker cloneWith(SymbolReferences newSymbolMaps) {
        return new LinkageChecker(this.classDumper, (List<ClassPathEntry>)this.classPath, newSymbolMaps, this.classReferenceGraph, this.excludedErrors);
    }

    private LinkageChecker(ClassDumper classDumper, List<ClassPathEntry> classPath, SymbolReferences symbolReferenceMaps, ClassReferenceGraph classReferenceGraph, ExcludedErrors excludedErrors) {
        this.classDumper = (ClassDumper)Preconditions.checkNotNull((Object)classDumper);
        this.classPath = ImmutableList.copyOf(classPath);
        this.classReferenceGraph = (ClassReferenceGraph)Preconditions.checkNotNull((Object)classReferenceGraph);
        this.symbolReferences = (SymbolReferences)Preconditions.checkNotNull((Object)symbolReferenceMaps);
        this.excludedErrors = (ExcludedErrors)Preconditions.checkNotNull((Object)excludedErrors);
    }

    public ImmutableSetMultimap<SymbolProblem, ClassFile> findSymbolProblems() throws IOException {
        ImmutableSet<String> classFileNames;
        String classBinaryName;
        String classFileName;
        ImmutableSetMultimap.Builder problemToClass = ImmutableSetMultimap.builder();
        for (ClassFile classFile : this.symbolReferences.getClassFiles()) {
            ImmutableSet<ClassSymbol> classSymbols = this.symbolReferences.getClassSymbols(classFile);
            for (ClassSymbol classSymbol : classSymbols) {
                ImmutableSet<String> classFileNames2;
                ImmutableList<SymbolProblem> problems;
                if (classSymbol instanceof SuperClassSymbol && !(problems = this.findAbstractParentProblems(classFile, (SuperClassSymbol)classSymbol)).isEmpty()) {
                    String superClassName = classSymbol.getClassBinaryName();
                    ClassPathEntry superClassLocation = this.classDumper.findClassLocation(superClassName);
                    ClassFile superClassFile = new ClassFile(superClassLocation, superClassName);
                    for (SymbolProblem problem2 : problems) {
                        problemToClass.put((Object)problem2, (Object)superClassFile);
                    }
                }
                if ((classFileNames2 = classFile.getClassPathEntry().getFileNames()).contains((Object)(classFileName = this.classDumper.getFileName(classBinaryName = classSymbol.getClassBinaryName())))) continue;
                if (classSymbol instanceof InterfaceSymbol) {
                    ImmutableList<SymbolProblem> problems2 = this.findInterfaceProblems(classFile, (InterfaceSymbol)classSymbol);
                    if (problems2.isEmpty()) continue;
                    String interfaceName = classSymbol.getClassBinaryName();
                    ClassPathEntry interfaceLocation = this.classDumper.findClassLocation(interfaceName);
                    ClassFile interfaceClassFile = new ClassFile(interfaceLocation, interfaceName);
                    for (SymbolProblem problem3 : problems2) {
                        problemToClass.put((Object)problem3, (Object)interfaceClassFile);
                    }
                    continue;
                }
                this.findSymbolProblem(classFile, classSymbol).ifPresent(problem -> problemToClass.put(problem, (Object)classFile.topLevelClassFile()));
            }
        }
        for (ClassFile classFile : this.symbolReferences.getClassFiles()) {
            ImmutableSet<MethodSymbol> methodSymbols = this.symbolReferences.getMethodSymbols(classFile);
            classFileNames = classFile.getClassPathEntry().getFileNames();
            for (MethodSymbol methodSymbol : methodSymbols) {
                classBinaryName = methodSymbol.getClassBinaryName();
                classFileName = this.classDumper.getFileName(classBinaryName);
                if (classFileNames.contains((Object)classFileName)) continue;
                this.findSymbolProblem(classFile, methodSymbol).ifPresent(problem -> problemToClass.put(problem, (Object)classFile.topLevelClassFile()));
            }
        }
        for (ClassFile classFile : this.symbolReferences.getClassFiles()) {
            ImmutableSet<FieldSymbol> fieldSymbols = this.symbolReferences.getFieldSymbols(classFile);
            classFileNames = classFile.getClassPathEntry().getFileNames();
            for (FieldSymbol fieldSymbol : fieldSymbols) {
                classBinaryName = fieldSymbol.getClassBinaryName();
                classFileName = this.classDumper.getFileName(classBinaryName);
                if (classFileNames.contains((Object)classFileName)) continue;
                this.findSymbolProblem(classFile, fieldSymbol).ifPresent(problem -> problemToClass.put(problem, (Object)classFile.topLevelClassFile()));
            }
        }
        SetMultimap filteredMap = Multimaps.filterEntries((SetMultimap)problemToClass.build(), this::problemFilter);
        return ImmutableSetMultimap.copyOf((Multimap)filteredMap);
    }

    private boolean problemFilter(Map.Entry<SymbolProblem, ClassFile> entry) {
        ClassFile sourceClass;
        SymbolProblem symbolProblem = entry.getKey();
        return !this.excludedErrors.contains(symbolProblem, sourceClass = entry.getValue());
    }

    @VisibleForTesting
    Optional<SymbolProblem> findSymbolProblem(ClassFile classFile, MethodSymbol symbol) {
        String sourceClassName = classFile.getBinaryName();
        String targetClassName = symbol.getClassBinaryName();
        String methodName = symbol.getName();
        if (this.classDumper.isSystemClass(targetClassName)) {
            return Optional.empty();
        }
        try {
            ClassFile containingClassFile;
            JavaClass targetJavaClass = this.classDumper.loadJavaClass(targetClassName);
            ClassPathEntry classFileLocation = this.classDumper.findClassLocation(targetClassName);
            ClassFile classFile2 = containingClassFile = classFileLocation == null ? null : new ClassFile(classFileLocation, targetClassName);
            if (!this.isClassAccessibleFrom(targetJavaClass, sourceClassName)) {
                return Optional.of(new SymbolProblem(symbol, ErrorType.INACCESSIBLE_CLASS, containingClassFile));
            }
            if (targetJavaClass.isInterface() != symbol.isInterfaceMethod()) {
                return Optional.of(new SymbolProblem(symbol, ErrorType.INCOMPATIBLE_CLASS_CHANGE, containingClassFile));
            }
            Optional<SymbolProblem> parentSymbolProblem = this.findParentSymbolProblem(targetClassName);
            if (parentSymbolProblem.isPresent()) {
                return parentSymbolProblem;
            }
            Iterable typesToCheck = Iterables.concat(ClassDumper.getClassHierarchy(targetJavaClass), Arrays.asList(targetJavaClass.getAllInterfaces()));
            for (JavaClass javaClass : typesToCheck) {
                for (Method method : javaClass.getMethods()) {
                    if (!method.getName().equals(methodName) || !method.getSignature().equals(symbol.getDescriptor())) continue;
                    if (!this.isMemberAccessibleFrom(javaClass, (FieldOrMethod)method, sourceClassName)) {
                        return Optional.of(new SymbolProblem(symbol, ErrorType.INACCESSIBLE_MEMBER, containingClassFile));
                    }
                    return Optional.empty();
                }
            }
            if (this.classDumper.catchesLinkageErrorOnMethod(sourceClassName)) {
                return Optional.empty();
            }
            return Optional.of(new SymbolProblem(symbol, ErrorType.SYMBOL_NOT_FOUND, containingClassFile));
        }
        catch (ClassNotFoundException ex) {
            if (this.classDumper.catchesLinkageErrorOnClass(sourceClassName)) {
                return Optional.empty();
            }
            ClassSymbol classSymbol = new ClassSymbol(symbol.getClassBinaryName());
            return Optional.of(new SymbolProblem(classSymbol, ErrorType.CLASS_NOT_FOUND, null));
        }
    }

    private ImmutableList<SymbolProblem> findInterfaceProblems(ClassFile classFile, InterfaceSymbol interfaceSymbol) {
        String interfaceName = interfaceSymbol.getClassBinaryName();
        if (this.classDumper.isSystemClass(interfaceName)) {
            return ImmutableList.of();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        try {
            JavaClass implementingClass = this.classDumper.loadJavaClass(classFile.getBinaryName());
            if (implementingClass.isAbstract()) {
                return ImmutableList.of();
            }
            JavaClass interfaceDefinition = this.classDumper.loadJavaClass(interfaceName);
            for (Method interfaceMethod : interfaceDefinition.getMethods()) {
                if (interfaceMethod.getCode() != null) continue;
                String interfaceMethodName = interfaceMethod.getName();
                String interfaceMethodDescriptor = interfaceMethod.getSignature();
                boolean methodFound = false;
                Iterable typesToCheck = Iterables.concat((Iterable[])new Iterable[]{ClassDumper.getClassHierarchy(implementingClass)});
                block3: for (JavaClass javaClass : typesToCheck) {
                    for (Method method : javaClass.getMethods()) {
                        if (!method.getName().equals(interfaceMethodName) || !method.getSignature().equals(interfaceMethodDescriptor)) continue;
                        methodFound = true;
                        continue block3;
                    }
                }
                if (methodFound) continue;
                MethodSymbol missingMethodOnClass = new MethodSymbol(classFile.getBinaryName(), interfaceMethodName, interfaceMethodDescriptor, false);
                builder.add((Object)new SymbolProblem(missingMethodOnClass, ErrorType.ABSTRACT_METHOD, classFile));
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return builder.build();
    }

    @VisibleForTesting
    Optional<SymbolProblem> findSymbolProblem(ClassFile classFile, FieldSymbol symbol) {
        String sourceClassName = classFile.getBinaryName();
        String targetClassName = symbol.getClassBinaryName();
        String fieldName = symbol.getName();
        try {
            ClassFile containingClassFile;
            JavaClass targetJavaClass = this.classDumper.loadJavaClass(targetClassName);
            ClassPathEntry classFileLocation = this.classDumper.findClassLocation(targetClassName);
            ClassFile classFile2 = containingClassFile = classFileLocation == null ? null : new ClassFile(classFileLocation, targetClassName);
            if (!this.isClassAccessibleFrom(targetJavaClass, sourceClassName)) {
                return Optional.of(new SymbolProblem(symbol, ErrorType.INACCESSIBLE_CLASS, containingClassFile));
            }
            for (JavaClass javaClass : ClassDumper.getClassHierarchy(targetJavaClass)) {
                for (Field field : javaClass.getFields()) {
                    if (!field.getName().equals(fieldName)) continue;
                    if (!this.isMemberAccessibleFrom(javaClass, (FieldOrMethod)field, sourceClassName)) {
                        return Optional.of(new SymbolProblem(symbol, ErrorType.INACCESSIBLE_MEMBER, containingClassFile));
                    }
                    return Optional.empty();
                }
            }
            return Optional.of(new SymbolProblem(symbol, ErrorType.SYMBOL_NOT_FOUND, containingClassFile));
        }
        catch (ClassNotFoundException ex) {
            if (this.classDumper.catchesLinkageErrorOnClass(sourceClassName)) {
                return Optional.empty();
            }
            ClassSymbol classSymbol = new ClassSymbol(symbol.getClassBinaryName());
            return Optional.of(new SymbolProblem(classSymbol, ErrorType.CLASS_NOT_FOUND, null));
        }
    }

    private boolean isMemberAccessibleFrom(JavaClass targetClass, FieldOrMethod member, String sourceClassName) {
        if (member.isPublic()) {
            return true;
        }
        if (member.isProtected()) {
            if (ClassDumper.classesInSamePackage(targetClass.getClassName(), sourceClassName)) {
                return true;
            }
            try {
                JavaClass sourceClass = this.classDumper.loadJavaClass(sourceClassName);
                if (ClassDumper.isClassSubClassOf(sourceClass, targetClass)) {
                    return true;
                }
            }
            catch (ClassNotFoundException ex) {
                logger.warning("The source class " + sourceClassName + " of a reference was not found in the class path when checking accessibility");
                return false;
            }
        }
        if (member.isPrivate()) {
            return false;
        }
        return ClassDumper.classesInSamePackage(targetClass.getClassName(), sourceClassName);
    }

    @VisibleForTesting
    Optional<SymbolProblem> findSymbolProblem(ClassFile classFile, ClassSymbol symbol) {
        String sourceClassName = classFile.getBinaryName();
        String targetClassName = symbol.getClassBinaryName();
        try {
            JavaClass targetClass = this.classDumper.loadJavaClass(targetClassName);
            ClassPathEntry classFileLocation = this.classDumper.findClassLocation(targetClassName);
            ClassFile containingClassFile = classFileLocation == null ? null : new ClassFile(classFileLocation, targetClassName);
            boolean isSubclassReference = symbol instanceof SuperClassSymbol;
            if (isSubclassReference && !ClassDumper.hasValidSuperclass(this.classDumper.loadJavaClass(sourceClassName), targetClass)) {
                return Optional.of(new SymbolProblem(symbol, ErrorType.INCOMPATIBLE_CLASS_CHANGE, containingClassFile));
            }
            if (!this.isClassAccessibleFrom(targetClass, sourceClassName)) {
                return Optional.of(new SymbolProblem(symbol, ErrorType.INACCESSIBLE_CLASS, containingClassFile));
            }
            return Optional.empty();
        }
        catch (ClassNotFoundException ex) {
            if (this.classDumper.isUnusedClassSymbolReference(sourceClassName, symbol) || this.classDumper.catchesLinkageErrorOnClass(sourceClassName)) {
                return Optional.empty();
            }
            return Optional.of(new SymbolProblem(symbol, ErrorType.CLASS_NOT_FOUND, null));
        }
    }

    private boolean isClassAccessibleFrom(JavaClass javaClass, String sourceClassName) throws ClassNotFoundException {
        if (javaClass.isPrivate()) {
            return false;
        }
        String targetClassName = javaClass.getClassName();
        if (javaClass.isPublic() || ClassDumper.classesInSamePackage(targetClassName, sourceClassName)) {
            String enclosingClassName = ClassDumper.enclosingClassName(targetClassName);
            if (enclosingClassName != null) {
                JavaClass enclosingJavaClass = this.classDumper.loadJavaClass(enclosingClassName);
                return this.isClassAccessibleFrom(enclosingJavaClass, sourceClassName);
            }
            return true;
        }
        return false;
    }

    private Optional<SymbolProblem> findParentSymbolProblem(String baseClassName) {
        ArrayDeque<String> queue = new ArrayDeque<String>();
        queue.add(baseClassName);
        while (!queue.isEmpty()) {
            String className = (String)queue.remove();
            if (Object.class.getName().equals(className)) continue;
            String potentiallyMissingClassName = className;
            try {
                JavaClass baseClass = this.classDumper.loadJavaClass(className);
                queue.add(baseClass.getSuperclassName());
                String[] stringArray = baseClass.getInterfaceNames();
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String interfaceName;
                    potentiallyMissingClassName = interfaceName = stringArray[i];
                    JavaClass interfaceClass = this.classDumper.loadJavaClass(interfaceName);
                    queue.addAll(Arrays.asList(interfaceClass.getInterfaceNames()));
                }
            }
            catch (ClassNotFoundException ex) {
                SymbolProblem problem = new SymbolProblem(new ClassSymbol(potentiallyMissingClassName), ErrorType.SYMBOL_NOT_FOUND, null);
                return Optional.of(problem);
            }
        }
        return Optional.empty();
    }

    private ImmutableList<SymbolProblem> findAbstractParentProblems(ClassFile classFile, SuperClassSymbol superClassSymbol) {
        ImmutableList.Builder builder = ImmutableList.builder();
        String superClassName = superClassSymbol.getClassBinaryName();
        if (this.classDumper.isSystemClass(superClassName)) {
            return ImmutableList.of();
        }
        try {
            String className = classFile.getBinaryName();
            JavaClass implementingClass = this.classDumper.loadJavaClass(className);
            if (implementingClass.isAbstract()) {
                return ImmutableList.of();
            }
            JavaClass superClass = this.classDumper.loadJavaClass(superClassName);
            if (!superClass.isAbstract()) {
                return ImmutableList.of();
            }
            JavaClass abstractClass = superClass;
            HashSet<Method> implementedMethods = new HashSet<Method>();
            implementedMethods.addAll((Collection<Method>)ImmutableList.copyOf((Object[])implementingClass.getMethods()));
            while (abstractClass.isAbstract()) {
                for (Method abstractMethod : abstractClass.getMethods()) {
                    if (!abstractMethod.isAbstract()) {
                        implementedMethods.add(abstractMethod);
                        continue;
                    }
                    if (implementedMethods.contains(abstractMethod)) continue;
                    String unimplementedMethodName = abstractMethod.getName();
                    String unimplementedMethodDescriptor = abstractMethod.getSignature();
                    MethodSymbol missingMethodOnClass = new MethodSymbol(className, unimplementedMethodName, unimplementedMethodDescriptor, false);
                    builder.add((Object)new SymbolProblem(missingMethodOnClass, ErrorType.ABSTRACT_METHOD, classFile));
                }
                abstractClass = abstractClass.getSuperClass();
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return builder.build();
    }
}

