/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.opensource.classpath;

import com.google.cloud.tools.opensource.classpath.ClassFile;
import com.google.cloud.tools.opensource.classpath.ClassPathBuilder;
import com.google.cloud.tools.opensource.classpath.ClassPathEntry;
import com.google.cloud.tools.opensource.classpath.ClassPathResult;
import com.google.cloud.tools.opensource.classpath.ClassReferenceGraph;
import com.google.cloud.tools.opensource.classpath.ExclusionFiles;
import com.google.cloud.tools.opensource.classpath.LinkageCheckResultException;
import com.google.cloud.tools.opensource.classpath.LinkageChecker;
import com.google.cloud.tools.opensource.classpath.LinkageCheckerArguments;
import com.google.cloud.tools.opensource.classpath.SymbolProblem;
import com.google.cloud.tools.opensource.dependencies.ArtifactProblem;
import com.google.cloud.tools.opensource.dependencies.DependencyGraphBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.TransformerException;
import org.apache.commons.cli.ParseException;
import org.eclipse.aether.RepositoryException;
import org.eclipse.aether.artifact.Artifact;

class LinkageCheckerMain {
    LinkageCheckerMain() {
    }

    public static void main(String[] arguments) throws IOException, RepositoryException, TransformerException, XMLStreamException, LinkageCheckResultException {
        try {
            LinkageCheckerArguments linkageCheckerArguments = LinkageCheckerArguments.readCommandLine(arguments);
            if (linkageCheckerArguments.needsHelp() || arguments.length == 0) {
                linkageCheckerArguments.printHelp();
            }
            if (linkageCheckerArguments.hasInput()) {
                Path writeAsExclusionFile;
                ImmutableSet entryPoints;
                ImmutableList<ClassPathEntry> inputClassPath;
                ImmutableList<Artifact> artifacts = linkageCheckerArguments.getArtifacts();
                ArrayList<ArtifactProblem> artifactProblems = new ArrayList<ArtifactProblem>();
                ClassPathResult classPathResult = null;
                if (artifacts.isEmpty()) {
                    inputClassPath = linkageCheckerArguments.getJarFiles();
                    entryPoints = ImmutableSet.copyOf(inputClassPath);
                } else {
                    DependencyGraphBuilder dependencyGraphBuilder = new DependencyGraphBuilder((Iterable<String>)linkageCheckerArguments.getMavenRepositoryUrls());
                    ClassPathBuilder classPathBuilder = new ClassPathBuilder(dependencyGraphBuilder);
                    classPathResult = classPathBuilder.resolve((List<Artifact>)artifacts);
                    inputClassPath = classPathResult.getClassPath();
                    artifactProblems.addAll((Collection<ArtifactProblem>)classPathResult.getArtifactProblems());
                    entryPoints = ImmutableSet.copyOf((Collection)inputClassPath.subList(0, artifacts.size()));
                }
                LinkageChecker linkageChecker = LinkageChecker.create(inputClassPath, (Iterable<ClassPathEntry>)entryPoints, linkageCheckerArguments.getInputExclusionFile());
                ImmutableSetMultimap symbolProblems = linkageChecker.findSymbolProblems();
                if (linkageCheckerArguments.getReportOnlyReachable()) {
                    ClassReferenceGraph graph = linkageChecker.getClassReferenceGraph();
                    symbolProblems = ImmutableSetMultimap.copyOf((Multimap)Multimaps.filterValues(symbolProblems, classFile -> graph.isReachable(classFile.getBinaryName())));
                }
                if ((writeAsExclusionFile = linkageCheckerArguments.getOutputExclusionFile()) != null) {
                    ExclusionFiles.write(writeAsExclusionFile, symbolProblems);
                    System.out.println("Wrote the linkage errors as exclusion file: " + writeAsExclusionFile);
                    return;
                }
                if (!symbolProblems.isEmpty()) {
                    System.out.println(SymbolProblem.formatSymbolProblems((ImmutableSetMultimap<SymbolProblem, ClassFile>)symbolProblems));
                }
                if (classPathResult != null && !symbolProblems.isEmpty()) {
                    ImmutableSet.Builder problematicJars = ImmutableSet.builder();
                    for (SymbolProblem symbolProblem : symbolProblems.keySet()) {
                        ClassFile containingClass = symbolProblem.getContainingClass();
                        if (containingClass != null) {
                            problematicJars.add((Object)containingClass.getClassPathEntry());
                        }
                        for (ClassFile classFile2 : symbolProblems.get((Object)symbolProblem)) {
                            problematicJars.add((Object)classFile2.getClassPathEntry());
                        }
                    }
                    System.out.println(classPathResult.formatDependencyPaths((Iterable<ClassPathEntry>)problematicJars.build()));
                }
                if (!artifactProblems.isEmpty()) {
                    System.out.println("\n");
                    System.out.println(ArtifactProblem.formatProblems(artifactProblems));
                }
                if (!symbolProblems.isEmpty()) {
                    throw new LinkageCheckResultException(symbolProblems.size());
                }
            }
        }
        catch (ParseException ex) {
            System.err.println(ex.getMessage());
        }
    }
}

