/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.opensource.dependencies;

import com.google.cloud.tools.opensource.dependencies.Artifacts;
import com.google.cloud.tools.opensource.dependencies.DependencyPath;
import com.google.cloud.tools.opensource.dependencies.UniquePathRecordingDependencyVisitor;
import com.google.cloud.tools.opensource.dependencies.UnresolvableArtifactProblem;
import com.google.cloud.tools.opensource.dependencies.Update;
import com.google.cloud.tools.opensource.dependencies.VersionComparator;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.TreeMultimap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Set;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.DependencyVisitor;

public class DependencyGraph {
    private final List<DependencyPath> graph = new ArrayList<DependencyPath>();
    private final Set<UnresolvableArtifactProblem> artifactProblems = new HashSet<UnresolvableArtifactProblem>();
    private final TreeMultimap<String, String> versions = TreeMultimap.create(Comparator.naturalOrder(), (Comparator)new VersionComparator());
    private SetMultimap<String, DependencyPath> paths = HashMultimap.create();
    private DependencyNode root;
    private final Set<Artifact> checkedArtifacts = new HashSet<Artifact>();

    public DependencyGraph(DependencyNode root) {
        this.root = root;
    }

    @VisibleForTesting
    void addPath(DependencyPath path) {
        Artifact leaf = path.getLeaf();
        if (leaf == null) {
            return;
        }
        this.graph.add(path);
        String coordinates = Artifacts.toCoordinates(leaf);
        this.versions.put((Object)Artifacts.makeKey(leaf), (Object)leaf.getVersion());
        this.paths.put((Object)coordinates, (Object)path);
    }

    List<DependencyPath> findConflicts() {
        ArrayList<DependencyPath> result = new ArrayList<DependencyPath>();
        for (String coordinates : this.versions.keySet()) {
            NavigableSet artifactVersions = this.versions.get((Object)coordinates);
            if (artifactVersions.size() <= 1) continue;
            for (String conflictingVersion : artifactVersions) {
                result.addAll(this.paths.get((Object)(coordinates + ":" + conflictingVersion)));
            }
        }
        return result;
    }

    public List<DependencyPath> list() {
        return new ArrayList<DependencyPath>(this.graph);
    }

    public Set<DependencyPath> getPaths(String coordinates) {
        return this.paths.get((Object)coordinates);
    }

    public List<Update> findUpdates() {
        List<DependencyPath> paths = this.findConflicts();
        LinkedHashSet<Update> upgrades = new LinkedHashSet<Update>();
        for (DependencyPath path : paths) {
            Artifact leaf = path.getLeaf();
            String key = Artifacts.makeKey(leaf);
            String highestVersion = (String)this.versions.get((Object)key).last();
            if (leaf.getVersion().equals(highestVersion)) continue;
            Artifact parent = path.get(path.size() - 2);
            String lastParentVersion = (String)this.versions.get((Object)Artifacts.makeKey(parent)).last();
            if (!parent.getVersion().equals(lastParentVersion)) continue;
            Artifact updated = leaf.setVersion(highestVersion);
            Update update = Update.builder().setParent(parent).setFrom(leaf).setTo(updated).build();
            upgrades.add(update);
        }
        return new ArrayList<Update>(upgrades);
    }

    public Map<String, String> getHighestVersionMap() {
        NavigableMap input = this.versions.asMap();
        HashMap<String, String> output = new HashMap<String, String>();
        VersionComparator comparator = new VersionComparator();
        for (Map.Entry entry : input.entrySet()) {
            String highestVersion = Collections.max((Collection)entry.getValue(), comparator);
            output.put((String)entry.getKey(), highestVersion);
        }
        return output;
    }

    public Set<UnresolvableArtifactProblem> getUnresolvedArtifacts() {
        return new HashSet<UnresolvableArtifactProblem>(this.artifactProblems);
    }

    public UnresolvableArtifactProblem createUnresolvableArtifactProblem(Artifact artifact) {
        ImmutableList<List<DependencyNode>> paths = DependencyGraph.findArtifactPaths(this.root, artifact);
        if (paths.isEmpty()) {
            return new UnresolvableArtifactProblem(artifact);
        }
        return new UnresolvableArtifactProblem((List)paths.get(0));
    }

    private static ImmutableList<List<DependencyNode>> findArtifactPaths(DependencyNode root, Artifact artifact) {
        String coordinates = Artifacts.toCoordinates(artifact);
        DependencyFilter filter = (node, parents) -> node.getArtifact() != null && Artifacts.toCoordinates(node.getArtifact()).equals(coordinates);
        UniquePathRecordingDependencyVisitor visitor = new UniquePathRecordingDependencyVisitor(filter);
        root.accept((DependencyVisitor)visitor);
        return ImmutableList.copyOf(visitor.getPaths());
    }

    void addUnresolvableArtifactProblem(Artifact artifact) {
        if (this.checkedArtifacts.add(artifact)) {
            this.artifactProblems.add(this.createUnresolvableArtifactProblem(artifact));
        }
    }

    public static DependencyGraph from(DependencyNode root) {
        DependencyGraph graph = new DependencyGraph(root);
        DependencyGraph.levelOrder(graph);
        return graph;
    }

    private static void levelOrder(DependencyGraph graph) {
        ArrayDeque<LevelOrderQueueItem> queue = new ArrayDeque<LevelOrderQueueItem>();
        queue.add(new LevelOrderQueueItem(graph.root, null));
        while (!queue.isEmpty()) {
            LevelOrderQueueItem item = (LevelOrderQueueItem)queue.poll();
            DependencyNode dependencyNode = item.dependencyNode;
            DependencyPath parentPath = item.parentPath;
            Artifact artifact = dependencyNode.getArtifact();
            if (artifact != null && parentPath != null) {
                String groupIdAndArtifactId = Artifacts.makeKey(artifact);
                boolean ancestorHasSameKey = parentPath.getArtifacts().stream().map(Artifacts::makeKey).anyMatch(key -> key.equals(groupIdAndArtifactId));
                if (ancestorHasSameKey) continue;
            }
            DependencyPath path = parentPath == null ? new DependencyPath(artifact) : parentPath.append(dependencyNode.getDependency());
            graph.addPath(path);
            for (DependencyNode child : dependencyNode.getChildren()) {
                queue.add(new LevelOrderQueueItem(child, path));
            }
        }
    }

    private static final class LevelOrderQueueItem {
        final DependencyNode dependencyNode;
        final DependencyPath parentPath;

        LevelOrderQueueItem(DependencyNode dependencyNode, DependencyPath parentPath) {
            this.dependencyNode = dependencyNode;
            this.parentPath = parentPath;
        }
    }
}

