/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.opensource.dependencies;

import com.google.cloud.tools.opensource.dependencies.Artifacts;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.Dependency;

public final class DependencyPath {
    private final Artifact root;
    private final List<Dependency> path = new ArrayList<Dependency>();

    public DependencyPath(@Nullable Artifact root) {
        this.root = root;
    }

    @VisibleForTesting
    public DependencyPath append(Dependency dependency) {
        DependencyPath copy = new DependencyPath(this.root);
        copy.path.addAll(this.path);
        copy.path.add(dependency);
        return copy;
    }

    public int size() {
        return this.path.size() + 1;
    }

    public Artifact getLeaf() {
        if (this.path.isEmpty()) {
            return this.root;
        }
        return this.path.get(this.path.size() - 1).getArtifact();
    }

    public ImmutableList<Artifact> getArtifacts() {
        ImmutableList.Builder builder = ImmutableList.builder();
        if (this.root != null) {
            builder.add((Object)this.root);
        }
        this.path.stream().map(Dependency::getArtifact).forEach(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        return builder.build();
    }

    public Artifact get(int i) {
        if (i == 0) {
            return this.root;
        }
        return this.path.get(i - 1).getArtifact();
    }

    DependencyPath getParentPath() {
        DependencyPath parent = new DependencyPath(this.root);
        for (int i = 0; i < this.path.size() - 1; ++i) {
            parent.path.add(this.path.get(i));
        }
        return parent;
    }

    public String toString() {
        List formatted = this.path.stream().map(DependencyPath::formatDependency).collect(Collectors.toList());
        StringBuilder builder = new StringBuilder();
        if (this.root != null) {
            builder.append(this.root);
            if (!this.path.isEmpty()) {
                builder.append(" / ");
            }
        }
        builder.append(Joiner.on((String)" / ").join(formatted));
        return builder.toString();
    }

    private static String formatDependency(Dependency dependency) {
        String scopeAndOptional = dependency.getScope() + (dependency.isOptional() ? ", optional" : "");
        String coordinates = Artifacts.toCoordinates(dependency.getArtifact());
        return String.format("%s (%s)", coordinates, scopeAndOptional);
    }

    public boolean equals(Object o) {
        if (!(o instanceof DependencyPath)) {
            return false;
        }
        DependencyPath other = (DependencyPath)o;
        if (!Objects.equals(other.root, this.root)) {
            return false;
        }
        if (other.path.size() != this.path.size()) {
            return false;
        }
        for (int i = 0; i < this.path.size(); ++i) {
            Dependency thisNode = this.path.get(i);
            Dependency otherNode = other.path.get(i);
            if (!DependencyPath.artifactsEqual(thisNode.getArtifact(), otherNode.getArtifact())) {
                return false;
            }
            if (!thisNode.getScope().equals(otherNode.getScope())) {
                return false;
            }
            if (thisNode.isOptional() == otherNode.isOptional()) continue;
            return false;
        }
        return true;
    }

    private static boolean artifactsEqual(Artifact artifact1, Artifact artifact2) {
        return artifact1.getArtifactId().equals(artifact2.getArtifactId()) && artifact1.getGroupId().equals(artifact2.getGroupId()) && artifact1.getVersion().equals(artifact2.getVersion());
    }

    public int hashCode() {
        int hashCode = 31;
        for (Dependency node : this.path) {
            Artifact artifact = node.getArtifact();
            hashCode = 37 * hashCode + Objects.hash(this.root, artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), node.getScope(), node.isOptional());
        }
        return hashCode;
    }
}

