/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.opensource.dependencies;

import com.google.cloud.tools.opensource.dependencies.Artifacts;
import java.util.Objects;
import org.eclipse.aether.artifact.Artifact;

public class Update {
    private final Artifact parent;
    private final Artifact from;
    private final Artifact to;

    private Update(Artifact parent, Artifact from, Artifact to) {
        this.parent = parent;
        this.from = from;
        this.to = to;
    }

    public String toString() {
        return Artifacts.toCoordinates(this.parent) + " needs to upgrade " + Artifacts.toCoordinates(this.from) + " to " + this.to.getVersion();
    }

    public int hashCode() {
        return Objects.hash(this.parent, this.from, this.to);
    }

    public boolean equals(Object o) {
        if (o instanceof Update) {
            Update other = (Update)o;
            return Objects.equals(other.from, this.from) && Objects.equals(other.to, this.to) && Objects.equals(other.parent, this.parent);
        }
        return false;
    }

    static Builder builder() {
        return new Builder();
    }

    static class Builder {
        private Artifact parent;
        private Artifact from;
        private Artifact to;

        Builder() {
        }

        Builder setParent(Artifact parent) {
            this.parent = parent;
            return this;
        }

        Builder setFrom(Artifact from) {
            this.from = from;
            return this;
        }

        Builder setTo(Artifact to) {
            this.to = to;
            return this;
        }

        Update build() {
            return new Update(this.parent, this.from, this.to);
        }
    }
}

