/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.opensource.classpath;

import com.google.cloud.tools.opensource.classpath.ClassFile;
import com.google.cloud.tools.opensource.classpath.ClassPathEntry;
import com.google.cloud.tools.opensource.classpath.ClassSymbol;
import com.google.cloud.tools.opensource.classpath.FieldSymbol;
import com.google.cloud.tools.opensource.classpath.FixedSizeClassPathRepository;
import com.google.cloud.tools.opensource.classpath.InterfaceSymbol;
import com.google.cloud.tools.opensource.classpath.LinkageCheckClassPath;
import com.google.cloud.tools.opensource.classpath.MethodSymbol;
import com.google.cloud.tools.opensource.classpath.SuperClassSymbol;
import com.google.cloud.tools.opensource.classpath.SymbolReferences;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.graph.Traverser;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.ClassFormatException;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantCP;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantFieldref;
import org.apache.bcel.classfile.ConstantInterfaceMethodref;
import org.apache.bcel.classfile.ConstantNameAndType;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.ExceptionTable;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.InnerClass;
import org.apache.bcel.classfile.InnerClasses;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.CPInstruction;
import org.apache.bcel.generic.ClassGen;
import org.apache.bcel.generic.CodeExceptionGen;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.Type;

class ClassDumper {
    private static final Logger logger = Logger.getLogger(ClassDumper.class.getName());
    private final ImmutableList<ClassPathEntry> inputClassPath;
    private final FixedSizeClassPathRepository classRepository;
    private final ClassLoader extensionClassLoader;
    private final ImmutableMap<String, ClassPathEntry> fileNameToClassPathEntry;
    private static final ImmutableSet<String> LINKAGE_ERRORS_CAUGHT_IN_SOURCE = ImmutableSet.of((Object)LinkageError.class.getName(), (Object)NoClassDefFoundError.class.getName(), (Object)ClassNotFoundException.class.getName());
    private static final ImmutableSet<String> NO_SUCH_METHOD_ERROR_CAUGHT_IN_SOURCE = ImmutableSet.of((Object)LinkageError.class.getName(), (Object)NoSuchMethodError.class.getName());
    private static final Traverser<JavaClass> SUPERCLASSES = Traverser.forTree(javaClass -> {
        try {
            JavaClass superClass = javaClass.getSuperClass();
            return superClass == null ? ImmutableSet.of() : ImmutableSet.of((Object)superClass);
        }
        catch (ClassNotFoundException e) {
            return ImmutableSet.of();
        }
    });

    private static FixedSizeClassPathRepository createClassRepository(List<ClassPathEntry> entries) {
        LinkageCheckClassPath classPath = new LinkageCheckClassPath(entries);
        return new FixedSizeClassPathRepository(classPath);
    }

    static ClassDumper create(List<ClassPathEntry> entries) throws IOException {
        ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();
        ClassLoader extensionClassLoader = systemClassLoader.getParent();
        ImmutableList unreadableFiles = (ImmutableList)entries.stream().map(ClassPathEntry::getJar).filter(jar -> !Files.isRegularFile(jar, new LinkOption[0]) || !Files.isReadable(jar)).collect(ImmutableList.toImmutableList());
        Preconditions.checkArgument((boolean)unreadableFiles.isEmpty(), (String)"Some jar files are not readable: %s", (Object)unreadableFiles);
        HashMap<String, ClassPathEntry> map = new HashMap<String, ClassPathEntry>();
        for (ClassPathEntry entry : entries) {
            for (String className : entry.getFileNames()) {
                if (map.containsKey(className)) continue;
                map.put(className, entry);
            }
        }
        return new ClassDumper(entries, extensionClassLoader, map);
    }

    private ClassDumper(List<ClassPathEntry> inputClassPath, ClassLoader extensionClassLoader, Map<String, ClassPathEntry> fileNameToClassPathEntry) throws IOException {
        this.inputClassPath = ImmutableList.copyOf(inputClassPath);
        this.classRepository = ClassDumper.createClassRepository(inputClassPath);
        this.extensionClassLoader = extensionClassLoader;
        this.fileNameToClassPathEntry = ImmutableMap.copyOf(fileNameToClassPathEntry);
    }

    JavaClass loadJavaClass(String className) throws ClassNotFoundException {
        return this.classRepository.loadClass(className);
    }

    boolean isSystemClass(String className) {
        try {
            if (ClassDumper.isArrayClass(className)) {
                return true;
            }
            this.extensionClassLoader.loadClass(className);
            return true;
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
    }

    static boolean isArrayClass(String className) {
        return className.startsWith("[");
    }

    SymbolReferences findSymbolReferences() throws IOException {
        SymbolReferences.Builder builder = new SymbolReferences.Builder();
        for (ClassPathEntry jar : this.inputClassPath) {
            for (JavaClass javaClass : this.listClasses(jar)) {
                if (!ClassDumper.isCompatibleClassFileVersion(javaClass)) continue;
                String className = javaClass.getClassName();
                ClassFile source = new ClassFile(this.findClassLocation(className), className);
                builder.addAll(ClassDumper.findSymbolReferences(source, javaClass));
            }
        }
        return builder.build();
    }

    private static boolean isCompatibleClassFileVersion(JavaClass javaClass) {
        int classFileMajorVersion = javaClass.getMajor();
        return 45 <= classFileMajorVersion && classFileMajorVersion <= 52;
    }

    private static SymbolReferences.Builder findSymbolReferences(ClassFile source, JavaClass javaClass) {
        Constant[] constants;
        SymbolReferences.Builder builder = new SymbolReferences.Builder();
        ConstantPool constantPool = javaClass.getConstantPool();
        block5: for (Constant constant : constants = constantPool.getConstantPool()) {
            if (constant == null) continue;
            byte constantTag = constant.getTag();
            switch (constantTag) {
                case 7: {
                    ConstantClass constantClass = (ConstantClass)constant;
                    ClassSymbol classSymbol = ClassDumper.makeSymbol(constantClass, constantPool, javaClass);
                    if (classSymbol.getClassBinaryName().startsWith("[")) continue block5;
                    builder.addClassReference(source, classSymbol);
                    continue block5;
                }
                case 10: 
                case 11: {
                    ConstantCP constantMethodref = (ConstantCP)constant;
                    builder.addMethodReference(source, ClassDumper.makeSymbol(constantMethodref, constantPool));
                    continue block5;
                }
                case 9: {
                    ConstantFieldref constantFieldref = (ConstantFieldref)constant;
                    builder.addFieldReference(source, ClassDumper.makeSymbol(constantFieldref, constantPool));
                    continue block5;
                }
            }
        }
        for (String string : javaClass.getInterfaceNames()) {
            builder.addClassReference(source, new InterfaceSymbol(string));
        }
        return builder;
    }

    private static ConstantNameAndType constantNameAndType(ConstantCP constantCP, ConstantPool constantPool) {
        int nameAndTypeIndex = constantCP.getNameAndTypeIndex();
        Constant constantAtNameAndTypeIndex = constantPool.getConstant(nameAndTypeIndex);
        if (!(constantAtNameAndTypeIndex instanceof ConstantNameAndType)) {
            throw new ClassFormatException("Failed to lookup nameAndType constant indexed at " + nameAndTypeIndex + ". However, the content is not ConstantNameAndType. It is " + constantAtNameAndTypeIndex);
        }
        return (ConstantNameAndType)constantAtNameAndTypeIndex;
    }

    private static ClassSymbol makeSymbol(ConstantClass constantClass, ConstantPool constantPool, JavaClass sourceClass) {
        int nameIndex = constantClass.getNameIndex();
        Constant classNameConstant = constantPool.getConstant(nameIndex);
        if (!(classNameConstant instanceof ConstantUtf8)) {
            throw new ClassFormatException("Failed to lookup ConstantUtf8 constant indexed at " + nameIndex + ". However, the content is not ConstantUtf8. It is " + classNameConstant);
        }
        ConstantUtf8 classNameConstantUtf8 = (ConstantUtf8)classNameConstant;
        String targetClassNameInternalForm = classNameConstantUtf8.getBytes();
        String targetClassName = targetClassNameInternalForm.replace('/', '.');
        String superClassName = sourceClass.getSuperclassName();
        boolean referenceIsForInheritance = superClassName.equals(targetClassName);
        if (referenceIsForInheritance) {
            return new SuperClassSymbol(targetClassName);
        }
        return new ClassSymbol(targetClassName);
    }

    private static MethodSymbol makeSymbol(ConstantCP constantMethodref, ConstantPool constantPool) {
        String className = constantMethodref.getClass(constantPool);
        ConstantNameAndType constantNameAndType = ClassDumper.constantNameAndType(constantMethodref, constantPool);
        String methodName = constantNameAndType.getName(constantPool);
        String descriptor = constantNameAndType.getSignature(constantPool);
        boolean isInterfaceMethod = constantMethodref instanceof ConstantInterfaceMethodref;
        return new MethodSymbol(className, methodName, descriptor, isInterfaceMethod);
    }

    private static FieldSymbol makeSymbol(ConstantFieldref constantFieldref, ConstantPool constantPool) {
        String className = constantFieldref.getClass(constantPool);
        ConstantNameAndType constantNameAndType = ClassDumper.constantNameAndType((ConstantCP)constantFieldref, constantPool);
        String fieldName = constantNameAndType.getName(constantPool);
        String descriptor = constantNameAndType.getSignature(constantPool);
        return new FieldSymbol(className, fieldName, descriptor);
    }

    static ImmutableSet<String> listInnerClassNames(JavaClass javaClass) {
        ImmutableSet.Builder innerClassNames = ImmutableSet.builder();
        String topLevelClassName = javaClass.getClassName();
        ConstantPool constantPool = javaClass.getConstantPool();
        for (Attribute attribute : javaClass.getAttributes()) {
            if (attribute.getTag() != 6) continue;
            InnerClasses innerClasses = (InnerClasses)attribute;
            for (InnerClass innerClass : innerClasses.getInnerClasses()) {
                String outerClassName;
                String normalOuterClassName;
                int classIndex = innerClass.getInnerClassIndex();
                String innerClassName = constantPool.getConstantString(classIndex, (byte)7);
                int outerClassIndex = innerClass.getOuterClassIndex();
                if (outerClassIndex > 0 && !(normalOuterClassName = (outerClassName = constantPool.getConstantString(outerClassIndex, (byte)7)).replace('/', '.')).equals(topLevelClassName)) continue;
                String normalInnerClassName = innerClassName.replace('/', '.');
                innerClassNames.add((Object)normalInnerClassName);
            }
        }
        return innerClassNames.build();
    }

    @Nullable
    ClassPathEntry findClassLocation(String className) {
        String filename = this.classRepository.getFileName(className);
        return (ClassPathEntry)this.fileNameToClassPathEntry.get((Object)filename);
    }

    String getFileName(String className) {
        return this.classRepository.getFileName(className);
    }

    private ImmutableSet<JavaClass> listClasses(ClassPathEntry entry) throws IOException {
        ImmutableSet.Builder javaClasses = ImmutableSet.builder();
        ImmutableList.Builder corruptedClassFileNames = ImmutableList.builder();
        for (String classFileName : entry.getFileNames()) {
            if (classFileName.startsWith("META-INF.versions.")) continue;
            try {
                JavaClass javaClass = this.classRepository.loadClass(classFileName);
                javaClasses.add((Object)javaClass);
            }
            catch (ClassNotFoundException | ClassFormatException ex) {
                corruptedClassFileNames.add((Object)classFileName);
            }
        }
        ImmutableList corruptedFiles = corruptedClassFileNames.build();
        int corruptedFileCount = corruptedFiles.size();
        if (corruptedFileCount > 0) {
            logger.warning("Corrupt files in " + entry + "; could not load " + (String)corruptedFiles.get(0) + (corruptedFileCount > 1 ? " and other " + (corruptedFileCount - 1) + " files" : ""));
        }
        return javaClasses.build();
    }

    static boolean classesInSamePackage(String classNameA, String classNameB) {
        int lastDotIndexA = Math.max(classNameA.lastIndexOf(46), 0);
        int lastDotIndexB = Math.max(classNameB.lastIndexOf(46), 0);
        String packageNameA = classNameA.substring(0, lastDotIndexA);
        String packageNameB = classNameB.substring(0, lastDotIndexB);
        return packageNameA.equals(packageNameB);
    }

    static boolean isClassSubClassOf(JavaClass childClass, JavaClass parentClass) {
        for (JavaClass superClass : ClassDumper.getClassHierarchy(childClass)) {
            if (!superClass.equals((Object)parentClass)) continue;
            return true;
        }
        return false;
    }

    static String enclosingClassName(String className) {
        int lastDollarIndex = className.lastIndexOf(36);
        if (lastDollarIndex < 0) {
            return null;
        }
        return className.substring(0, lastDollarIndex);
    }

    static boolean hasValidSuperclass(JavaClass childJavaClass, JavaClass parentJavaClass) {
        if (parentJavaClass.isFinal()) {
            return false;
        }
        for (Method method : childJavaClass.getMethods()) {
            for (JavaClass parentClass : ClassDumper.getClassHierarchy(parentJavaClass)) {
                for (Method methodInParent : parentClass.getMethods()) {
                    if (!methodInParent.getName().equals(method.getName()) || !methodInParent.getSignature().equals(method.getSignature()) || !methodInParent.isFinal()) continue;
                    return false;
                }
            }
        }
        return true;
    }

    ImmutableSet<Integer> constantPoolIndexForClass(JavaClass sourceJavaClass, String targetClassName) {
        ImmutableSet.Builder constantPoolIndicesForTarget = ImmutableSet.builder();
        ConstantPool sourceConstantPool = sourceJavaClass.getConstantPool();
        Constant[] constantPool = sourceConstantPool.getConstantPool();
        for (int poolIndex = 1; poolIndex < constantPool.length; ++poolIndex) {
            ConstantClass constantClass;
            ClassSymbol classSymbol;
            byte constantTag;
            Constant constant = constantPool[poolIndex];
            if (constant == null || (constantTag = constant.getTag()) != 7 || !targetClassName.equals((classSymbol = ClassDumper.makeSymbol(constantClass = (ConstantClass)constant, sourceConstantPool, sourceJavaClass)).getClassBinaryName())) continue;
            constantPoolIndicesForTarget.add((Object)poolIndex);
        }
        return constantPoolIndicesForTarget.build();
    }

    boolean catchesLinkageErrorOnClass(String sourceClassName) {
        return this.catchesLinkageError(sourceClassName, (Set<String>)LINKAGE_ERRORS_CAUGHT_IN_SOURCE);
    }

    boolean catchesLinkageErrorOnMethod(String sourceClassName) {
        return this.catchesLinkageError(sourceClassName, (Set<String>)NO_SUCH_METHOD_ERROR_CAUGHT_IN_SOURCE);
    }

    private boolean catchesLinkageError(String sourceClassName, Set<String> errorNames) {
        try {
            JavaClass sourceJavaClass = this.loadJavaClass(sourceClassName);
            ClassGen classGen = new ClassGen(sourceJavaClass);
            for (Method method : sourceJavaClass.getMethods()) {
                CodeExceptionGen[] exceptionHandlers;
                if (method.getCode() == null) continue;
                MethodGen methodGen = new MethodGen(method, sourceClassName, classGen.getConstantPool());
                for (CodeExceptionGen codeExceptionGen : exceptionHandlers = methodGen.getExceptionHandlers()) {
                    String caughtClassName;
                    ObjectType catchType = codeExceptionGen.getCatchType();
                    if (catchType == null || !errorNames.contains(caughtClassName = catchType.getClassName())) continue;
                    return true;
                }
            }
            String outerClassName = ClassDumper.outerClassName(sourceJavaClass);
            if (outerClassName != null) {
                try {
                    return this.catchesLinkageError(outerClassName, errorNames);
                }
                catch (ClassFormatException ex) {
                    return false;
                }
            }
            return false;
        }
        catch (ClassNotFoundException ex) {
            throw new ClassFormatException("The source class in the reference is no longer available in the class path", (Throwable)ex);
        }
    }

    private static String outerClassName(JavaClass sourceJavaClass) {
        ConstantPool constantPool = sourceJavaClass.getConstantPool();
        if (sourceJavaClass.isNested()) {
            for (Attribute attribute : sourceJavaClass.getAttributes()) {
                if (!(attribute instanceof InnerClasses)) continue;
                InnerClasses innerClasses = (InnerClasses)attribute;
                for (InnerClass innerClass : innerClasses.getInnerClasses()) {
                    if (innerClass.getInnerClassIndex() <= 0 || innerClass.getOuterClassIndex() <= 0) continue;
                    String innerClassName = constantPool.getConstantString(innerClass.getInnerClassIndex(), (byte)7).replaceAll("/", ".");
                    String outerClassName = constantPool.getConstantString(innerClass.getOuterClassIndex(), (byte)7).replaceAll("/", ".");
                    if (!innerClassName.equals(sourceJavaClass.getClassName())) continue;
                    return outerClassName;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    boolean isUnusedClassSymbolReference(String sourceClassName, ClassSymbol classSymbol) {
        if (classSymbol instanceof SuperClassSymbol) {
            return false;
        }
        String targetClassName = classSymbol.getClassBinaryName();
        try {
            void var11_22;
            Constant[] constantPool;
            JavaClass sourceJavaClass = this.loadJavaClass(sourceClassName);
            for (String string : sourceJavaClass.getInterfaceNames()) {
                if (!string.equals(targetClassName)) continue;
                return false;
            }
            ImmutableSet<Integer> targetConstantPoolIndices = this.constantPoolIndexForClass(sourceJavaClass, targetClassName);
            Verify.verify((!targetConstantPoolIndices.isEmpty() ? 1 : 0) != 0, (String)"When checking a class reference from %s to %s, the reference to the target class is no longer found in the source class's constant pool.", (Object)sourceJavaClass.getClassName(), (Object)targetClassName);
            ConstantPool sourceConstantPool = sourceJavaClass.getConstantPool();
            block6: for (Constant constant : constantPool = sourceConstantPool.getConstantPool()) {
                if (constant == null) continue;
                switch (constant.getTag()) {
                    case 9: 
                    case 10: 
                    case 11: {
                        ConstantCP constantCp = (ConstantCP)constant;
                        int classIndex = constantCp.getClassIndex();
                        if (!targetConstantPoolIndices.contains((Object)classIndex)) continue block6;
                        return false;
                    }
                }
            }
            for (Field field : sourceJavaClass.getFields()) {
                String fieldTypeSignature = field.getType().toString();
                if (!targetClassName.equals(fieldTypeSignature)) continue;
                return false;
            }
            ClassGen classGen = new ClassGen(sourceJavaClass);
            Method[] methodArray = sourceJavaClass.getMethods();
            int n = methodArray.length;
            boolean bl = false;
            while (var11_22 < n) {
                CodeExceptionGen[] exceptionHandlers;
                ExceptionTable exceptionTable;
                Method method = methodArray[var11_22];
                if (targetClassName.equals(method.getReturnType().toString())) {
                    return false;
                }
                for (Type argumentType : method.getArgumentTypes()) {
                    String string = argumentType.toString();
                    if (!targetClassName.equals(string)) continue;
                    return false;
                }
                MethodGen methodGen = new MethodGen(method, sourceClassName, classGen.getConstantPool());
                InstructionList instructionList = methodGen.getInstructionList();
                if (instructionList != null) {
                    for (InstructionHandle instructionHandle : instructionList) {
                        int classIndex;
                        Instruction instruction = instructionHandle.getInstruction();
                        if (!(instruction instanceof CPInstruction) || !targetConstantPoolIndices.contains((Object)(classIndex = ((CPInstruction)instruction).getIndex()))) continue;
                        return false;
                    }
                }
                if ((exceptionTable = method.getExceptionTable()) != null) {
                    int[] exceptionIndexTable;
                    for (int exceptionIndexTableEntry : exceptionIndexTable = exceptionTable.getExceptionIndexTable()) {
                        if (!targetConstantPoolIndices.contains((Object)exceptionIndexTableEntry)) continue;
                        return false;
                    }
                }
                for (CodeExceptionGen codeExceptionGen : exceptionHandlers = methodGen.getExceptionHandlers()) {
                    String caughtClassName;
                    ObjectType catchType = codeExceptionGen.getCatchType();
                    if (catchType == null || (caughtClassName = catchType.getClassName()) == null || !caughtClassName.equals(targetClassName)) continue;
                    return false;
                }
                ++var11_22;
            }
        }
        catch (ClassNotFoundException ex) {
            throw new ClassFormatException("The source class in the reference is no longer available in the class path", (Throwable)ex);
        }
        return true;
    }

    static Iterable<JavaClass> getClassHierarchy(JavaClass targetClass) {
        return SUPERCLASSES.breadthFirst((Object)targetClass);
    }
}

