/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.opensource.classpath;

import com.google.cloud.tools.opensource.classpath.MissingDependency;
import com.google.cloud.tools.opensource.dependencies.Artifacts;
import com.google.cloud.tools.opensource.dependencies.DependencyPath;
import java.util.Objects;
import org.eclipse.aether.artifact.Artifact;

final class ExcludedDependency
extends MissingDependency {
    private Artifact excludingArtifact;

    ExcludedDependency(DependencyPath pathToMissingArtifact, Artifact excludingArtifact) {
        super(pathToMissingArtifact);
        this.excludingArtifact = excludingArtifact;
    }

    Artifact getExcludingArtifact() {
        return this.excludingArtifact;
    }

    @Override
    public String toString() {
        Artifact artifactContainingValidSymbol = this.pathToMissingArtifact.getLeaf();
        return "The valid symbol is in " + artifactContainingValidSymbol + " at " + this.pathToMissingArtifact + " but it was not selected because " + Artifacts.toCoordinates(this.excludingArtifact) + " excludes " + Artifacts.makeKey(artifactContainingValidSymbol) + ".";
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ExcludedDependency that = (ExcludedDependency)other;
        return Objects.equals(this.pathToMissingArtifact, that.pathToMissingArtifact) && Objects.equals(this.excludingArtifact, that.excludingArtifact);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.pathToMissingArtifact, this.excludingArtifact);
    }
}

