/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.opensource.classpath;

import com.google.cloud.tools.opensource.classpath.FieldSymbol;
import com.google.cloud.tools.opensource.classpath.LinkageProblemTargetMatcher;
import com.google.cloud.tools.opensource.classpath.Symbol;
import com.google.common.base.Preconditions;

class FieldMatcher
implements LinkageProblemTargetMatcher {
    private final String className;
    private final String fieldName;

    FieldMatcher(String className, String fieldName) {
        this.className = (String)Preconditions.checkNotNull((Object)className);
        this.fieldName = (String)Preconditions.checkNotNull((Object)fieldName);
    }

    @Override
    public boolean match(Symbol symbol) {
        if (symbol instanceof FieldSymbol) {
            FieldSymbol fieldSymbol = (FieldSymbol)symbol;
            return fieldSymbol.getClassBinaryName().equals(this.className) && fieldSymbol.getName().equals(this.fieldName);
        }
        return false;
    }
}

