/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.opensource.classpath;

import com.google.cloud.tools.opensource.classpath.AbstractMethodProblem;
import com.google.cloud.tools.opensource.classpath.ClassDumper;
import com.google.cloud.tools.opensource.classpath.ClassFile;
import com.google.cloud.tools.opensource.classpath.ClassNotFoundProblem;
import com.google.cloud.tools.opensource.classpath.ClassPathBuilder;
import com.google.cloud.tools.opensource.classpath.ClassPathEntry;
import com.google.cloud.tools.opensource.classpath.ClassPathResult;
import com.google.cloud.tools.opensource.classpath.ClassReferenceGraph;
import com.google.cloud.tools.opensource.classpath.ClassSymbol;
import com.google.cloud.tools.opensource.classpath.ExcludedErrors;
import com.google.cloud.tools.opensource.classpath.FieldSymbol;
import com.google.cloud.tools.opensource.classpath.InaccessibleClassProblem;
import com.google.cloud.tools.opensource.classpath.InaccessibleMemberProblem;
import com.google.cloud.tools.opensource.classpath.IncompatibleClassChangeProblem;
import com.google.cloud.tools.opensource.classpath.InterfaceSymbol;
import com.google.cloud.tools.opensource.classpath.LinkageProblem;
import com.google.cloud.tools.opensource.classpath.MethodSymbol;
import com.google.cloud.tools.opensource.classpath.ReturnTypeChangedProblem;
import com.google.cloud.tools.opensource.classpath.SuperClassSymbol;
import com.google.cloud.tools.opensource.classpath.SymbolNotFoundProblem;
import com.google.cloud.tools.opensource.classpath.SymbolReferences;
import com.google.cloud.tools.opensource.dependencies.Bom;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.FieldOrMethod;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Utility;
import org.eclipse.aether.artifact.Artifact;

public class LinkageChecker {
    private static final Logger logger = Logger.getLogger(LinkageChecker.class.getName());
    private final ClassDumper classDumper;
    private final ImmutableList<ClassPathEntry> classPath;
    private final SymbolReferences symbolReferences;
    private final ClassReferenceGraph classReferenceGraph;
    private final ExcludedErrors excludedErrors;

    @VisibleForTesting
    SymbolReferences getSymbolReferences() {
        return this.symbolReferences;
    }

    public ClassReferenceGraph getClassReferenceGraph() {
        return this.classReferenceGraph;
    }

    public static LinkageChecker create(List<ClassPathEntry> classPath) throws IOException {
        return LinkageChecker.create(classPath, (Iterable<ClassPathEntry>)ImmutableSet.copyOf(classPath), null);
    }

    public static LinkageChecker create(List<ClassPathEntry> classPath, Iterable<ClassPathEntry> entryPoints, @Nullable Path exclusionFile) throws IOException {
        Preconditions.checkArgument((!classPath.isEmpty() ? 1 : 0) != 0, (Object)"The linkage classpath is empty.");
        ClassDumper dumper = ClassDumper.create(classPath);
        SymbolReferences symbolReferenceMaps = dumper.findSymbolReferences();
        ClassReferenceGraph classReferenceGraph = ClassReferenceGraph.create(symbolReferenceMaps, (Set<ClassPathEntry>)ImmutableSet.copyOf(entryPoints));
        return new LinkageChecker(dumper, classPath, symbolReferenceMaps, classReferenceGraph, ExcludedErrors.create(exclusionFile));
    }

    public static LinkageChecker create(Bom bom) throws IOException {
        return LinkageChecker.create(bom, null);
    }

    public static LinkageChecker create(Bom bom, Path exclusionFile) throws IOException {
        ImmutableList<Artifact> managedDependencies = bom.getManagedDependencies();
        ClassPathBuilder classPathBuilder = new ClassPathBuilder();
        ClassPathResult classPathResult = classPathBuilder.resolve((List<Artifact>)managedDependencies, true);
        ImmutableList<ClassPathEntry> classpath = classPathResult.getClassPath();
        ImmutableList artifactsInBom = classpath.subList(0, managedDependencies.size());
        ImmutableSet entryPoints = ImmutableSet.copyOf((Collection)artifactsInBom);
        return LinkageChecker.create(classpath, (Iterable<ClassPathEntry>)entryPoints, exclusionFile);
    }

    @VisibleForTesting
    LinkageChecker cloneWith(SymbolReferences newSymbolMaps) {
        return new LinkageChecker(this.classDumper, (List<ClassPathEntry>)this.classPath, newSymbolMaps, this.classReferenceGraph, this.excludedErrors);
    }

    private LinkageChecker(ClassDumper classDumper, List<ClassPathEntry> classPath, SymbolReferences symbolReferenceMaps, ClassReferenceGraph classReferenceGraph, ExcludedErrors excludedErrors) {
        this.classDumper = (ClassDumper)Preconditions.checkNotNull((Object)classDumper);
        this.classPath = ImmutableList.copyOf(classPath);
        this.classReferenceGraph = (ClassReferenceGraph)Preconditions.checkNotNull((Object)classReferenceGraph);
        this.symbolReferences = (SymbolReferences)Preconditions.checkNotNull((Object)symbolReferenceMaps);
        this.excludedErrors = (ExcludedErrors)Preconditions.checkNotNull((Object)excludedErrors);
    }

    public ImmutableSet<LinkageProblem> findLinkageProblems() throws IOException {
        ImmutableSet<String> classFileNames;
        String classBinaryName;
        String classFileName;
        ImmutableSet.Builder problemToClass = ImmutableSet.builder();
        for (ClassFile classFile : this.symbolReferences.getClassFiles()) {
            ImmutableSet<ClassSymbol> classSymbols = this.symbolReferences.getClassSymbols(classFile);
            for (ClassSymbol classSymbol : classSymbols) {
                ImmutableSet<String> classFileNames2;
                String superClassName;
                ClassPathEntry superClassLocation;
                if (classSymbol instanceof SuperClassSymbol && (superClassLocation = this.classDumper.findClassLocation(superClassName = classSymbol.getClassBinaryName())) != null) {
                    ClassFile superClassFile = new ClassFile(superClassLocation, superClassName);
                    ImmutableList<LinkageProblem> problems = this.findAbstractParentProblems(classFile, (SuperClassSymbol)classSymbol, superClassFile);
                    for (LinkageProblem problem : problems) {
                        problemToClass.add((Object)problem);
                    }
                }
                if ((classFileNames2 = classFile.getClassPathEntry().getFileNames()).contains((Object)(classFileName = this.classDumper.getFileName(classBinaryName = classSymbol.getClassBinaryName())))) continue;
                if (classSymbol instanceof InterfaceSymbol) {
                    String interfaceName = classSymbol.getClassBinaryName();
                    ClassPathEntry interfaceLocation = this.classDumper.findClassLocation(interfaceName);
                    if (interfaceLocation == null) continue;
                    ClassFile interfaceClassFile = new ClassFile(interfaceLocation, interfaceName);
                    ImmutableList<LinkageProblem> problems = this.findInterfaceProblems(interfaceClassFile, (InterfaceSymbol)classSymbol, classFile);
                    for (LinkageProblem problem : problems) {
                        problemToClass.add((Object)problem);
                    }
                    continue;
                }
                this.findLinkageProblem(classFile, classSymbol, classFile.topLevelClassFile()).ifPresent(arg_0 -> ((ImmutableSet.Builder)problemToClass).add(arg_0));
            }
        }
        for (ClassFile classFile : this.symbolReferences.getClassFiles()) {
            ImmutableSet<MethodSymbol> methodSymbols = this.symbolReferences.getMethodSymbols(classFile);
            classFileNames = classFile.getClassPathEntry().getFileNames();
            for (MethodSymbol methodSymbol : methodSymbols) {
                classBinaryName = methodSymbol.getClassBinaryName();
                classFileName = this.classDumper.getFileName(classBinaryName);
                if (classFileNames.contains((Object)classFileName)) continue;
                this.findLinkageProblem(classFile, methodSymbol, classFile.topLevelClassFile()).ifPresent(arg_0 -> ((ImmutableSet.Builder)problemToClass).add(arg_0));
            }
        }
        for (ClassFile classFile : this.symbolReferences.getClassFiles()) {
            ImmutableSet<FieldSymbol> fieldSymbols = this.symbolReferences.getFieldSymbols(classFile);
            classFileNames = classFile.getClassPathEntry().getFileNames();
            for (FieldSymbol fieldSymbol : fieldSymbols) {
                classBinaryName = fieldSymbol.getClassBinaryName();
                classFileName = this.classDumper.getFileName(classBinaryName);
                if (classFileNames.contains((Object)classFileName)) continue;
                this.findLinkageProblem(classFile, fieldSymbol, classFile.topLevelClassFile()).ifPresent(arg_0 -> ((ImmutableSet.Builder)problemToClass).add(arg_0));
            }
        }
        ImmutableSet filteredMap = (ImmutableSet)problemToClass.build().stream().filter(this::problemFilter).collect(ImmutableSet.toImmutableSet());
        return filteredMap;
    }

    private boolean problemFilter(LinkageProblem linkageProblem) {
        return !this.excludedErrors.contains(linkageProblem);
    }

    @VisibleForTesting
    Optional<LinkageProblem> findLinkageProblem(ClassFile classFile, MethodSymbol symbol, ClassFile sourceClassFile) {
        String sourceClassName = classFile.getBinaryName();
        String targetClassName = symbol.getClassBinaryName();
        String methodName = symbol.getName();
        if (ClassDumper.isArrayClass(targetClassName)) {
            return Optional.empty();
        }
        try {
            ClassFile targetClassFile;
            JavaClass targetJavaClass = this.classDumper.loadJavaClass(targetClassName);
            ClassPathEntry classPathEntry = this.classDumper.findClassLocation(targetClassName);
            ClassFile classFile2 = targetClassFile = classPathEntry == null ? null : new ClassFile(classPathEntry, targetClassName);
            if (!this.isClassAccessibleFrom(targetJavaClass, sourceClassName)) {
                return Optional.of(new InaccessibleClassProblem(sourceClassFile, targetClassFile, symbol));
            }
            if (targetJavaClass.isInterface() != symbol.isInterfaceMethod()) {
                return Optional.of(new IncompatibleClassChangeProblem(sourceClassFile, targetClassFile, symbol));
            }
            Optional<LinkageProblem> parentLinkageProblem = this.findParentClassLinkageProblem(targetClassName, sourceClassFile);
            if (parentLinkageProblem.isPresent()) {
                return parentLinkageProblem;
            }
            Iterable typesToCheck = Iterables.concat(ClassDumper.getClassHierarchy(targetJavaClass), Arrays.asList(targetJavaClass.getAllInterfaces()));
            String changedReturnType = null;
            for (JavaClass javaClass : typesToCheck) {
                for (Method method : javaClass.getMethods()) {
                    if (!method.getName().equals(methodName)) continue;
                    String expectedMethodDescriptor = symbol.getDescriptor();
                    String actualMethodDescriptor = method.getSignature();
                    if (actualMethodDescriptor.equals(expectedMethodDescriptor)) {
                        if (!this.isMemberAccessibleFrom(javaClass, (FieldOrMethod)method, sourceClassName)) {
                            return Optional.of(new InaccessibleMemberProblem(sourceClassFile, targetClassFile, symbol));
                        }
                        return Optional.empty();
                    }
                    String expectedParameterDescriptors = LinkageChecker.parseParameterDescriptors(expectedMethodDescriptor);
                    String actualParameterDescriptors = LinkageChecker.parseParameterDescriptors(actualMethodDescriptor);
                    if (!actualParameterDescriptors.equals(expectedParameterDescriptors)) continue;
                    changedReturnType = Utility.methodSignatureReturnType((String)actualMethodDescriptor);
                }
            }
            if (changedReturnType != null) {
                return Optional.of(new ReturnTypeChangedProblem(sourceClassFile, targetClassFile, symbol, changedReturnType));
            }
            if (this.classDumper.catchesLinkageErrorOnMethod(sourceClassName)) {
                return Optional.empty();
            }
            return Optional.of(new SymbolNotFoundProblem(sourceClassFile, targetClassFile, symbol));
        }
        catch (ClassNotFoundException ex) {
            if (this.classDumper.catchesLinkageErrorOnClass(sourceClassName)) {
                return Optional.empty();
            }
            ClassSymbol classSymbol = new ClassSymbol(symbol.getClassBinaryName());
            return Optional.of(new ClassNotFoundProblem(sourceClassFile, classSymbol));
        }
    }

    private static String parseParameterDescriptors(String methodDescriptor) {
        return methodDescriptor.substring(0, methodDescriptor.indexOf(41) + 1);
    }

    private ImmutableList<LinkageProblem> findInterfaceProblems(ClassFile interfaceClassFile, InterfaceSymbol interfaceSymbol, ClassFile implementationClassFile) {
        String interfaceName = interfaceSymbol.getClassBinaryName();
        if (this.classDumper.isSystemClass(interfaceName)) {
            return ImmutableList.of();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        try {
            JavaClass implementingClass = this.classDumper.loadJavaClass(implementationClassFile.getBinaryName());
            if (implementingClass.isAbstract()) {
                return ImmutableList.of();
            }
            JavaClass interfaceDefinition = this.classDumper.loadJavaClass(interfaceName);
            for (Method interfaceMethod : interfaceDefinition.getMethods()) {
                if (interfaceMethod.getCode() != null) continue;
                String interfaceMethodName = interfaceMethod.getName();
                String interfaceMethodDescriptor = interfaceMethod.getSignature();
                boolean methodFound = false;
                Iterable typesToCheck = Iterables.concat((Iterable[])new Iterable[]{ClassDumper.getClassHierarchy(implementingClass)});
                block3: for (JavaClass javaClass : typesToCheck) {
                    for (Method method : javaClass.getMethods()) {
                        if (!method.getName().equals(interfaceMethodName) || !method.getSignature().equals(interfaceMethodDescriptor)) continue;
                        methodFound = true;
                        continue block3;
                    }
                }
                if (methodFound) continue;
                MethodSymbol missingMethodOnClass = new MethodSymbol(interfaceClassFile.getBinaryName(), interfaceMethodName, interfaceMethodDescriptor, false);
                builder.add((Object)new AbstractMethodProblem(implementationClassFile, missingMethodOnClass, interfaceClassFile));
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return builder.build();
    }

    @VisibleForTesting
    Optional<LinkageProblem> findLinkageProblem(ClassFile classFile, FieldSymbol symbol, ClassFile sourceClassFile) {
        String sourceClassName = classFile.getBinaryName();
        String targetClassName = symbol.getClassBinaryName();
        String fieldName = symbol.getName();
        try {
            ClassFile targetClassFile;
            JavaClass targetJavaClass = this.classDumper.loadJavaClass(targetClassName);
            ClassPathEntry classFileLocation = this.classDumper.findClassLocation(targetClassName);
            ClassFile classFile2 = targetClassFile = classFileLocation == null ? null : new ClassFile(classFileLocation, targetClassName);
            if (!this.isClassAccessibleFrom(targetJavaClass, sourceClassName)) {
                return Optional.of(new InaccessibleClassProblem(sourceClassFile, targetClassFile, symbol));
            }
            for (JavaClass javaClass : ClassDumper.getClassHierarchy(targetJavaClass)) {
                for (Field field : javaClass.getFields()) {
                    if (!field.getName().equals(fieldName)) continue;
                    if (!this.isMemberAccessibleFrom(javaClass, (FieldOrMethod)field, sourceClassName)) {
                        return Optional.of(new InaccessibleMemberProblem(sourceClassFile, targetClassFile, symbol));
                    }
                    return Optional.empty();
                }
            }
            return Optional.of(new SymbolNotFoundProblem(sourceClassFile, targetClassFile, symbol));
        }
        catch (ClassNotFoundException ex) {
            if (this.classDumper.catchesLinkageErrorOnClass(sourceClassName)) {
                return Optional.empty();
            }
            ClassSymbol classSymbol = new ClassSymbol(symbol.getClassBinaryName());
            return Optional.of(new ClassNotFoundProblem(sourceClassFile, classSymbol));
        }
    }

    private boolean isMemberAccessibleFrom(JavaClass targetClass, FieldOrMethod member, String sourceClassName) {
        if (member.isPublic()) {
            return true;
        }
        if (member.isProtected()) {
            if (ClassDumper.classesInSamePackage(targetClass.getClassName(), sourceClassName)) {
                return true;
            }
            try {
                JavaClass sourceClass = this.classDumper.loadJavaClass(sourceClassName);
                if (ClassDumper.isClassSubClassOf(sourceClass, targetClass)) {
                    return true;
                }
            }
            catch (ClassNotFoundException ex) {
                logger.warning("The source class " + sourceClassName + " of a reference was not found in the class path when checking accessibility");
                return false;
            }
        }
        if (member.isPrivate()) {
            return false;
        }
        return ClassDumper.classesInSamePackage(targetClass.getClassName(), sourceClassName);
    }

    @VisibleForTesting
    Optional<LinkageProblem> findLinkageProblem(ClassFile classFile, ClassSymbol symbol, ClassFile sourceClassFile) {
        String sourceClassName = classFile.getBinaryName();
        String targetClassName = symbol.getClassBinaryName();
        try {
            JavaClass targetClass = this.classDumper.loadJavaClass(targetClassName);
            ClassPathEntry classFileLocation = this.classDumper.findClassLocation(targetClassName);
            ClassFile targetClassFile = classFileLocation == null ? null : new ClassFile(classFileLocation, targetClassName);
            boolean isSubclassReference = symbol instanceof SuperClassSymbol;
            if (isSubclassReference && !ClassDumper.hasValidSuperclass(this.classDumper.loadJavaClass(sourceClassName), targetClass)) {
                return Optional.of(new IncompatibleClassChangeProblem(sourceClassFile, targetClassFile, symbol));
            }
            if (!this.isClassAccessibleFrom(targetClass, sourceClassName)) {
                return Optional.of(new InaccessibleClassProblem(sourceClassFile, targetClassFile, symbol));
            }
            return Optional.empty();
        }
        catch (ClassNotFoundException ex) {
            if (this.classDumper.isUnusedClassSymbolReference(sourceClassName, symbol) || this.classDumper.catchesLinkageErrorOnClass(sourceClassName)) {
                return Optional.empty();
            }
            return Optional.of(new ClassNotFoundProblem(sourceClassFile, symbol));
        }
    }

    private boolean isClassAccessibleFrom(JavaClass javaClass, String sourceClassName) throws ClassNotFoundException {
        if (javaClass.isPrivate()) {
            return false;
        }
        String targetClassName = javaClass.getClassName();
        if (javaClass.isPublic() || ClassDumper.classesInSamePackage(targetClassName, sourceClassName)) {
            String enclosingClassName = ClassDumper.enclosingClassName(targetClassName);
            if (enclosingClassName != null) {
                JavaClass enclosingJavaClass = this.classDumper.loadJavaClass(enclosingClassName);
                return this.isClassAccessibleFrom(enclosingJavaClass, sourceClassName);
            }
            return true;
        }
        return false;
    }

    private Optional<LinkageProblem> findParentClassLinkageProblem(String baseClassName, ClassFile sourceClassFile) {
        ArrayDeque<String> queue = new ArrayDeque<String>();
        queue.add(baseClassName);
        while (!queue.isEmpty()) {
            String className = (String)queue.remove();
            if (Object.class.getName().equals(className)) continue;
            String potentiallyMissingClassName = className;
            try {
                JavaClass baseClass = this.classDumper.loadJavaClass(className);
                queue.add(baseClass.getSuperclassName());
                String[] stringArray = baseClass.getInterfaceNames();
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String interfaceName;
                    potentiallyMissingClassName = interfaceName = stringArray[i];
                    JavaClass interfaceClass = this.classDumper.loadJavaClass(interfaceName);
                    queue.addAll(Arrays.asList(interfaceClass.getInterfaceNames()));
                }
            }
            catch (ClassNotFoundException ex) {
                ClassNotFoundProblem problem = new ClassNotFoundProblem(sourceClassFile, new ClassSymbol(potentiallyMissingClassName));
                return Optional.of(problem);
            }
        }
        return Optional.empty();
    }

    private ImmutableList<LinkageProblem> findAbstractParentProblems(ClassFile classFile, SuperClassSymbol superClassSymbol, ClassFile superClassFile) {
        ImmutableList.Builder builder = ImmutableList.builder();
        String superClassName = superClassSymbol.getClassBinaryName();
        if (this.classDumper.isSystemClass(superClassName)) {
            return ImmutableList.of();
        }
        try {
            String className = classFile.getBinaryName();
            JavaClass implementingClass = this.classDumper.loadJavaClass(className);
            if (implementingClass.isAbstract()) {
                return ImmutableList.of();
            }
            JavaClass superClass = this.classDumper.loadJavaClass(superClassName);
            if (!superClass.isAbstract()) {
                return ImmutableList.of();
            }
            JavaClass abstractClass = superClass;
            HashSet<Method> implementedMethods = new HashSet<Method>();
            implementedMethods.addAll((Collection<Method>)ImmutableList.copyOf((Object[])implementingClass.getMethods()));
            while (abstractClass.isAbstract()) {
                for (Method abstractMethod : abstractClass.getMethods()) {
                    if (!abstractMethod.isAbstract()) {
                        implementedMethods.add(abstractMethod);
                        continue;
                    }
                    if (implementedMethods.contains(abstractMethod)) continue;
                    String unimplementedMethodName = abstractMethod.getName();
                    String unimplementedMethodDescriptor = abstractMethod.getSignature();
                    String abstractClassName = abstractClass.getClassName();
                    MethodSymbol missingMethodOnClass = new MethodSymbol(abstractClassName, unimplementedMethodName, unimplementedMethodDescriptor, false);
                    builder.add((Object)new AbstractMethodProblem(classFile, missingMethodOnClass, superClassFile));
                }
                abstractClass = abstractClass.getSuperClass();
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return builder.build();
    }
}

