/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.opensource.classpath;

import com.google.cloud.tools.opensource.classpath.ClassPathBuilder;
import com.google.cloud.tools.opensource.classpath.ClassPathEntry;
import com.google.cloud.tools.opensource.classpath.ClassPathResult;
import com.google.cloud.tools.opensource.classpath.ClassReferenceGraph;
import com.google.cloud.tools.opensource.classpath.ExclusionFiles;
import com.google.cloud.tools.opensource.classpath.LinkageCheckResultException;
import com.google.cloud.tools.opensource.classpath.LinkageChecker;
import com.google.cloud.tools.opensource.classpath.LinkageCheckerArguments;
import com.google.cloud.tools.opensource.classpath.LinkageProblem;
import com.google.cloud.tools.opensource.classpath.LinkageProblemCauseAnnotator;
import com.google.cloud.tools.opensource.dependencies.ArtifactProblem;
import com.google.cloud.tools.opensource.dependencies.DependencyGraphBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.TransformerException;
import org.apache.commons.cli.ParseException;
import org.eclipse.aether.RepositoryException;
import org.eclipse.aether.artifact.Artifact;

class LinkageCheckerMain {
    LinkageCheckerMain() {
    }

    public static void main(String[] arguments) throws IOException, RepositoryException, TransformerException, XMLStreamException, LinkageCheckResultException {
        try {
            LinkageCheckerArguments linkageCheckerArguments = LinkageCheckerArguments.readCommandLine(arguments);
            if (linkageCheckerArguments.needsHelp() || arguments.length == 0) {
                linkageCheckerArguments.printHelp();
            }
            if (linkageCheckerArguments.hasInput()) {
                ImmutableSet<LinkageProblem> linkageProblems;
                ImmutableList<Artifact> artifactsInArguments = linkageCheckerArguments.getArtifacts();
                ImmutableSet<LinkageProblem> immutableSet = linkageProblems = artifactsInArguments.isEmpty() ? LinkageCheckerMain.checkJarFiles(linkageCheckerArguments) : LinkageCheckerMain.checkArtifacts(linkageCheckerArguments);
                if (!linkageProblems.isEmpty()) {
                    System.out.println("For the details of the linkage errors, see https://github.com/GoogleCloudPlatform/cloud-opensource-java/wiki/Linkage-Checker-Messages");
                    throw new LinkageCheckResultException(linkageProblems.size());
                }
            }
        }
        catch (ParseException ex) {
            System.err.println(ex.getMessage());
        }
    }

    private static ImmutableSet<LinkageProblem> checkJarFiles(LinkageCheckerArguments linkageCheckerArguments) throws IOException, TransformerException, XMLStreamException {
        ImmutableSet entryPoints;
        ImmutableList<ClassPathEntry> inputClassPath = linkageCheckerArguments.getJarFiles();
        LinkageChecker linkageChecker = LinkageChecker.create(inputClassPath, (Iterable<ClassPathEntry>)(entryPoints = ImmutableSet.copyOf(inputClassPath)), linkageCheckerArguments.getInputExclusionFile());
        ImmutableSet<LinkageProblem> linkageProblems = LinkageCheckerMain.findLinkageProblems(linkageCheckerArguments, linkageChecker);
        if (!linkageProblems.isEmpty()) {
            System.out.println(LinkageProblem.formatLinkageProblems(linkageProblems, null));
        }
        return linkageProblems;
    }

    private static ImmutableSet<LinkageProblem> checkArtifacts(LinkageCheckerArguments linkageCheckerArguments) throws IOException, RepositoryException, TransformerException, XMLStreamException {
        ImmutableList<Artifact> artifactsInArguments = linkageCheckerArguments.getArtifacts();
        DependencyGraphBuilder dependencyGraphBuilder = new DependencyGraphBuilder((Iterable<String>)linkageCheckerArguments.getMavenRepositoryUrls());
        ClassPathBuilder classPathBuilder = new ClassPathBuilder(dependencyGraphBuilder);
        ClassPathResult classPathResult = classPathBuilder.resolve((List<Artifact>)artifactsInArguments, false);
        ImmutableList<ClassPathEntry> inputClassPath = classPathResult.getClassPath();
        ImmutableList artifactProblems = ImmutableList.copyOf(classPathResult.getArtifactProblems());
        ImmutableSet entryPoints = ImmutableSet.copyOf((Collection)inputClassPath.subList(0, artifactsInArguments.size()));
        LinkageChecker linkageChecker = LinkageChecker.create(inputClassPath, (Iterable<ClassPathEntry>)entryPoints, linkageCheckerArguments.getInputExclusionFile());
        ImmutableSet<LinkageProblem> linkageProblems = LinkageCheckerMain.findLinkageProblems(linkageCheckerArguments, linkageChecker);
        LinkageProblemCauseAnnotator.annotate(classPathBuilder, classPathResult, linkageProblems);
        if (!linkageProblems.isEmpty()) {
            System.out.println(LinkageProblem.formatLinkageProblems(linkageProblems, classPathResult));
        }
        if (!artifactProblems.isEmpty()) {
            System.out.println("\n");
            System.out.println(ArtifactProblem.formatProblems((Iterable<ArtifactProblem>)artifactProblems));
        }
        return linkageProblems;
    }

    private static ImmutableSet<LinkageProblem> findLinkageProblems(LinkageCheckerArguments linkageCheckerArguments, LinkageChecker linkageChecker) throws IOException, TransformerException, XMLStreamException {
        Path outputExclusionFile;
        ImmutableSet linkageProblems = linkageChecker.findLinkageProblems();
        if (linkageCheckerArguments.getReportOnlyReachable()) {
            ClassReferenceGraph graph = linkageChecker.getClassReferenceGraph();
            linkageProblems = (ImmutableSet)linkageProblems.stream().filter(problem -> graph.isReachable(problem.getSourceClass().getBinaryName())).collect(ImmutableSet.toImmutableSet());
        }
        if ((outputExclusionFile = linkageCheckerArguments.getOutputExclusionFile()) != null) {
            ExclusionFiles.write(outputExclusionFile, linkageProblems);
            System.out.println("Wrote the linkage errors as exclusion file: " + outputExclusionFile);
            return ImmutableSet.of();
        }
        return linkageProblems;
    }
}

