/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.opensource.dependencies;

import com.google.cloud.tools.opensource.classpath.ClassFile;
import com.google.cloud.tools.opensource.classpath.ClassPathBuilder;
import com.google.cloud.tools.opensource.classpath.ClassPathEntry;
import com.google.cloud.tools.opensource.classpath.ClassPathResult;
import com.google.cloud.tools.opensource.classpath.LinkageChecker;
import com.google.cloud.tools.opensource.classpath.LinkageProblem;
import com.google.cloud.tools.opensource.dependencies.Bom;
import com.google.cloud.tools.opensource.dependencies.MavenRepositoryException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.eclipse.aether.artifact.Artifact;

public class Java8IncompatibleReferenceCheck {
    private static final Logger logger = Logger.getLogger(Java8IncompatibleReferenceCheck.class.getName());

    public static void main(String[] arguments) throws MavenRepositoryException, IOException {
        if (arguments.length < 2) {
            System.err.println("Specify a path to the BOM file and a path to the exclusion rule");
            System.exit(1);
        }
        String bomFileName = arguments[0];
        Path exclusionFile = Paths.get(arguments[1], new String[0]).toAbsolutePath();
        Path bomFile = Paths.get(bomFileName, new String[0]);
        Bom bom = Bom.readBom(bomFile);
        ImmutableList<Artifact> managedDependencies = bom.getManagedDependencies();
        int count = 1;
        ImmutableSetMultimap.Builder problematicDependencies = ImmutableSetMultimap.builder();
        for (Artifact managedDependency : managedDependencies) {
            logger.info("Checking " + managedDependency + " (" + count++ + "/" + managedDependencies.size() + ")");
            ClassPathBuilder classPathBuilder = new ClassPathBuilder();
            ClassPathResult result = classPathBuilder.resolve((List<Artifact>)ImmutableList.of((Object)managedDependency), false);
            LinkageChecker linkageChecker = LinkageChecker.create(result.getClassPath(), result.getClassPath(), exclusionFile);
            ImmutableSet<LinkageProblem> linkageProblems = linkageChecker.findLinkageProblems();
            ImmutableSet invalidReferencesToJavaCoreLibrary = (ImmutableSet)linkageProblems.stream().filter(problem -> problem.getSymbol().getClassBinaryName().startsWith("java.")).collect(ImmutableSet.toImmutableSet());
            if (invalidReferencesToJavaCoreLibrary.isEmpty()) continue;
            invalidReferencesToJavaCoreLibrary.stream().map(LinkageProblem::getSourceClass).map(ClassFile::getClassPathEntry).map(ClassPathEntry::getArtifact).forEach(artifact -> problematicDependencies.put((Object)managedDependency, artifact));
            logger.severe(LinkageProblem.formatLinkageProblems((Set<LinkageProblem>)invalidReferencesToJavaCoreLibrary, null));
        }
        ImmutableSetMultimap bomMemberToProblematicDependencies = problematicDependencies.build();
        if (bomMemberToProblematicDependencies.isEmpty()) {
            logger.info("No problematic artifacts");
            return;
        }
        StringBuilder message = new StringBuilder();
        message.append("The following artifacts contain references to classes in the core library, which are not present in Java 8\n");
        for (Artifact artifact2 : bomMemberToProblematicDependencies.inverse().keySet()) {
            message.append("  " + artifact2 + "\n");
        }
        message.append("The following artifacts in the BOM contain the artifacts in their dependencies\n");
        for (Artifact bomMember : bomMemberToProblematicDependencies.keySet()) {
            ImmutableSet dependencies = bomMemberToProblematicDependencies.get((Object)bomMember);
            message.append("  " + bomMember + " due to " + dependencies + "\n");
        }
        logger.severe(message.toString());
        System.exit(1);
    }
}

