/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.opensource.dependencies;

import com.google.cloud.tools.opensource.dependencies.BanOptionalDependencySelector;
import com.google.cloud.tools.opensource.dependencies.CycleBreakerGraphTransformer;
import com.google.cloud.tools.opensource.dependencies.DirectProvidedDependencySelector;
import com.google.cloud.tools.opensource.dependencies.FilteringZipDependencySelector;
import com.google.cloud.tools.opensource.dependencies.MavenRepositoryException;
import com.google.cloud.tools.opensource.dependencies.OsProperties;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.execution.DefaultMavenExecutionRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.codehaus.plexus.ContainerConfiguration;
import org.codehaus.plexus.DefaultContainerConfiguration;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.PlexusContainerException;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.DependencyGraphTransformer;
import org.eclipse.aether.collection.DependencySelector;
import org.eclipse.aether.connector.basic.BasicRepositoryConnectorFactory;
import org.eclipse.aether.impl.DefaultServiceLocator;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.eclipse.aether.transport.file.FileTransporterFactory;
import org.eclipse.aether.transport.http.HttpTransporterFactory;
import org.eclipse.aether.util.graph.selector.AndDependencySelector;
import org.eclipse.aether.util.graph.selector.ExclusionDependencySelector;
import org.eclipse.aether.util.graph.selector.OptionalDependencySelector;
import org.eclipse.aether.util.graph.selector.ScopeDependencySelector;
import org.eclipse.aether.util.graph.transformer.ChainedDependencyGraphTransformer;
import org.eclipse.aether.util.graph.transformer.JavaDependencyContextRefiner;

public final class RepositoryUtility {
    public static final RemoteRepository CENTRAL = new RemoteRepository.Builder("central", "default", "https://repo1.maven.org/maven2/").build();
    private static final ImmutableSet<String> ALLOWED_REPOSITORY_URL_SCHEMES = ImmutableSet.of((Object)"file", (Object)"http", (Object)"https");

    private RepositoryUtility() {
    }

    public static RepositorySystem newRepositorySystem() {
        DefaultServiceLocator locator = MavenRepositorySystemUtils.newServiceLocator();
        locator.addService(RepositoryConnectorFactory.class, BasicRepositoryConnectorFactory.class);
        locator.addService(TransporterFactory.class, FileTransporterFactory.class);
        locator.addService(TransporterFactory.class, HttpTransporterFactory.class);
        return (RepositorySystem)locator.getService(RepositorySystem.class);
    }

    @VisibleForTesting
    static DefaultRepositorySystemSession createDefaultRepositorySystemSession(RepositorySystem system) {
        DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();
        LocalRepository localRepository = new LocalRepository(RepositoryUtility.findLocalRepository());
        session.setLocalRepositoryManager(system.newLocalRepositoryManager((RepositorySystemSession)session, localRepository));
        return session;
    }

    public static DefaultRepositorySystemSession newSession(RepositorySystem system) {
        DefaultRepositorySystemSession session = RepositoryUtility.createDefaultRepositorySystemSession(system);
        return session;
    }

    public static DefaultRepositorySystemSession newSessionForMaven(RepositorySystem system) {
        DefaultRepositorySystemSession session = RepositoryUtility.createDefaultRepositorySystemSession(system);
        AndDependencySelector dependencySelector = new AndDependencySelector(new DependencySelector[]{new ScopeDependencySelector(new String[]{"test"}), new OptionalDependencySelector(), new DirectProvidedDependencySelector(), new ExclusionDependencySelector(), new FilteringZipDependencySelector()});
        return session.setDependencySelector((DependencySelector)dependencySelector);
    }

    static DefaultRepositorySystemSession newSessionForFullDependency(RepositorySystem system) {
        AndDependencySelector dependencySelector = new AndDependencySelector(new DependencySelector[]{new ScopeDependencySelector(new String[]{"test"}), new ExclusionDependencySelector(), new FilteringZipDependencySelector()});
        return RepositoryUtility.newSession(system, (DependencySelector)dependencySelector);
    }

    private static DefaultRepositorySystemSession newSession(RepositorySystem system, DependencySelector dependencySelector) {
        DefaultRepositorySystemSession session = RepositoryUtility.createDefaultRepositorySystemSession(system);
        session.setDependencySelector(dependencySelector);
        session.setDependencyGraphTransformer((DependencyGraphTransformer)new ChainedDependencyGraphTransformer(new DependencyGraphTransformer[]{new CycleBreakerGraphTransformer(), new JavaDependencyContextRefiner()}));
        session.setDependencyManager(null);
        return session;
    }

    static DefaultRepositorySystemSession newSessionForVerboseDependency(RepositorySystem system) {
        AndDependencySelector dependencySelector = new AndDependencySelector(new DependencySelector[]{new ScopeDependencySelector(new String[]{"test"}), new OptionalDependencySelector(), new ExclusionDependencySelector(), new FilteringZipDependencySelector()});
        return RepositoryUtility.newSession(system, (DependencySelector)dependencySelector);
    }

    static DefaultRepositorySystemSession newSessionForVerboseListDependency(RepositorySystem system) {
        AndDependencySelector dependencySelector = new AndDependencySelector(new DependencySelector[]{new ScopeDependencySelector(new String[]{"test"}), new BanOptionalDependencySelector(), new ExclusionDependencySelector(), new FilteringZipDependencySelector()});
        return RepositoryUtility.newSession(system, (DependencySelector)dependencySelector);
    }

    private static String findLocalRepository() {
        Path home = Paths.get(System.getProperty("user.home"), new String[0]);
        Path localRepo = home.resolve(".m2").resolve("repository");
        if (Files.isDirectory(localRepo, new LinkOption[0])) {
            return localRepo.toAbsolutePath().toString();
        }
        return RepositoryUtility.makeTemporaryLocalRepository();
    }

    private static String makeTemporaryLocalRepository() {
        try {
            File temporaryDirectory = Files.createTempDirectory("m2", new FileAttribute[0]).toFile();
            temporaryDirectory.deleteOnExit();
            return temporaryDirectory.getAbsolutePath();
        }
        catch (IOException ex) {
            return null;
        }
    }

    static MavenProject createMavenProject(Path pomFile, RepositorySystemSession session) throws MavenRepositoryException {
        ClassWorld classWorld = new ClassWorld("plexus.core", Thread.currentThread().getContextClassLoader());
        ContainerConfiguration containerConfiguration = new DefaultContainerConfiguration().setClassWorld(classWorld).setRealm(classWorld.getClassRealm("plexus.core")).setClassPathScanning("index").setAutoWiring(true).setJSR250Lifecycle(true).setName("linkage-checker");
        try {
            DefaultPlexusContainer container = new DefaultPlexusContainer(containerConfiguration);
            DefaultMavenExecutionRequest mavenExecutionRequest = new DefaultMavenExecutionRequest();
            ProjectBuildingRequest projectBuildingRequest = mavenExecutionRequest.getProjectBuildingRequest();
            projectBuildingRequest.setRepositorySession(session);
            Properties properties = new Properties();
            properties.putAll((Map<?, ?>)projectBuildingRequest.getSystemProperties());
            properties.putAll((Map<?, ?>)OsProperties.detectOsProperties());
            properties.putAll((Map<?, ?>)System.getProperties());
            projectBuildingRequest.setSystemProperties(properties);
            ProjectBuilder projectBuilder = (ProjectBuilder)container.lookup(ProjectBuilder.class);
            ProjectBuildingResult projectBuildingResult = projectBuilder.build(pomFile.toFile(), projectBuildingRequest);
            return projectBuildingResult.getProject();
        }
        catch (ProjectBuildingException | PlexusContainerException | ComponentLookupException ex) {
            throw new MavenRepositoryException((Exception)ex);
        }
    }

    public static RemoteRepository mavenRepositoryFromUrl(String mavenRepositoryUrl) {
        try {
            new URI((String)Preconditions.checkNotNull((Object)mavenRepositoryUrl));
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException("Invalid URL syntax: " + mavenRepositoryUrl);
        }
        RemoteRepository repository = new RemoteRepository.Builder(null, "default", mavenRepositoryUrl).build();
        Preconditions.checkArgument((boolean)ALLOWED_REPOSITORY_URL_SCHEMES.contains((Object)repository.getProtocol()), (String)"Scheme: '%s' is not in %s", (Object)repository.getProtocol(), ALLOWED_REPOSITORY_URL_SCHEMES);
        return repository;
    }

    private static VersionRangeResult findVersionRange(RepositorySystem repositorySystem, RepositorySystemSession session, String groupId, String artifactId) throws MavenRepositoryException {
        DefaultArtifact artifactWithVersionRange = new DefaultArtifact(groupId, artifactId, null, "(0,]");
        VersionRangeRequest request = new VersionRangeRequest((Artifact)artifactWithVersionRange, (List)ImmutableList.of((Object)CENTRAL), null);
        try {
            return repositorySystem.resolveVersionRange(session, request);
        }
        catch (VersionRangeResolutionException ex) {
            throw new MavenRepositoryException((Exception)((Object)ex));
        }
    }

    @VisibleForTesting
    static String findHighestVersion(RepositorySystem repositorySystem, RepositorySystemSession session, String groupId, String artifactId) throws MavenRepositoryException {
        return RepositoryUtility.findVersionRange(repositorySystem, session, groupId, artifactId).getHighestVersion().toString();
    }

    public static ImmutableList<String> findVersions(RepositorySystem repositorySystem, String groupId, String artifactId) throws MavenRepositoryException {
        DefaultRepositorySystemSession session = RepositoryUtility.newSession(repositorySystem);
        return (ImmutableList)RepositoryUtility.findVersionRange(repositorySystem, (RepositorySystemSession)session, groupId, artifactId).getVersions().stream().map(version -> version.toString()).collect(ImmutableList.toImmutableList());
    }

    public static String findLatestCoordinates(RepositorySystem repositorySystem, String groupId, String artifactId) throws MavenRepositoryException {
        DefaultRepositorySystemSession session = RepositoryUtility.newSession(repositorySystem);
        String highestVersion = RepositoryUtility.findHighestVersion(repositorySystem, (RepositorySystemSession)session, groupId, artifactId);
        return String.format("%s:%s:%s", groupId, artifactId, highestVersion);
    }
}

