/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.opensource.dependencies;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.DependencyVisitor;

final class UniquePathRecordingDependencyVisitor
implements DependencyVisitor {
    private final DependencyFilter filter;
    private final List<List<DependencyNode>> paths;
    private final List<DependencyNode> parents;
    private final Set<DependencyNode> visited = Collections.newSetFromMap(new IdentityHashMap());

    public UniquePathRecordingDependencyVisitor(DependencyFilter filter) {
        this.filter = filter;
        this.paths = new ArrayList<List<DependencyNode>>();
        this.parents = new ArrayList<DependencyNode>();
    }

    public ImmutableList<List<DependencyNode>> getPaths() {
        return ImmutableList.copyOf(this.paths);
    }

    public boolean visitEnter(DependencyNode node) {
        this.parents.add(node);
        if (this.filter.accept(node, this.parents)) {
            this.paths.add(new ArrayList<DependencyNode>(this.parents));
            this.visited.add(node);
            return false;
        }
        return this.visited.add(node);
    }

    public boolean visitLeave(DependencyNode node) {
        this.parents.remove(this.parents.size() - 1);
        return true;
    }
}

