/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.opensource.dependencies;

import com.google.cloud.tools.opensource.dependencies.DependencyGraph;
import com.google.cloud.tools.opensource.dependencies.DependencyGraphBuilder;
import com.google.cloud.tools.opensource.dependencies.Update;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;

class UpdateReport {
    UpdateReport() {
    }

    public static void main(String[] args) {
        if (args.length != 1 || !args[0].contains(":")) {
            System.err.println("Usage: java " + UpdateReport.class.getCanonicalName() + " groupdId:artifactId:version");
            return;
        }
        try {
            DefaultArtifact artifact = new DefaultArtifact(args[0]);
            DependencyGraphBuilder dependencyGraphBuilder = new DependencyGraphBuilder();
            DependencyGraph graph = dependencyGraphBuilder.buildFullDependencyGraph((List<Artifact>)ImmutableList.of((Object)artifact));
            List<Update> updates = graph.findUpdates();
            if (updates.isEmpty()) {
                System.out.println(args[0] + " is consistent.");
                System.out.println();
            } else {
                System.out.println("Upgrades needed for " + args[0] + ":");
                System.out.println();
                for (Update update : updates) {
                    System.out.println(update);
                }
            }
        }
        catch (IllegalArgumentException ex) {
            System.err.println("Bad Maven coordinates " + args[0]);
            return;
        }
    }
}

