/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.opensource.classpath;

import com.google.cloud.tools.opensource.classpath.ClassPathEntry;
import com.google.cloud.tools.opensource.classpath.ClassPathResult;
import com.google.cloud.tools.opensource.classpath.MavenDependencyMediation;
import com.google.cloud.tools.opensource.dependencies.DependencyGraph;
import com.google.cloud.tools.opensource.dependencies.DependencyGraphBuilder;
import com.google.cloud.tools.opensource.dependencies.DependencyPath;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.List;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.Dependency;

public final class ClassPathBuilder {
    private final DependencyGraphBuilder dependencyGraphBuilder;

    public ClassPathBuilder() {
        this(new DependencyGraphBuilder());
    }

    public ClassPathBuilder(DependencyGraphBuilder dependencyGraphBuilder) {
        this.dependencyGraphBuilder = dependencyGraphBuilder;
    }

    public ClassPathResult resolve(List<Artifact> artifacts, boolean full) {
        DependencyGraph result = full ? this.dependencyGraphBuilder.buildFullDependencyGraph(artifacts) : this.dependencyGraphBuilder.buildVerboseDependencyGraph(artifacts);
        return this.mediate(result);
    }

    ClassPathResult resolveWithMaven(Artifact rootArtifact) {
        DependencyGraph result = this.dependencyGraphBuilder.buildMavenDependencyGraph(new Dependency(rootArtifact, "compile"));
        return this.mediate(result);
    }

    private ClassPathResult mediate(DependencyGraph result) {
        MavenDependencyMediation mediation = new MavenDependencyMediation();
        LinkedListMultimap multimap = LinkedListMultimap.create();
        List<DependencyPath> dependencyPaths = result.list();
        for (DependencyPath dependencyPath : dependencyPaths) {
            Artifact artifact = dependencyPath.getLeaf();
            mediation.put(dependencyPath);
            if (!mediation.selects(artifact)) continue;
            multimap.put((Object)new ClassPathEntry(artifact), (Object)dependencyPath);
        }
        return new ClassPathResult((ListMultimap<ClassPathEntry, DependencyPath>)multimap, result.getUnresolvedArtifacts());
    }
}

