/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.opensource.classpath;

import com.google.cloud.tools.opensource.dependencies.Artifacts;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Enumeration;
import java.util.Objects;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.eclipse.aether.artifact.Artifact;

public final class ClassPathEntry {
    private Path jar;
    private Artifact artifact;
    private ImmutableSet<String> fileNames;

    ClassPathEntry(Path jar) {
        this.jar = (Path)Preconditions.checkNotNull((Object)jar);
    }

    public ClassPathEntry(Artifact artifact) {
        this(artifact.getFile().toPath());
        this.artifact = artifact;
    }

    Path getJar() {
        return this.jar;
    }

    public Artifact getArtifact() {
        return this.artifact;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ClassPathEntry that = (ClassPathEntry)other;
        return Objects.equals(this.jar, that.jar) && Objects.equals(this.artifact, that.artifact);
    }

    public int hashCode() {
        return Objects.hash(this.jar, this.artifact);
    }

    public String toString() {
        if (this.artifact != null) {
            return Artifacts.toCoordinates(this.artifact);
        }
        return this.jar.toString();
    }

    private void readFileNames() throws IOException {
        try (JarFile jarFile = new JarFile(this.jar.toFile());){
            ImmutableSet.Builder builder = ImmutableSet.builder();
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String name = entry.getName();
                if (!name.endsWith(".class")) continue;
                String className = name.replace('/', '.').substring(0, name.length() - 6);
                builder.add((Object)className);
            }
            this.fileNames = builder.build();
        }
    }

    public synchronized ImmutableSet<String> getFileNames() throws IOException {
        if (this.fileNames == null) {
            this.readFileNames();
        }
        return this.fileNames;
    }
}

