/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.opensource.classpath;

import com.google.cloud.tools.opensource.classpath.LinkageProblemTargetMatcher;
import com.google.cloud.tools.opensource.classpath.MethodSymbol;
import com.google.cloud.tools.opensource.classpath.Symbol;
import com.google.common.base.Preconditions;

class MethodMatcher
implements LinkageProblemTargetMatcher {
    private final String className;
    private final String methodName;

    MethodMatcher(String className, String methodName) {
        this.className = (String)Preconditions.checkNotNull((Object)className);
        this.methodName = (String)Preconditions.checkNotNull((Object)methodName);
    }

    @Override
    public boolean match(Symbol symbol) {
        if (symbol instanceof MethodSymbol) {
            MethodSymbol methodSymbol = (MethodSymbol)symbol;
            return methodSymbol.getClassBinaryName().equals(this.className) && methodSymbol.getName().equals(this.methodName);
        }
        return false;
    }
}

