/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.opensource.classpath;

import com.google.cloud.tools.opensource.classpath.ClassFile;
import com.google.cloud.tools.opensource.classpath.ClassSymbol;
import com.google.cloud.tools.opensource.classpath.FieldSymbol;
import com.google.cloud.tools.opensource.classpath.MethodSymbol;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import java.util.Objects;

class SymbolReferences {
    private final ImmutableSetMultimap<ClassFile, ClassSymbol> classToClassSymbols;
    private final ImmutableSetMultimap<ClassFile, MethodSymbol> classToMethodSymbols;
    private final ImmutableSetMultimap<ClassFile, FieldSymbol> classToFieldSymbols;
    private final ImmutableSet<ClassFile> classFiles;

    ImmutableSet<MethodSymbol> getMethodSymbols(ClassFile classFile) {
        return this.classToMethodSymbols.get((Object)classFile);
    }

    ImmutableSet<ClassFile> getClassFiles() {
        return this.classFiles;
    }

    ImmutableSet<FieldSymbol> getFieldSymbols(ClassFile classFile) {
        return this.classToFieldSymbols.get((Object)classFile);
    }

    ImmutableSet<ClassSymbol> getClassSymbols(ClassFile classFile) {
        return this.classToClassSymbols.get((Object)classFile);
    }

    private SymbolReferences(ImmutableSet<ClassFile> classFiles, ImmutableSetMultimap<ClassFile, ClassSymbol> classToClassSymbols, ImmutableSetMultimap<ClassFile, MethodSymbol> classToMethodSymbols, ImmutableSetMultimap<ClassFile, FieldSymbol> classToFieldSymbols) {
        this.classToClassSymbols = (ImmutableSetMultimap)Preconditions.checkNotNull(classToClassSymbols);
        this.classToMethodSymbols = (ImmutableSetMultimap)Preconditions.checkNotNull(classToMethodSymbols);
        this.classToFieldSymbols = (ImmutableSetMultimap)Preconditions.checkNotNull(classToFieldSymbols);
        this.classFiles = (ImmutableSet)Preconditions.checkNotNull(classFiles);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        SymbolReferences that = (SymbolReferences)other;
        return this.classToClassSymbols.equals(that.classToClassSymbols) && this.classToMethodSymbols.equals(that.classToMethodSymbols) && this.classToFieldSymbols.equals(that.classToFieldSymbols);
    }

    public int hashCode() {
        return Objects.hash(this.classToClassSymbols, this.classToMethodSymbols, this.classToFieldSymbols);
    }

    static class Builder {
        private final ImmutableSetMultimap.Builder<ClassFile, ClassSymbol> classToClassSymbols;
        private final ImmutableSetMultimap.Builder<ClassFile, MethodSymbol> classToMethodSymbols;
        private final ImmutableSetMultimap.Builder<ClassFile, FieldSymbol> classToFieldSymbols;
        private final ImmutableSet.Builder<ClassFile> classFiles = ImmutableSet.builder();

        Builder() {
            this.classToClassSymbols = ImmutableSetMultimap.builder();
            this.classToMethodSymbols = ImmutableSetMultimap.builder();
            this.classToFieldSymbols = ImmutableSetMultimap.builder();
        }

        Builder addClassReference(ClassFile source, ClassSymbol symbol) {
            this.classToClassSymbols.put((Object)source, (Object)symbol);
            this.classFiles.add((Object)source);
            return this;
        }

        Builder addMethodReference(ClassFile source, MethodSymbol symbol) {
            this.classToMethodSymbols.put((Object)source, (Object)symbol);
            this.classFiles.add((Object)source);
            return this;
        }

        Builder addFieldReference(ClassFile source, FieldSymbol symbol) {
            this.classToFieldSymbols.put((Object)source, (Object)symbol);
            return this;
        }

        SymbolReferences build() {
            return new SymbolReferences(this.classFiles.build(), this.classToClassSymbols.build(), this.classToMethodSymbols.build(), this.classToFieldSymbols.build());
        }

        Builder addAll(Builder other) {
            this.classToClassSymbols.putAll((Multimap)other.classToClassSymbols.build());
            this.classToMethodSymbols.putAll((Multimap)other.classToMethodSymbols.build());
            this.classToFieldSymbols.putAll((Multimap)other.classToFieldSymbols.build());
            this.classFiles.addAll((Iterable)other.classFiles.build());
            return this;
        }
    }
}

