/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.opensource.classpath;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.util.ClassPath;
import org.apache.bcel.util.ClassPathRepository;
import org.apache.bcel.util.Repository;

final class FixedSizeClassPathRepository
extends ClassPathRepository {
    private final Cache<String, JavaClass> loadedClass;
    private final Map<String, String> classFileNames;

    FixedSizeClassPathRepository(ClassPath path) {
        this(path, 1000L);
    }

    @VisibleForTesting
    FixedSizeClassPathRepository(ClassPath path, long maximumSize) {
        super(path);
        this.loadedClass = CacheBuilder.newBuilder().maximumSize(maximumSize).build();
        this.classFileNames = new HashMap<String, String>();
    }

    public void storeClass(JavaClass javaClass) {
        String className = javaClass.getClassName();
        this.loadedClass.put((Object)className, (Object)javaClass);
        javaClass.setRepository((Repository)this);
        String fileName = javaClass.getFileName();
        if (!className.equals(fileName)) {
            this.classFileNames.put(className, fileName);
        }
    }

    @Nullable
    public JavaClass findClass(String className) {
        return (JavaClass)this.loadedClass.getIfPresent((Object)className);
    }

    public JavaClass loadClass(String className) throws ClassNotFoundException {
        String fileName = this.getFileName(className);
        return super.loadClass(fileName);
    }

    public void clear() {
        this.loadedClass.invalidateAll();
    }

    String getFileName(String className) {
        return this.classFileNames.getOrDefault(className, className);
    }
}

