/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.opensource.classpath;

import com.google.cloud.tools.opensource.classpath.ClassPathEntry;
import com.google.cloud.tools.opensource.dependencies.Bom;
import com.google.cloud.tools.opensource.dependencies.RepositoryUtility;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.eclipse.aether.RepositoryException;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;

final class LinkageCheckerArguments {
    private static final Options options = LinkageCheckerArguments.configureOptions();
    private static final HelpFormatter helpFormatter = new HelpFormatter();
    private final CommandLine commandLine;
    private final ImmutableList<String> extraMavenRepositoryUrls;
    private final boolean addMavenCentral;
    private final boolean reportOnlyReachable;
    private final boolean help;
    private ImmutableList<Artifact> cachedArtifacts;

    private LinkageCheckerArguments(CommandLine commandLine) {
        this.commandLine = commandLine;
        this.extraMavenRepositoryUrls = commandLine.hasOption("m") ? ImmutableList.copyOf((Object[])commandLine.getOptionValues("m")) : ImmutableList.of();
        this.extraMavenRepositoryUrls.forEach(RepositoryUtility::mavenRepositoryFromUrl);
        this.addMavenCentral = !commandLine.hasOption("nm");
        this.reportOnlyReachable = commandLine.hasOption("r");
        this.help = commandLine.hasOption("h");
    }

    static LinkageCheckerArguments readCommandLine(String ... arguments) throws ParseException {
        DefaultParser parser = new DefaultParser();
        try {
            CommandLine commandLine = parser.parse(options, arguments);
            return new LinkageCheckerArguments(commandLine);
        }
        catch (IllegalArgumentException ex) {
            throw new ParseException("Invalid URL syntax in Maven repository URL" + ex.getMessage());
        }
    }

    private static Options configureOptions() {
        Options options = new Options();
        OptionGroup inputGroup = new OptionGroup();
        Option bomOption = Option.builder((String)"b").longOpt("bom").hasArg().desc("Maven coordinates for a BOM").build();
        inputGroup.addOption(bomOption);
        Option artifactOption = Option.builder((String)"a").longOpt("artifacts").hasArgs().valueSeparator(',').desc("Maven coordinates for artifacts (separated by ',')").build();
        inputGroup.addOption(artifactOption);
        Option jarOption = Option.builder((String)"j").longOpt("jars").hasArgs().valueSeparator(',').desc("Jar files (separated by ',')").build();
        inputGroup.addOption(jarOption);
        Option repositoryOption = Option.builder((String)"m").longOpt("maven-repositories").hasArgs().valueSeparator(',').desc("Maven repository URLs to search for dependencies. The repositories are added to a repository list in order before the default Maven Central (http://repo1.maven.org/maven2/).").build();
        options.addOption(repositoryOption);
        Option noMavenCentralOption = Option.builder((String)"nm").longOpt("no-maven-central").hasArg(false).desc("Do not search Maven Central in addition to the repositories specified by -m. Useful when Maven Central is inaccessible.").build();
        options.addOption(noMavenCentralOption);
        Option reportOnlyReachable = Option.builder((String)"r").longOpt("report-only-reachable").hasArg(false).desc("Report only reachable linkage errors from the classes in the specified BOM or Maven artifacts").build();
        options.addOption(reportOnlyReachable);
        Option help = Option.builder((String)"h").longOpt("help").hasArg(false).desc("Show usage instructions").build();
        options.addOption(help);
        Option exclusionFile = Option.builder((String)"e").longOpt("exclusion-file").hasArg(true).desc("Exclusion file to filter out linkage errors based on conditions").build();
        options.addOption(exclusionFile);
        Option writeAsExclusionFile = Option.builder((String)"o").longOpt("output-exclusion-file").hasArg(true).desc("Output linkage errors as exclusion rules into the specified file").build();
        options.addOption(writeAsExclusionFile);
        options.addOptionGroup(inputGroup);
        return options;
    }

    ImmutableList<Artifact> getArtifacts() throws RepositoryException {
        if (this.cachedArtifacts != null) {
            return this.cachedArtifacts;
        }
        if (this.commandLine.hasOption("b")) {
            String bomCoordinates = this.commandLine.getOptionValue("b");
            this.cachedArtifacts = Bom.readBom(bomCoordinates, this.getMavenRepositoryUrls()).getManagedDependencies();
            return this.cachedArtifacts;
        }
        if (this.commandLine.hasOption("a")) {
            String[] mavenCoordinatesOption = this.commandLine.getOptionValues("a");
            this.cachedArtifacts = (ImmutableList)Arrays.stream(mavenCoordinatesOption).map(DefaultArtifact::new).collect(ImmutableList.toImmutableList());
            return this.cachedArtifacts;
        }
        return ImmutableList.of();
    }

    ImmutableList<ClassPathEntry> getJarFiles() throws IOException {
        if (this.commandLine.hasOption("j")) {
            String[] jarFiles = this.commandLine.getOptionValues("j");
            ImmutableList.Builder builder = ImmutableList.builder();
            for (String file : jarFiles) {
                builder.add((Object)new ClassPathEntry(Paths.get(file, new String[0]).toAbsolutePath()));
            }
            return builder.build();
        }
        throw new IllegalArgumentException("The arguments must have option 'j' to list JAR files");
    }

    ImmutableList<String> getMavenRepositoryUrls() {
        ImmutableList.Builder repositories = ImmutableList.builder();
        repositories.addAll(this.extraMavenRepositoryUrls);
        if (this.addMavenCentral) {
            repositories.add((Object)RepositoryUtility.CENTRAL.getUrl());
        }
        return repositories.build();
    }

    boolean getReportOnlyReachable() {
        return this.reportOnlyReachable;
    }

    boolean needsHelp() {
        return this.help || !this.hasInput();
    }

    void printHelp() {
        helpFormatter.printHelp("java com.google.cloud.tools.opensource.classpath.LinkageChecker", options);
    }

    boolean hasInput() {
        return this.commandLine.hasOption("b") || this.commandLine.hasOption("a") || this.commandLine.hasOption("j");
    }

    Path getInputExclusionFile() {
        if (this.commandLine.hasOption("e")) {
            return Paths.get(this.commandLine.getOptionValue("e"), new String[0]);
        }
        return null;
    }

    Path getOutputExclusionFile() {
        if (this.commandLine.hasOption("o")) {
            return Paths.get(this.commandLine.getOptionValue("o"), new String[0]);
        }
        return null;
    }
}

